// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef _SHAREDFILESTRL_H
#define _SHAREDFILESTRL_H

#include "MuleListCtrl.h"                   // Needed for CMuleListCtrl

#include <wx/menu.h>                        // Needed for wxMenu

class CKnownFile;
class CSharedFileList;
class wxMemoryDC;

class CSharedFilesCtrl : public CMuleListCtrl
{
public:
	CSharedFilesCtrl();
	CSharedFilesCtrl(wxWindow*& parent, int id, const wxPoint& pos, wxSize siz, int flags);
	virtual ~CSharedFilesCtrl();
	void	Init();
	void InitSort();
	void	ShowFileList(CSharedFileList* in_sflist);
	void	ShowFile(CKnownFile* file);
	void	ShowFile(CKnownFile* file, wxUint32 itemnr);
	void	RemoveFile(CKnownFile* toremove);
	void	UpdateFile(CKnownFile* file, wxUint32 pos);
	void	UpdateItem(CKnownFile* toupdate);
	void	Localize();
	void	ShowFilesCount();
protected:
	virtual void OnDrawItem(int item, wxDC* dc, const wxRect& rect, const wxRect& rectHL, bool highlighted);
	static int  SortProc(long lParam1, long lParam2, long lParamSort);
	void OnColumnClick(wxListEvent& evt);
	void OnNMRclick(wxListEvent& evt);
	DECLARE_EVENT_TABLE()

	virtual bool ProcessEvent(wxEvent& evt);
private:
	wxMenu* m_SharedFilesMenu;
	wxMenu		   m_PrioMenu;
	wxMenu		   m_PermMenu;
	CSharedFileList* sflist;
	bool		   sortstat[3];
public:
protected:
};

#endif
