// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "SharedFilesWnd.h"                 // Needed for this Interface's Prototype

#include "KnownFile.h"                      // Needed for CKnownFile::GetFileHash
#include "KnownFileList.h"                  // Needed for CKnownFileList
#include "muuli_wdr.h"                      // Needed for ID_SHFILELIST
#include "otherfunctions.h"                 // Needed for CastItoXBytes
#include "SharedFileList.h"                 // Needed for CKnownFileMap
#include "SharedFilesCtrl.h"                // Needed for CSharedFilesCtrl
#include "xmule.h"                          // Needed for theApp

#include <wx/gauge.h>                       // Needed for wxGauge
#include <wx/sizer.h>                       // Needed for wxSizer::Show
#include <wx/stattext.h>                    // Needed for wxStaticText

#define GetDlgItem(X) (wxStaticCast(wxWindow::FindWindowById((X)),wxStaticText))

BEGIN_EVENT_TABLE(CSharedFilesWnd, wxPanel)
EVT_LIST_ITEM_SELECTED(ID_SHFILELIST, CSharedFilesWnd::OnLvnItemActivateSflist)
EVT_BUTTON(IDC_RELOADSHAREDFILES, CSharedFilesWnd::OnBnClickedReloadsharedfiles)
END_EVENT_TABLE()

CSharedFilesWnd::CSharedFilesWnd(wxWindow *pParent): wxPanel(pParent, CSharedFilesWnd::IDD)
{
    memset(shownFileHash, 0, sizeof shownFileHash);
    SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    wxSizer *content = sharedfilesDlg(this, TRUE);
    content->Show(this, TRUE);
    pop_bar = (wxGauge *) FindWindowByName("popbar");
    pop_baraccept = (wxGauge *) FindWindowByName("popbarAccept");
    pop_bartrans = (wxGauge *) FindWindowByName("popbarTrans");
    // can't do here.
    //theApp.sharedfiles->SetOutputCtrl((CSharedFilesCtrl*)FindWindowByName("sharedFilesCt"));
    sharedfilesctrl = (CSharedFilesCtrl *)(FindWindowByName("sharedFilesCt"));
}

CSharedFilesWnd::~CSharedFilesWnd()
{
}

// CSharedFilesWnd message handlers
void CSharedFilesWnd::OnBnClickedReloadsharedfiles(wxCommandEvent& event)
{
    theApp.sharedfiles->Reload(true, false);
}

void CSharedFilesWnd::Check4StatUpdate(CKnownFile *file)
{
    if (!memcmp(file->GetFileHash(), shownFileHash, 16)) ShowDetails(file);
}

void CSharedFilesWnd::OnLvnItemActivateSflist(wxListEvent &evt)
{
    long item = - 1;
    wxODListCtrl *sflist = wxStaticCast(FindWindowById(ID_SHFILELIST), wxODListCtrl);
    item = sflist->GetNextItem(item, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
    if (item != ( - 1))
    {
        CKnownFile *cur_file = (CKnownFile *) sflist->GetItemData(item);
        ShowDetails(cur_file);
    }
}

void CSharedFilesWnd::ShowDetails(CKnownFile *cur_file)
{
    char buffer[100];
    pop_bartrans->SetRange(theApp.knownfiles->transfered/1024);
    pop_bartrans->SetValue(cur_file->statistic.GetTransfered() /1024);
    GetDlgItem(IDC_STRANSFERED)->SetLabel(CastItoXBytes(cur_file->statistic.GetTransfered()));
    pop_bar->SetRange(theApp.knownfiles->requested);
    pop_bar->SetValue(cur_file->statistic.GetRequests());
    sprintf(buffer, "%u", cur_file->statistic.GetRequests());
    GetDlgItem(IDC_SREQUESTED)->SetLabel(buffer);
    sprintf(buffer, "%u", cur_file->statistic.GetAccepts());
    pop_baraccept->SetRange(theApp.knownfiles->accepted);
    pop_baraccept->SetValue(cur_file->statistic.GetAccepts());
    GetDlgItem(IDC_SACCEPTED)->SetLabel(buffer);
    GetDlgItem(IDC_STRANSFERED2)->SetLabel(CastItoXBytes(cur_file->statistic.GetAllTimeTransfered()));
    sprintf(buffer, "%u", cur_file->statistic.GetAllTimeRequests());
    GetDlgItem(IDC_SREQUESTED2)->SetLabel(buffer);
    sprintf(buffer, "%u", cur_file->statistic.GetAllTimeAccepts());
    GetDlgItem(IDC_SACCEPTED2)->SetLabel(buffer);
    memcpy(shownFileHash, cur_file->GetFileHash(), 16);
}


void CSharedFilesWnd::Localize()
{
}

