// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#ifndef _SHAREDFILESWND_H
#define _SHAREDFILESWND_H

#include <wx/panel.h>                       // Needed for wxPanel

class CKnownFile;
class CSharedFilesCtrl;
class wxGauge;
class wxListEvent;

class CSharedFilesWnd: public wxPanel
{
public:
        CSharedFilesWnd(wxWindow* pParent = NULL);   // standard constructor
        virtual ~CSharedFilesWnd();
        void Localize();
        void Check4StatUpdate(CKnownFile* file);
// Dialog Data
        enum
        {
            IDD_FILES,
            IDD = IDD_FILES
        };
        CSharedFilesCtrl* sharedfilesctrl;

protected:
        DECLARE_EVENT_TABLE()

        void OnLvnItemActivateSflist(wxListEvent& evt);
        void OnBnClickedReloadsharedfiles(wxCommandEvent& event);
private:
        void ShowDetails(CKnownFile* cur_file);
        wxGauge* pop_bar;
        wxGauge* pop_baraccept;
        wxGauge* pop_bartrans;

        wxFont bold;
        unsigned char shownFileHash[16];
};
#endif
