// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "TransferWnd.h"                    // Needed for this Interface's Prototype

#include "CatDialog.h"                      // Needed for CCatDialog
#include "DownloadListCtrl.h"               // Needed for CDownloadListCtrl
#include "DownloadQueue.h"                  // Needed for CDownloadQueue
#include "MuleNotebook.h"                   // Needed for CMuleNotebook
#include "muuli_wdr.h"                      // Needed for transferDlg
#include "otherfunctions.h"                 // Needed for GetResString
#include "PartFile.h"                       // Needed for PR_LOW
#include "Preferences.h"                    // Needed for CPreferences
#include "QueueListCtrl.h"                  // Needed for CQueueListCtrl
#include "UploadListCtrl.h"                 // Needed for CUploadListCtrl
#include "UploadQueue.h"                    // Needed for CUploadQueue
#include "xmule.h"                          // Needed for theApp
#include "xmuleDlg.h"                       // Needed for theApp.xmuledlg

#include <wx/menu.h>                        // Needed for wxMenu
#include <wx/msgdlg.h>                      // Needed for wxMessageBox
#include <wx/sizer.h>                       // Needed for wxSizer::Show
#include <wx/splitter.h>                    // Needed for EVT_SPLITTER_SASH_POS_CHANGED
#include <wx/stattext.h>                    // Needed for wxStaticText

IMPLEMENT_DYNAMIC_CLASS(CTransferWnd, wxPanel)

BEGIN_EVENT_TABLE(CTransferWnd, wxPanel)
    EVT_SPLITTER_SASH_POS_CHANGED(ID_SPLATTER, CTransferWnd::OnSashPositionChanged)
END_EVENT_TABLE()

class CatMenuHandler: public wxEvtHandler
{
private:
    bool CatMenu;
    CTransferWnd* m_parent;

public:
    CatMenuHandler(CTransferWnd* parent)
    {
        m_parent = parent;
        CatMenu = false;
    }

private:
    DECLARE_EVENT_TABLE()

    void HandleMenu(wxCommandEvent& event)
    {
        switch (event.GetId())
        {
            case MP_CAT_SET0:
            case MP_CAT_SET0 + 1:
            case MP_CAT_SET0 + 2:
            case MP_CAT_SET0 + 3:
            case MP_CAT_SET0 + 4:
            case MP_CAT_SET0 + 5:
            case MP_CAT_SET0 + 6:
            case MP_CAT_SET0 + 7:
            case MP_CAT_SET0 + 8:
            case MP_CAT_SET0 + 9:
            case MP_CAT_SET0 + 10:
            case MP_CAT_SET0 + 11:
            case MP_CAT_SET0 + 12:
            case MP_CAT_SET0 + 13:
            case MP_CAT_SET0 + 14:
            {
                theApp.glob_prefs->SetAllcatType(event.GetId() - MP_CAT_SET0);
                sprintf(theApp.glob_prefs->GetCategory(0)->title, "%s", GetCatTitle(theApp.glob_prefs->GetAllcatType()).c_str());
                CString csName;
                csName.Format("%s", theApp.glob_prefs->GetCategory(0)->title);
                m_parent->EditCatTabLabel(0, csName);
                m_parent->downloadlistctrl->ChangeCategory(0);
                m_parent->downloadlistctrl->InitSort();
                break;
            }
            case MP_CAT_ADD:
            {
                int newindex = m_parent->AddCategorie(wxT("?"), theApp.glob_prefs->GetIncomingDir(), "", false);
                wxPanel *nullPanel = new wxPanel(m_parent->m_dlTab, - 1);
                m_parent->m_dlTab->AddPage(nullPanel, theApp.glob_prefs->GetCategory(newindex)->title);
                CCatDialog dialog(NULL, newindex);
                dialog.OnInitDialog();
                dialog.ShowModal();
                m_parent->EditCatTabLabel(newindex, theApp.glob_prefs->GetCategory(newindex)->title);
                // Save Cats
                theApp.glob_prefs->Save(2);
                break;
            }
            case MP_CAT_EDIT:
            {
                CCatDialog dialog(NULL, m_parent->m_dlTab->GetSelection());
                dialog.OnInitDialog();
                dialog.ShowModal();
                CString csName;
                csName.Format("%s", theApp.glob_prefs->GetCategory(m_parent->m_dlTab->GetSelection())->title);
                m_parent->EditCatTabLabel(m_parent->m_dlTab->GetSelection(), csName);
                //arning TODO: fix this
                //theApp.emuledlg->searchwnd.UpdateCatTabs();
                // Save Cats            
                theApp.glob_prefs->Save(2);
                break;
            }
            case MP_CAT_REMOVE:
            {
                if (m_parent->m_dlTab->GetSelection() != 0)
                {
                    theApp.downloadqueue->ResetCatParts(m_parent->m_dlTab->GetSelection());
                    theApp.glob_prefs->RemoveCat(m_parent->m_dlTab->GetSelection());
                    m_parent->m_dlTab->RemovePage(m_parent->m_dlTab->GetSelection());
                    m_parent->m_dlTab->SetSelection(0);
                    m_parent->downloadlistctrl->ChangeCategory(0);
                    // Save Cats            
                    theApp.glob_prefs->Save(2);
                    if (theApp.glob_prefs->GetCatCount() == 1) theApp.glob_prefs->SetAllcatType(0);
                    //arning TODO: fix this
                    //theApp.emuledlg->searchwnd.UpdateCatTabs();
                }
                break;
            }
            case MP_PRIOLOW:
            {
                theApp.downloadqueue->SetCatPrio(m_parent->m_dlTab->GetSelection(), PR_LOW);
                break;
            }
            case MP_PRIONORMAL:
            {
                theApp.downloadqueue->SetCatPrio(m_parent->m_dlTab->GetSelection(), PR_NORMAL);
                break;
            }
            case MP_PRIOHIGH:
            {
                theApp.downloadqueue->SetCatPrio(m_parent->m_dlTab->GetSelection(), PR_HIGH);
                break;
            }
            case MP_PRIOAUTO:
            {
                theApp.downloadqueue->SetCatPrio(m_parent->m_dlTab->GetSelection(), PR_AUTO);
                break;
            }
            case MP_PAUSE:
            {
                theApp.downloadqueue->SetCatStatus(m_parent->m_dlTab->GetSelection(), MP_PAUSE);
                break;
            }
            case MP_STOP:
            {
                theApp.downloadqueue->SetCatStatus(m_parent->m_dlTab->GetSelection(), MP_STOP);
                break;
            }
            case MP_CANCEL:
            {
                if (wxMessageBox(GetResString(IDS_CATEGORY_DELETE), GetResString(IDS_CONFIRMATION), wxYES_NO | wxCENTRE | wxICON_EXCLAMATION) == wxYES)
                {
                    theApp.downloadqueue->SetCatStatus(m_parent->m_dlTab->GetSelection(), MP_CANCEL);
                }
                break;
            }
            case MP_RESUME:
            {
                theApp.downloadqueue->SetCatStatus(m_parent->m_dlTab->GetSelection(), MP_RESUME);
                break;
            }
            case MP_RESUME_NEXT:
            {
                theApp.downloadqueue->StartNextFile();
                break;
            }
            case IDC_UPLOAD_ICO:
            {
                wxCommandEvent nullEvt;
                m_parent->SwitchUploadList(nullEvt);
                break;
            }
            case IDC_QUEUE_REFRESH_BUTTON:
            {
                //arning TODO: fix this
                //OnBnClickedQueueRefreshButton();
                break;
            }
        }
        event.Skip();
    }

    void HandleRightClick(wxMouseEvent& event)
    {
        CMuleNotebook* nb = static_cast<CMuleNotebook *>(m_parent->FindWindowById(ID_CATEGORIES));
        if (nb != NULL && nb->GetSelection() == -1)
        {
            return;
        }
        // Avoid opening another menu when it's already open
        if (CatMenu == false)
        {
            CatMenu = true;
            wxMenu* menu = new wxMenu(GetResString(IDS_CAT));
            menu->SetEventHandler(this);

            if (nb->GetSelection() == 0)
            {
                wxMenu* m_CatMenu = new wxMenu();
                m_CatMenu->Append(MP_CAT_SET0, GetResString(IDS_ALL));
                m_CatMenu->Append(MP_CAT_SET0 + 1, GetResString(IDS_ALLOTHERS));
                m_CatMenu->AppendSeparator();
                m_CatMenu->Append(MP_CAT_SET0 + 2, GetResString(IDS_STATUS_NOTCOMPLETED));
                m_CatMenu->Append(MP_CAT_SET0 + 3, GetResString(IDS_DL_TRANSFCOMPL));
                m_CatMenu->Append(MP_CAT_SET0 + 4, GetResString(IDS_WAITING));
                m_CatMenu->Append(MP_CAT_SET0 + 5, GetResString(IDS_DOWNLOADING));
                m_CatMenu->Append(MP_CAT_SET0 + 6, GetResString(IDS_ERRORLIKE));
                m_CatMenu->Append(MP_CAT_SET0 + 7, GetResString(IDS_PAUSED));
                m_CatMenu->Append(MP_CAT_SET0 + 8, GetResString(IDS_STOPPED));
                m_CatMenu->AppendSeparator();
                m_CatMenu->Append(MP_CAT_SET0 + 9, GetResString(IDS_VIDEO));
                m_CatMenu->Append(MP_CAT_SET0 + 10, GetResString(IDS_AUDIO));
                m_CatMenu->Append(MP_CAT_SET0 + 11, GetResString(IDS_SEARCH_ARC));
                m_CatMenu->Append(MP_CAT_SET0 + 12, GetResString(IDS_SEARCH_CDIMG));
                m_CatMenu->Append(MP_CAT_SET0 + 13, GetResString(IDS_SEARCH_PICS));
                m_CatMenu->Append(MP_CAT_SET0 + 14, GetResString(IDS_TEXT));
                //m_CatMenu.CheckMenuItem( MP_CAT_SET0+theApp.glob_prefs->GetAllcatType() , MF_CHECKED | MF_BYCOMMAND);
                menu->Append(47321, GetResString(IDS_CHANGECATVIEW), m_CatMenu);
            }
            menu->Append(MP_CAT_ADD, GetResString(IDS_CAT_ADD));
            menu->Append(MP_CAT_EDIT, GetResString(IDS_CAT_EDIT));
            menu->Append(MP_CAT_REMOVE, GetResString(IDS_CAT_REMOVE));
            menu->AppendSeparator();
//            menu->Append(472834, GetResString(IDS_PRIORITY), m_PrioMenu);
            menu->Append(MP_CANCEL, GetResString(IDS_MAIN_BTN_CANCEL));
            menu->Append(MP_STOP, GetResString(IDS_DL_STOP));
            menu->Append(MP_PAUSE, GetResString(IDS_DL_PAUSE));
            menu->Append(MP_RESUME, GetResString(IDS_DL_RESUME));
            menu->Append(MP_RESUME_NEXT, GetResString(IDS_DL_RESUMENEXT));
            // the point coming from mulenotebook control isn't in screen coordinates
            // (unlike std mouse event, which always returns screen coordinates)
            // so we must do the conversion here
            wxPoint pt = event.GetPosition();
            wxPoint newpt = nb->ClientToScreen(pt);
            newpt = m_parent->ScreenToClient(newpt);
            m_parent->PopupMenu(menu, newpt);
    //        delete menu;
            CatMenu = false;
        }
    }
    void HandleChangedTab(wxNotebookEvent& event)
    {
        m_parent->downloadlistctrl->ChangeCategory(event.GetSelection());
        m_parent->downloadlistctrl->InitSort();
    }
};

BEGIN_EVENT_TABLE(CatMenuHandler, wxEvtHandler)
    EVT_MENU(-1, CatMenuHandler::HandleMenu)
    EVT_RIGHT_DOWN(CatMenuHandler::HandleRightClick)
    EVT_NOTEBOOK_PAGE_CHANGED(ID_CATEGORIES, CatMenuHandler::HandleChangedTab)
END_EVENT_TABLE()


CTransferWnd::CTransferWnd(wxWindow *pParent): wxPanel(pParent, CTransferWnd::IDD)
{
    SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    wxSizer *content = transferDlg(this, TRUE);
    content->Show(this, TRUE);
    wxSplitterWindow *split = (wxSplitterWindow *) FindWindow("splitterWnd");
    wxPanel *subContent1 = new wxPanel(split, - 1);
    subContent1->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    wxSizer *subC1 = transferTopPane(subContent1, TRUE);
    wxPanel *subContent2 = new wxPanel(split, - 1);
    subContent2->SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_WINDOWFRAME));
    wxSizer *subC2 = transferBottomPane(subContent2, FALSE);
    split->SplitHorizontally(subContent1, subContent2);
    uploadlistctrl = (CUploadListCtrl *) FindWindowByName("uploadList");
    downloadlistctrl = (CDownloadListCtrl *) FindWindowByName("downloadList");
    queuelistctrl = (CQueueListCtrl *) FindWindowByName("uploadQueue");
    // let's hide the queue
    queueSizer->Remove(queuelistctrl);
    subC2->SetDimension(0, 0, 100, 50);
    queueSizer->Layout();
    //subC2->Layout();
    queuelistctrl->Show(FALSE);
    // allow notebook to dispatch right mouse clicks to us

    CMuleNotebook *nb = (CMuleNotebook *) FindWindowById(ID_CATEGORIES);
    CatMenuHandler* cathandler = new CatMenuHandler(this);
    nb->SetEventHandler(cathandler);
    windowtransferstate = false;
}

CTransferWnd::~CTransferWnd()
{
}

bool CTransferWnd::OnInitDialog()
{
    m_dlTab = (CMuleNotebook *) FindWindowById(ID_CATEGORIES);
    // show & cat-tabs
    sprintf(theApp.glob_prefs->GetCategory(0)->title, "%s", GetCatTitle(theApp.glob_prefs->GetAllcatType()).c_str());
    sprintf(theApp.glob_prefs->GetCategory(0)->incomingpath, "%s", theApp.glob_prefs->GetIncomingDir());
    for (int ix = 0 ; ix < theApp.glob_prefs->GetCatCount() ; ix++)
    {
        wxPanel *nullPanel = new wxPanel(m_dlTab);
        wxString tmpstrstr(theApp.glob_prefs->GetCategory(ix)->title);
        // just temporary string.:
        m_dlTab->AddPage(nullPanel, "-");
        // for some odd reason, wxwin2.5 and gtk2 will not allow non utf strings for AddPage()
        // but they will be accepted in SetPageText().. so let's use this as a countermeasure
        m_dlTab->SetPageText(ix, tmpstrstr);
    }
    return true;
}

void CTransferWnd::ShowQueueCount(wxUint32 number)
{
    char buffer[100];
    wxString fmtstr = "%u (%u " + GetResString(IDS_BANNED) .MakeLower() + ")";
    sprintf(buffer, fmtstr.GetData(), number, theApp.uploadqueue->GetBanCount());
    wxStaticCast(FindWindowByName("clientCount"), wxStaticText)->SetLabel(buffer);
    //this->GetDlgItem(IDC_QUEUECOUNT)->SetWindowText(buffer);
}

void CTransferWnd::SetInitLayout()
{
}

void CTransferWnd::DoResize(int delta)
{
}

// setting splitter range limits
void CTransferWnd::UpdateSplitterRange()
{
}

void CTransferWnd::UpdateToolTips(void)
{
}

int CTransferWnd::GetItemUnderMouse(wxListCtrl *ctrl)
{
}

void CTransferWnd::SwitchUploadList(wxCommandEvent &evt)
{
    if (windowtransferstate == false)
    {
        windowtransferstate = true;
        // hide the upload list
        queueSizer->Remove(uploadlistctrl);
        uploadlistctrl->Show(FALSE);
        queueSizer->Add(queuelistctrl, 1, wxGROW |wxALIGN_CENTER_VERTICAL |wxALL, 5);
        queuelistctrl->Show();
        queueSizer->Layout();
        wxStaticCast(FindWindowByName("uploadTitle"), wxStaticText)->SetLabel(GetResString(IDS_ONQUEUE));
    }
    else
    {
        windowtransferstate = false;
        // hide the queuelist
        queueSizer->Remove(queuelistctrl);
        queuelistctrl->Show(FALSE);
        queueSizer->Add(uploadlistctrl, 1, wxGROW |wxALIGN_CENTER_VERTICAL |wxALL, 5);
        uploadlistctrl->Show();
        queueSizer->Layout();
        wxStaticCast(FindWindowByName("uploadTitle"), wxStaticText)->SetLabel(GetResString(IDS_TW_UPLOADS));
    }
}

void CTransferWnd::Localize()
{
}

void CTransferWnd::OnNMRclickDLtab(wxMouseEvent &evt)
{
}

int CTransferWnd::AddCategorie(CString newtitle, CString newincoming, CString newcomment, bool addTab)
{
    Category_Struct *newcat = new Category_Struct;
    sprintf(newcat->title, "%s", newtitle.GetBuffer());
    newcat->prio = 0;
    sprintf(newcat->incomingpath, "%s", newincoming.GetBuffer());
    sprintf(newcat->comment, "%s", newcomment.GetBuffer());
    int index = theApp.glob_prefs->AddCat(newcat);
    if (addTab)
    {
        wxPanel *nullPanel = new wxPanel(m_dlTab, - 1);
        m_dlTab->AddPage(nullPanel, newtitle);
    }
    return index;
}

void CTransferWnd::EditCatTabLabel(int index, CString newlabel)
{
    if (theApp.glob_prefs->ShowCatTabInfos())
    {
        CPartFile *cur_file;
        uint16 count, dwl;
        count = dwl = 0;
        for (int i = 0 ; i < theApp.downloadqueue->GetFileCount() ; i++)
        {
            cur_file = theApp.downloadqueue->GetFileByIndex(i);
            if (cur_file == 0) continue;
            if (CheckShowItemInGivenCat(cur_file, index))
            {
                count++;
                if (cur_file->GetTransferingSrcCount() > 0) dwl++;
            }
        }
        CString title = newlabel;
        newlabel.Format("%s (%i/%i)", title.GetData(), dwl, count);
    }
    m_dlTab->SetPageText(index, newlabel);
}

void CTransferWnd::OnSashPositionChanged(wxSplitterEvent& event)
{
    theApp.xmuledlg->split_pos = ((wxSplitterWindow *) FindWindow("splitterWnd"))->GetSashPosition();
}

