// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, 
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _TRANSFERWND_H
#define _TRANSFERWND_H

#include <wx/panel.h>                       // Needed for wxPanel

class CatMenuHandler;
class CDownloadListCtrl;
class CMuleNotebook;
class CQueueListCtrl;
class CString;
class CUploadListCtrl;
class wxListCtrl;
class wxMouseEvent;
class wxNotebookEvent;
class wxSplitterEvent;

class CTransferWnd : public wxPanel
{
friend class CatMenuHandler;
  DECLARE_DYNAMIC_CLASS(CTransferWnd)

public:
	CTransferWnd(wxWindow* pParent = NULL);   // standard constructor
	virtual ~CTransferWnd();
	void	ShowQueueCount(wxUint32 number);
	void	SwitchUploadList(wxCommandEvent& evt);
	void	Localize();
	bool	OnInitDialog();
// Dialog Data
	enum { IDD };
	CUploadListCtrl*		uploadlistctrl;
	CDownloadListCtrl*	downloadlistctrl;
	CQueueListCtrl*		queuelistctrl;
	bool			windowtransferstate;
	DECLARE_EVENT_TABLE()

protected:
	void DoResize(int delta);
	void UpdateSplitterRange();
	void SetInitLayout();

	void DoSplitResize(int delta);
	void UpdateToolTips(void);
	int GetItemUnderMouse(wxListCtrl* ctrl);
    void OnSelchangeDltab(wxNotebookEvent& evt);
    void OnNMRclickDLtab(wxMouseEvent& evt);
    void OnSashPositionChanged(wxSplitterEvent& event);


	int AddCategorie(CString newtitle, CString newincoming, CString newcomment, bool addTab);
	void EditCatTabLabel(int index, CString newlabel);

	CMuleNotebook* m_dlTab;

private:
	wxString m_strToolTip;
	int m_iOldToolTipItemDown;
	int m_iOldToolTipItemUp;
	int m_iOldToolTipItemQueue;	
	int rightclickindex;
	bool CatMenu;
};
#endif
