/////////////////////////////////////////////////////////////////////////////
// Name:        TreeMultiItemWindow.cpp
// Author:      Jorgen Bodde
// Created:     Tuesday, February 24, 2004 22:42:08
// Copyright:   (c) Jorgen Bodde, based on wxWidgets License
/////////////////////////////////////////////////////////////////////////////

/* for compilers that support precompilation
   includes "wx/wx.h" */

#include "wx/wxprec.h"

#ifdef __BORLANDC__
    #pragma hdrstop
#endif

#include "TreeMultiItemWindow.h"

#include <wx/window.h>                      // Needed for wxWindow

/** TreeMultiItemWindow
  *	This class is a possible end node for the tree. If you want multiple
  *	types of end-nodes you should copy this file and adjust it with a 
  *	different class name.
  */

TreeMultiItemWindow::TreeMultiItemWindow(TreeMultiItemNode *parent, const wxString &name, int width)
	:  TreeMultiItemBase(parent)
	, _window(0)
	, _topSpacing(0)
	, _frontSpacing(0),
    m_width(width)
{
    _name = name;

	// TODO: Enter your constructor code here
}

TreeMultiItemWindow::~TreeMultiItemWindow()
{
	if(_window)
		_window->Destroy();
}

void TreeMultiItemWindow::AssignWindow(wxWindow *wnd)
{
	// delete previous, assign new (even if zero)
	if(_window)
		_window->Destroy();

	_window = wnd;

	// recalculate the size
	if(wnd)
	{
		wxSize size; 

		// resize the sized control by sizer or 
		// by single window. For a sizer handled window
		// GetBestSize returns the optimal size

		/// \todo This might need rivision for retaining the sizer size
		/// maybe we need to check whether size is <> 0,0 before get best size

		if(wnd->GetSizer())
			size = wnd->GetBestSize();
		else
			size = wnd->GetSize();

		_height = size.GetHeight();
        if (m_width == -1)
            _width = size.GetWidth();
        else
            _width = m_width;
	}
	else
	{
		_height = 0;
		_width = 0;
	}
}
