// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#include <gtk/gtk.h>
#include <gtk/gtkprivate.h>

#include <gdk/gdkkeysyms.h>
#include <gdk/gdkx.h>

#include "gtk2-funcs.h"

extern guint32 gtk2_get_current_event_time (void);

guint32
gtk2_get_current_event_time (void)
{
	GdkEvent *ev = gtk_get_current_event();
	if ( ev ) {
		guint32 result;
		result = gdk_event_get_time(ev);
		gdk_event_free(ev);
		return result;
	} else {
		return GDK_CURRENT_TIME;
	}

}

