// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (donate@xmule.org / http://www.xmule.org/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#endif

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "ldaemon.h"                        // Needed for this Interface's Prototype

#include <sys/stat.h>                       // Needed for mkdir

CLDaemon::CLDaemon()
{
}

CLDaemon::~CLDaemon()
{
}

void CLDaemon::Init()
{
    char *names[]={"command","status","output","server","download","upload"};
    int i;

    wxString PrefDir = getenv("HOME") + wxString("/.xMule/nowindow");
    if (!wxDirExists(PrefDir))
    {
        mkdir(PrefDir, 0777);
    }

    //
    // LD_COMMAND
    FName[0] = PrefDir + wxString("/") + wxString (names[0]);
    if (Ftmp.Open (FName[0],wxFile::write))
	Ftmp.Close ();
    else
        printf ("Can't open nowindow/$s file\n",names[0]);
    
    for (i=LD_STATUS;i<LD_NUMBER;++i)
    {
    	FName[i] = PrefDir + wxString("/") + wxString (names[i]);
	wxRemoveFile (FName[i]);
    }
}

void CLDaemon::Print (wxString Data, int type, bool erase)
{
    wxFile::OpenMode open_type;

    if (erase)
	open_type = wxFile::write;
    else
	open_type = wxFile::write_append;

    if (!Ftmp.Open (FName[type], open_type))
	return;
    Ftmp.Write (Data + wxString ("\n"));
    Ftmp.Close ();
}

bool CLDaemon::Read (wxString &Data, int type)
{
    int l,read;
    char *string;

    if (type<0 || type>=LD_NUMBER)
	return (false);

    if (!Ftmp.Open (FName[type],wxFile::read))
	return (false);

    l=Ftmp.Length ();
    if (!l)
    {
	Ftmp.Close ();
	return (false);
    }
    string=new char[l+1];
    read=Ftmp.Read (string,l);
    Ftmp.Close ();
    string[read-1]=0;

    if (Ftmp.Create (FName[type],true))
	Ftmp.Close ();

    if (read != l)
    {
	delete string;
	return (false); 
    }

    Data=string;
    delete string;
}

bool CLDaemon::ReadCommand ()
{
    if (!Read (Command,LD_COMMAND))
	return (false);

    return (true);
}

bool CLDaemon::Delete (int type)
{
    if (type<0 || type>=LD_NUMBER)
        return (false);

    return (wxRemoveFile (FName[type]));
}
