// This file is a part of the xmule project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This file was a part of eMule
// Copyright (c) 2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _OPCODES_H
#define _OPCODES_H

static const short int ET_MOD_VERSION = 0x55;
// MOD Note: Do not change this part - Merkur
static const short int CURRENT_VERSION_SHORT = 0x30;
static const short int EMULE_PROTOCOL = 0x01;
// MOD Note: end
static const short int EDONKEYVERSION = 0x3c;
static const short int PREFFILE_VERSION = 0x14;         //<<-- last change: reduced .dat, by using .ini
static const short int PARTFILE_VERSION = 0xe0;
static const short int CREDITFILE_VERSION = 0x12;
static const short int CREDITFILE_VERSION_29 = 0x11;

// MOD Note: Do not change this part - Merkur
static const int UDPSEARCHSPEED = 1000;                 // if this value is too low you will miss sources
static const short int MAX_RESULTS = 100;               // max global search results
static const short int MAX_CLIENTCONNECTIONTRY = 2;
static const long int CONNECTION_TIMEOUT = 40000;       // set his lower if you want less connections at once, set it higher if you have enough sockets (edonkey has its own timout too, so a very high value won't effect this)
static const long int FILEREASKTIME = 1300000;          // **
static const long int SERVERREASKTIME = 800000;         // don't set this too low, it wont speed up anything, but it could kill xmule or your internetconnection
static const long int UDPSERVERREASKTIME = 1300000;     // ***
static const long int SOURCECLIENTREASK = 600000;
static const short int MINCOMMONPENALTY = 9;
static const int UDPSERVERSTATTIME = 5000;
static const long int UDPSERVSTATREASKTIME = 14400000;
static const int UDPSERVERPORT = 4665;                  // default udp port
static const short int MIN_UP_CLIENTS_ALLOWED = 3;      // min. clients allowed to download regardless UPLOAD_CLIENT_DATARATE or any other factors. Don't set this too high
// MOD Note: end

static const short int MAXCONPER5SEC = 20;
static const short int MAXCON5WIN9X = 10;
static const int UPLOAD_CHECK_CLIENT_DR = 1000;
static const int UPLOAD_LOW_CLIENT_DR = 2400;           // uploadspeed per client in bytes - you may want to adjust this if you have a slow connection or T1-T3 ;)
static const int UPLOAD_CLIENT_DATARATE = 2048;
static const short int MAX_UP_CLIENTS_ALLOWED = 100;    // max. clients allowed regardless UPLOAD_CLIENT_DATARATE or any other factors. Don't set this too low, use DATARATE to adjust uploadspeed per client
static const long int DOWNLOADTIMEOUT = 100000;
static const int CONSERVTIMEOUT = 25000;                // agelimit for pending connection attempts
static const short int RARE_FILE = 25;
static const short int BADCLIENTBAN = 3;
static const long int MIN_REQUESTTIME = 590000;
static const long int MAX_PURGEQUEUETIME = 3600000;
static const int CONNECTION_LATENCY = 22050;            // latency for responces
static const short int SOURCESSLOTS = 100;
static const int MINWAIT_BEFORE_DLDISPLAY_WINDOWUPDATE = 1000;
static const int MAXAVERAGETIME = 40000;                //milliseconds

// you shouldn't change anything here if you are not really sure, or xmule will probaly not work
static const int MAXFRAGSIZE = 1300;
static const long int PARTSIZE = 9728000;
static const long int GAPBLOCKSIZE = 184320;
static const short int OP_EDONKEYPROT = 0xE3;
static const short int OP_PACKEDPROT = 0xD4;
static const short int OP_EMULEPROT = 0xC5;
static const short int OP_MLDONKEYPROT = 0x00;
static const short int MET_HEADER = 0x0E;

static const long int UNLIMITED = 0xFFFF;

// client <-> server
static const short int OP_LOGINREQUEST = 0x01;          //<HASH 16><ID 4><PORT 2><1 Tag_set>
static const short int OP_REJECT = 0x05;                //(null)
static const short int OP_GETSERVERLIST = 0x14;         //(null)client->server
static const short int OP_OFFERFILES = 0x15;            // <count 4>(<HASH 16><ID 4><PORT 2><1 Tag_set>)[count]
static const short int OP_SEARCHREQUEST = 0x16;         // <Query_Tree>
static const short int OP_DISCONNECT = 0x18;            // (not verified)
static const short int OP_GETSOURCES = 0x19;            // <HASH 16>
static const short int OP_SEARCH_USER = 0x1A;           // <Query_Tree>
static const short int OP_CALLBACKREQUEST = 0x1C;       // <ID 4>
static const short int OP_QUERY_CHATS = 0x1D;           // (deprecated not supported by server any longer)
static const short int OP_CHAT_MESSAGE = 0x1E;          // (deprecated not supported by server any longer)
static const short int OP_JOIN_ROOM = 0x1F;             // (deprecated not supported by server any longer)
static const short int OP_QUERY_MORE_RESULT = 0x21;     // (null)
static const short int OP_SERVERLIST = 0x32;            // <count 1>(<IP 4><PORT 2>)[count] server->client
static const short int OP_SEARCHRESULT = 0x33;          // <count 4>(<HASH 16><ID 4><PORT 2><1 Tag_set>)[count]
static const short int OP_SERVERSTATUS = 0x34;          // <USER 4><FILES 4>
static const short int OP_CALLBACKREQUESTED = 0x35;     // <IP 4><PORT 2>
static const short int OP_CALLBACK_FAIL = 0x36;         // (null notverified)
static const short int OP_SERVERMESSAGE = 0x38;         // <len 2><Message len>
static const short int OP_CHAT_ROOM_REQUEST = 0x39;     // (deprecated not supported by server any longer)
static const short int OP_CHAT_BROADCAST = 0x3A;        // (deprecated not supported by server any longer)
static const short int OP_CHAT_USER_JOIN = 0x3B;        // (deprecated not supported by server any longer)
static const short int OP_CHAT_USER_LEAVE = 0x3C;       // (deprecated not supported by server any longer)
static const short int OP_CHAT_USER = 0x3D;             // (deprecated not supported by server any longer)
static const short int OP_IDCHANGE = 0x40;              // <NEW_ID 4>
static const short int OP_SERVERIDENT = 0x41;           // <HASH 16><IP 4><PORT 2>{1 TAG_SET}
static const short int OP_FOUNDSOURCES = 0x42;          // <HASH 16><count 1>(<ID 4><PORT 2>)[count]
static const short int OP_USERS_LIST = 0x43;            // <count 4>(<HASH 16><ID 4><PORT 2><1 Tag_set>)[count]

//client <-> UDP server
static const short int OP_GLOBSEARCHREQ2 = 0x92;         // <search_tree_extended>
static const short int OP_GLOBSERVSTATREQ = 0x96;       // (null)
static const short int OP_GLOBSERVSTATRES = 0x97;       // <USER 4><FILES 4>
static const short int OP_GLOBSEARCHREQ = 0x98;         // <search_tree>
static const short int OP_GLOBSEARCHRES = 0x99;
static const short int OP_GLOBGETSOURCES = 0x9A;        // <HASH 16>
static const short int OP_GLOBFOUNDSOURCES = 0x9B;
static const short int OP_GLOBCALLBACKREQ = 0x9C;       // <IP 4><PORT 2><client_ID 4>
static const short int OP_INVALID_LOWID = 0x9E;         // <ID 4>
static const short int OP_SERVER_LIST_REQ = 0xA0;       // <IP 4><PORT 2>
static const short int OP_SERVER_LIST_RES = 0xA1;       // <count 1> (<ip 4><port 2>)[count]
static const short int OP_SERVER_DESC_REQ = 0xA2;       // (null)
static const short int OP_SERVER_DESC_RES = 0xA3;       // <name_len 2><name name_len><desc_len 2 desc_en>
static const short int OP_SERVER_LIST_REQ2 = 0xA4;       // (null)

// client <-> client
static const short int OP_HELLO = 0x01;                 // 0x10<HASH 16><ID 4><PORT 2><1 Tag_set>
static const short int OP_SENDINGPART = 0x46;           // <HASH 16><von 4><bis 4><Daten len:(von-bis)>
static const short int OP_REQUESTPARTS = 0x47;          // <HASH 16><von[3] 4*3><bis[3] 4*3>
static const short int OP_FILEREQANSNOFIL = 0x48;       // <HASH 16>
static const short int OP_END_OF_DOWNLOAD = 0x49;       // <HASH 16>
static const short int OP_ASKSHAREDFILES = 0x4A;        // (null)
static const short int OP_ASKSHAREDFILESANSWER = 0x4B;  // <count 4>(<HASH 16><ID 4><PORT 2><1 Tag_set>)[count]
static const short int OP_HELLOANSWER = 0x4C;           // <HASH 16><ID 4><PORT 2><1 Tag_set><SERVER_IP 4><SERVER_PORT 2>
static const short int OP_CHANGE_CLIENT_ID = 0x4D;      // <ID_old 4><ID_new 4>
static const short int OP_MESSAGE = 0x4E;               // <len 2><Message len>
static const short int OP_SETREQFILEID = 0x4F;          // <HASH 16>
static const short int OP_FILESTATUS = 0x50;            // <HASH 16><count 2><status(bit array) len:((count+7)/8)>
static const short int OP_HASHSETREQUEST = 0x51;        // <HASH 16>
static const short int OP_HASHSETANSWER = 0x52;         // <count 2><HASH[count] 16*count>
static const short int OP_STARTUPLOADREQ = 0x54;        // <HASH 16>
static const short int OP_ACCEPTUPLOADREQ = 0x55;       // (null)
static const short int OP_CANCELTRANSFER = 0x56;        // (null)
static const short int OP_OUTOFPARTREQS = 0x57;         // (null)
static const short int OP_FILEREQUEST = 0x58;           // <HASH 16> (more correctly file_name_request)
static const short int OP_FILEREQANSWER = 0x59;         // <HASH 16><len 4><NAME len>
static const short int OP_CHANGE_SLOT = 0x5B;           // <HASH 16>
static const short int OP_QUEUERANK = 0x5C;             // <wert  4> (slot index of the request)
static const short int OP_ASKSHAREDDIRS = 0x5D;         // (null)
static const short int OP_ASKSHAREDFILESDIR = 0x5E;     // <len 2><Directory len>
static const short int OP_ASKSHAREDDIRSANS = 0x5F;      // <count 4>(<len 2><Directory len>)[count]
static const short int OP_ASKSHAREDFILESDIRANS = 0x60;  // <len 2><Directory len><count 4>(<HASH 16><ID 4><PORT 2><1 Tag_set>)[count]
static const short int OP_ASKSHAREDDENIEDANS = 0x61;    // (null)



// extened prot client <-> extened prot client
static const short int OP_EMULEINFO = 0x01;
static const short int OP_EMULEINFOANSWER = 0x02;
static const short int OP_COMPRESSEDPART = 0x40;
static const short int OP_QUEUERANKING = 0x60;          // <RANG 2>
static const short int OP_FILEDESC = 0x61;              // <len 2><NAME len>
static const short int OP_VERIFYUPSREQ = 0x71;          // (never used)
static const short int OP_VERIFYUPSANSWER = 0x72;       // (never used)
static const short int OP_UDPVERIFYUPREQ = 0x73;        // (never used)
static const short int OP_UDPVERIFYUPA = 0x74;          // (never used)
static const short int OP_REQUESTSOURCES = 0x81;        // <HASH 16>
static const short int OP_ANSWERSOURCES = 0x82;
static const short int OP_PUBLICKEY = 0x85;             // <len 1><pubkey len>
static const short int OP_SIGNATURE = 0x86;             // v1: <len 1><signature len> v2:<len 1><signature len><sigIP used 1>
static const short int OP_SECIDENTSTATE = 0x87;         // <state 1><rndchallenge 4>
static const short int OP_REQUESTPREVIEW = 0x90;        // <HASH 16>
static const short int OP_PREVIEWANSWER = 0x91;         // <HASH 16><frames 1>{ frames * <len 4><frame len>}

// extened prot client <-> extened prot client UDP
static const short int OP_REASKFILEPING = 0x90;         // <HASH 16>
static const short int OP_REASKACK = 0x91;              // <RANG 2>
static const short int OP_FILENOTFOUND = 0x92;          // (null)
static const short int OP_QUEUEFULL = 0x93;             // (null)
	
// server.met
static const short int ST_SERVERNAME = 0x01;            // <string>
static const short int ST_DESCRIPTION = 0x0B;           // <string>
static const short int ST_PING = 0x0C;                  // <int>
static const short int ST_PREFERENCE = 0x0E;            // <int>
static const short int ST_FAIL = 0x0D;                  // <int>
static const short int ST_DYNIP = 0x85;
static const short int ST_MAXUSERS = 0x87;
static const short int ST_SOFTFILES = 0x88;
static const short int ST_HARDFILES = 0x89;
static const short int ST_LASTPING = 0x86;
static const short int ST_VERSION = 0x91;               // <string>
static const short int ST_UDPFLAGS = 0x92;              // <int>
//file tags
static const short int FT_FILENAME = 0x01;
static const short int FT_FILESIZE = 0x02;              // <int>
static const short int FT_FILETYPE = 0x03;              // <string>
static const short int FT_FILEFORMAT = 0x04;            // <string>
static const short int FT_LASTSEENCOMPLETE = 0x05;


static const short int FT_TRANSFERED = 0x08;            // <int>
static const short int FT_GAPSTART = 0x09;
static const short int FT_GAPEND = 0x0A;
static const short int FT_PARTFILENAME = 0x12;          // <string>
static const short int FT_OLDDLPRIORITY = 0x13;
static const short int FT_STATUS = 0x14;
static const short int FT_SOURCES = 0x15;
static const short int FT_PERMISSIONS = 0x16;
static const short int FT_OLDULPRIORITY = 0x17;
static const short int FT_CATEGORY = 0x53;
static const short int FT_DLPRIORITY = 0x18;            // Was 13
static const short int FT_ULPRIORITY = 0x19;            // Was 17

// statistic
static const short int FT_ATTRANSFERED = 0x50;
static const short int FT_ATREQUESTED = 0x51;
static const short int FT_ATACCEPTED = 0x52;
static const short int FT_ATTRANSFEREDHI = 0x54;

static const short int CT_NAME = 0x01;
static const short int CT_PORT = 0x0f;
static const short int CT_VERSION = 0x11;
static const short int CT_FRIENDSHARING = 0x66;
static const short int CT_EMULE_UDPPORTS = 0xf9;
static const short int CT_EMULE_MISCOPTIONS1 = 0xfa;
static const short int CT_EMULE_VERSION = 0xfb;

#define Irc_Version				"(SMIRCv00.61)"

enum
{
    MP_MESSAGE = 50000,
    MP_DETAIL,
    MP_ADDFRIEND,
    MP_REMOVEFRIEND,
    MP_SHOWLIST,
    MP_FRIENDSLOT,
    MP_CANCEL,
    MP_STOP,
    MP_RESUME,
    MP_RESUME_NEXT,
    MP_PAUSE,
    MP_CLEARCOMPLETED,
    MP_OPEN,
    MP_PREVIEW,
//For comments 
    MP_CMT,
    MP_SWITCHCTRL,

    MP_PRIOVERYLOW,
    MP_PRIOLOW,
    MP_PRIONORMAL,
    MP_PRIOHIGH,
    MP_PRIOVERYHIGH,
    MP_PRIOAUTO,
    MP_GETED2KLINK,
    MP_GETHTMLED2KLINK,
    MP_GETSOURCEED2KLINK,
    MP_METINFO,
    MP_PERMALL,
    MP_PERMFRIENDS,
    MP_PERMNONE,
    MP_CONNECTTO,
    MP_REMOVE,
    MP_REMOVEALL,
    MP_REMOVESELECTED,
    MP_UNBAN,
    MP_ADDTOSTATIC,
    MP_CLCOMMAND,
    MP_REMOVEFROMSTATIC,
    MP_VIEWFILECOMMENTS,
    MP_VERSIONCHECK,
    MP_WEBURL,
    MP_CAT_ADD,
    MP_CAT_EDIT,
    MP_CAT_REMOVE,

// reserve some for weburls!

    Irc_Op,
    Irc_DeOp,
    Irc_Voice,
    Irc_DeVoice,
    Irc_HalfOp,
    Irc_DeHalfOp,
    Irc_Kick,
    Irc_Slap,
    Irc_Join,
    Irc_Close,
    Irc_Priv,
    Irc_AddFriend,
    Irc_SendLink,
    Irc_SetSendLink,

    MP_ASSIGNCAT,
// reserve some for categories!
    MP_SCHACTIONS,
// reserve some for schedules
    MP_CAT_SET0
};
// reserve some for change all-cats (about 20)
	
// xmule tagnames
static const short int ET_COMPRESSION = 0x20;
static const short int ET_UDPPORT = 0x21;
static const short int ET_UDPVER = 0x22;
static const short int ET_SOURCEEXCHANGE = 0x23;
static const short int ET_COMMENTS = 0x24;
static const short int ET_EXTENDEDREQUEST = 0x25;
static const short int ET_COMPATIBLECLIENT = 0x26;
static const short int ET_FEATURES = 0x27;              // bit 0: SecIdent v1
                                                        // bit 1: SecIdent v2

// tags by various mods	
static const short int ET_TAROD = 0x77;                 // int - flag - Tarod mod
static const short int ET_TAROD_VERSION = 0x78;         // Tarod mod version number
static const short int ET_L = 0x3E;                     // does send FILEREASKTIME
// seems to synchronize connecting between low and high ID users
static const short int ET_MOD_LSD = 0x87;               // int - flag
static const short int ET_MOD_LSD_VERSION = 0x88;       // int
static const short int ET_MOD_SECURE_COMMUNITY = 0x5C;  // string
static const short int ET_MOD_PROTOCOL = 0x56;          // string
static const short int ET_MOD_Morph = 0x79;             // int
static const short int ET_MOD_Morph_VERSION = 0x80;     // int
static const short int ET_MOD_FUSION = 0x66;            // int
static const short int ET_MOD_FUSION_VERSION = 0x67;    // string
static const short int ET_MOD_MorTillo = 0x82;          // int
static const short int ET_MOD_MorTillo_VERSION = 0x83;  // string
static const short int ET_MOD_LOVELACE_VERSION = 0x90;  // string
static const short int ET_MOD_OXY = 0x94;               // unspecified type
static const short int ET_PLUS = 0x99;                  // int - eMule Plus version
static const short int ET_FEATURESET = 0x54;            // int - [Bloodymad Featureset]


// xmuleapp <-> xmuleapp
enum
{
    OP_ED2KLINK,
    OP_CLCOMMAND,
	
//thread messages
    TM_FINISHEDHASHING,
    TM_HASHTHREADFINISHED,

// quick-speed changer
    MP_QS_U10,
    MP_QS_U20,
    MP_QS_U30,
    MP_QS_U40,
    MP_QS_U50,
    MP_QS_U60,
    MP_QS_U70,
    MP_QS_U80,
    MP_QS_U90,
    MP_QS_U100,
    MP_QS_UPC,
    MP_QS_UP10,
    MP_QS_UPL,
    MP_QS_D10,
    MP_QS_D20,
    MP_QS_D30,
    MP_QS_D40,
    MP_QS_D50,
    MP_QS_D60,
    MP_QS_D70,
    MP_QS_D80,
    MP_QS_D90,
    MP_QS_D100,
    MP_QS_DC,
    MP_QS_DL,
    MP_QS_PA,
    MP_QS_UA,

// CMuleListCtrl tabs.
    MP_LISTCOL_1,
    MP_LISTCOL_2,
    MP_LISTCOL_3,
    MP_LISTCOL_4,
    MP_LISTCOL_5,
    MP_LISTCOL_6,
    MP_LISTCOL_7,
    MP_LISTCOL_8,
    MP_LISTCOL_9,
    MP_LISTCOL_10,
    MP_LISTCOL_11,
    MP_LISTCOL_12,
    MP_LISTCOL_13,
    MP_LISTCOL_14,
    MP_LISTCOL_15,


  /* Razor 1a - Modif by MikaelB
     Opcodes for :
      - Drop No Needed Sources now
      - Drop Full Queue Sources now
      - Drop High Queue Rating Sources now
      - Clean Up Sources now ( drop NNS, FQS and HQRS )
      - Swap every A4AF to this file now
      - Swap every A4AF to this file ( AUTO )
      - Swap every A4AF to any other file now   */

    MP_DROP_NO_NEEDED_SOURCES,
    MP_DROP_FULL_QUEUE_SOURCES,
    MP_DROP_HIGH_QUEUE_RATING_SOURCES,
    MP_CLEAN_UP_SOURCES,
    MP_SWAP_A4AF_TO_THIS,
    MP_SWAP_A4AF_TO_THIS_AUTO,
    MP_SWAP_A4AF_TO_ANY_OTHER
};
  /* End Modif */
  
#endif
