// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef OTHERFUNS_H
#define OTHERFUNS_H

#include <sys/time.h>                       // Needed for gettimeofday
#include <wx/string.h>                      // Needed for wxString

#define ROUND(x) (std::floor((float)x + 0.5f))

class CPartFile;

wxString CastItoXBytes(wxUint64 count);
wxString CastItoIShort(wxUint64 number);
wxString CastSecondsToHM(wxInt32 seconds); //<<--9/21/02
wxString LeadingZero(wxUint32 units);
void ShellOpenFile(wxString name); //<<--9/21/02
wxString GetResString(unsigned int uStringID);//<<--10/01/02
void MakeFoldername(char* path);

void URLDecode(wxString& result, const char* buff);// Make a malloc'd decoded strnig from an URL encoded string (with escaped spaces '%20' and  the like
wxString URLEncode(wxString sIn);

inline wxByte toHex(const wxByte& x)
{
    return x > 9 ? x + 55: x + 48;
}

int GetFTIDbyName(wxString infile);
wxString GetFiletypeByName(wxString infile);
bool Ask4RegFix(bool checkOnly, bool dontAsk = false); // Barry - Allow forced update without prompt
void BackupReg(void); // Barry - Store previous values
void RevertReg(void); // Barry - Restore previous values
wxString MakeStringEscaped(wxString in);

void HexDump(const void *buffer, unsigned long buflen);
bool BackupFile(const wxString& filename, const wxString& appendix);

wxString GetCatTitle(int catid);
bool CheckShowItemInGivenCat(CPartFile* file,int inCategory);

wxString GetRateString(wxUint16 rate);

// From Gnucleus project [found by Tarod]
wxString EncodeBase32(const unsigned char* buffer, unsigned int bufLen);
wxString EncodeBase16(const unsigned char* buffer, unsigned int bufLen);
int DecodeLengthBase16(int base16Length);
void DecodeBase16(const char *base16Buffer, unsigned int base16BufLen, unsigned char *buffer);

inline char* nstrdup(const char* src)
{
    int len = (src ? strlen(src) : 0) + 1;
    char* res = new char[len];

    if (src)
    {
        strcpy(res, src);
    }
    res[len - 1] = 0;

    return res;
}

// md4cmp -- replacement for memcmp(hash1,hash2,16)
// Like 'memcmp' this function returns 0, if hash1==hash2, and !0, if hash1!=hash2.
// NOTE: Do *NOT* use that function for determining if hash1<hash2 or hash1>hash2.
inline int md4cmp(const void* hash1, const void* hash2)
{
    return !(((wxUint32*)hash1)[0] == ((wxUint32*)hash2)[0] &&
             ((wxUint32*)hash1)[1] == ((wxUint32*)hash2)[1] &&
             ((wxUint32*)hash1)[2] == ((wxUint32*)hash2)[2] &&
             ((wxUint32*)hash1)[3] == ((wxUint32*)hash2)[3]);
}

// md4clr -- replacement for memset(hash,0,16)
inline void md4clr(const void* hash) {
    ((wxUint32*)hash)[0] = ((wxUint32*)hash)[1] = ((wxUint32*)hash)[2] = ((wxUint32*)hash)[3] = 0;
}

// md4cpy -- replacement for memcpy(dst,src,16)
inline void md4cpy(const void* dst, const void* src)
{
    ((wxUint32*)dst)[0] = ((wxUint32*)src)[0];
    ((wxUint32*)dst)[1] = ((wxUint32*)src)[1];
    ((wxUint32*)dst)[2] = ((wxUint32*)src)[2];
    ((wxUint32*)dst)[3] = ((wxUint32*)src)[3];
}

#define MAX_HASHSTR_SIZE (16*2+1)

inline int CompareUnsigned(wxUint32 uSize1, wxUint32 uSize2)
{
    if (uSize1 < uSize2)
    {
        return -1;
    }
    else if (uSize1 > uSize2)
    {
        return 1;
    }
    return 0;
}

inline long GetTickCount()
{
  struct timeval temp;
  gettimeofday(&temp, NULL);
  return (temp.tv_sec * 1000) + (temp.tv_usec / 1000);
}

bool SafeCopyFile(const wxString& file1, const wxString& file2);

inline unsigned int form_version(unsigned int major, unsigned int minor, unsigned int release)
{
    return (major * 100000) + (minor * 1000) + (release * 100);
}

#endif
