// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.emule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

// Some worthless comment to commemorate how Avi Vahl single-handedly 
// brought cvs down to a crashing halt (well just a little overstated)
// by trying to rename this file using cvs in Win32 :o 
//
// See https://gna.org/support/?func=detailitem&item_id=201 for details.
// Avi, we love you :-))

#ifndef _UPDOWNCLIENT_H
#define _UPDOWNCLIENT_H

#include "mfc.h"                            // Needed for CTypedPtrList
#include "wintypes.h"                       // Needed for DWORD

#include <wx/gdicmn.h>                      // Needed for wxRect

class CBarShader;
class CClientCredits;
class CClientReqServer;
class CKnownFile;
class CMemFile;
class CPartFile;
class CString;
class Packet;
struct Pending_Block_Struct;
struct Requested_Block_Struct;
struct Requested_File_Struct;
class wxDC;
class wxPaintDC;

typedef unsigned char byte;
extern inline long GetTickCount();

// uploadstate
#define	US_UPLOADING		0
#define	US_ONUPLOADQUEUE	1
#define	US_WAITCALLBACK		2
#define	US_CONNECTING		3
#define	US_PENDING			4
#define	US_LOWTOLOWIP		5
#define US_BANNED			6
#define US_ERROR			7
#define US_NONE				8

// downloadstate
#define	DS_DOWNLOADING		0
#define	DS_ONQUEUE			1
#define	DS_CONNECTED		2
#define	DS_CONNECTING		3
#define	DS_WAITCALLBACK		4
#define	DS_REQHASHSET		5
#define	DS_NONEEDEDPARTS	6
#define	DS_TOOMANYCONNS		7
#define	DS_LOWTOLOWIP		8
#define DS_BANNED			9
#define DS_ERROR			10
#define	DS_NONE				11

// m_byChatstate
#define	MS_NONE				0
#define	MS_CHATTING			1
#define	MS_CONNECTING		2
#define	MS_UNABLETOCONNECT	3

enum EClientSoftware
{
    SO_EMULE            = 0,
    SO_CDONKEY          = 1,
    SO_XMULE            = 2,
    SO_AMULE            = 3,
    SO_SHAREAZA         = 4,
    SO_MLDONKEY         = 10,
    SO_LPHANT           = 20,
    SO_EDONKEYHYBRID    = 50,
    SO_EDONKEY,
    SO_OLDEMULE,
    SO_UNKNOWN,
    SO_NEW_MLDONKEY     = 152
};

enum ESecureIdentState {
	IS_UNAVAILABLE = 0,
	IS_ALLREQUESTSSEND = 0,
	IS_SIGNATURENEEDED = 1,
	IS_KEYANDSIGNEEDED = 2
};

enum EInfoPacketState {
	IP_NONE = 0,
	IP_EDONKEYPROTPACK = 1,
	IP_EMULEPROTPACK = 2,
	IP_BOTH = 3
};

class CClientReqSocket;
class CFriend;

class CUpDownClient
{
	friend class CUploadQueue;
public:
	//base
	CUpDownClient(CClientReqSocket* sender = 0);
	CUpDownClient(wxUint16 in_port, wxUint32 in_userid, wxUint32 in_serverup, wxUint16 in_serverport,CPartFile* in_reqfile);
	~CUpDownClient();
	void			Destroy();
	void			Disconnected();
	bool			TryToConnect(bool bIgnoreMaxCon = false);
	void			ConnectionEstablished();
	wxUint32			GetUserID()					{return m_nUserID;}
	void			SetUserID(wxUint32 nUserID)			{ m_nUserID=nUserID; }
	char*			GetUserName()				{return m_pszUsername;}
	wxUint32			GetIP()						{return m_dwUserIP;}
	bool			HasLowID()					{return (m_nUserID < 16777216);}
	char*			GetFullIP()					{return m_szFullUserIP;}
	wxUint32			GetUserPort()				{return m_nUserPort;}
	wxUint32			GetTransferedUp()			{return m_nTransferedUp;}
	wxUint32			GetTransferedDown()			{return m_nTransferedDown;}
	wxUint32			GetServerIP()				{return m_dwServerIP;}
	void			SetServerIP(wxUint32 nIP)		{ m_dwServerIP=nIP; }
	wxUint16			GetServerPort()				{return m_nServerPort;}
	void			SetServerPort(wxUint16 nPort)		{ m_nServerPort=nPort; }
	byte*			GetUserHash()				{return (byte*)m_achUserHash;}
	void			SetUserHash(byte* achUserHash);
	bool			HasValidHash()				{return ((int*)m_achUserHash)[0] != 0 || ((int*)m_achUserHash)[1] != 0 ||
												        ((int*)m_achUserHash)[2] != 0 || ((int*)m_achUserHash)[3] != 0; }
	int			GetHashType();
	wxUint32			GetVersion()				{return m_nClientVersion;}
	wxUint8			GetMuleVersion()			{ return m_byEmuleVersion; }
	bool			ExtProtocolAvailable()		{return m_bEmuleProtocol;}
	bool			IsEmuleClient()				{return m_byEmuleVersion;}
	CClientCredits* 	Credits()					{return credits;}
	bool			IsBanned()	{return (m_bBanned && m_nDownloadState != DS_DOWNLOADING);}
	char*			GetClientFilename()			{return m_pszClientFilename;}
	wxString		GetClientFilename_NEW() const		{return m_strClientFilename;}
	bool			SupportsUDP()				{return m_byUDPVer != 0 && m_nUDPPort != 0;}
	wxUint16			GetUDPPort()				{return m_nUDPPort;}
	void			SetUDPPort(wxUint16 nPort)	{ m_nUDPPort = nPort; }
	wxUint8			GetUDPVersion()				{return m_byUDPVer;}
	wxUint8			GetExtendedRequestsVersion(){return m_byExtendedRequestsVer;}
	bool			IsFriend()					{return m_Friend != NULL;}
	float			GetCompression()	{return (float)compressiongain/notcompressed*100.0f;} // Add rod show compression
	void			ResetCompressionGain() {compressiongain = 0; notcompressed=1;} // Add show compression

	void			RequestSharedFileList();
	void			ProcessSharedFileList(char* pachPacket, wxUint32 nSize);
	
        wxString                 GetUploadFileInfo();

	void			SetUserName(char* pszNewName);
	EClientSoftware		GetClientSoft()				{return m_clientSoft;}
	void			ReGetClientSoft();
	bool			ProcessHelloAnswer(char* pachPacket, wxUint32 nSize);
	bool			ProcessHelloPacket(char* pachPacket, wxUint32 nSize);
	void			SendHelloAnswer();
	void			SendHelloPacket();
	void			SendMuleInfoPacket(bool bAnswer);
	void			ProcessMuleInfoPacket(char* pachPacket, wxUint32 nSize);
	void			ProcessMuleCommentPacket(char* pachPacket, wxUint32 nSize);
	bool			Compare(CUpDownClient* tocomp);
	void			SetLastStateChange()	{m_dwLastStateChange = ::GetTickCount();}
	void			SetLastSrcReqTime()		{m_dwLastSourceRequest = ::GetTickCount();}
	void			SetLastSrcAnswerTime()		{m_dwLastSourceAnswer = ::GetTickCount();}
	void			SetLastAskedForSources()	{m_dwLastAskedForSources = ::GetTickCount();}
	wxUint32			GetLastStateChange()	{return m_dwLastStateChange;}
	wxUint32			GetLastSrcReqTime()			{return m_dwLastSourceRequest;}
	wxUint32			GetLastSrcAnswerTime()		{return m_dwLastSourceAnswer;}
	wxUint32			GetLastAskedForSources()	{ return m_dwLastAskedForSources;}
	bool			GetFriendSlot()				{return m_bFriendSlot;}
	void			SetFriendSlot(bool bNV)		{m_bFriendSlot = bNV;}
	void			SetCommentDirty(bool bDirty = true) {m_bCommentDirty = bDirty;}
	wxUint8			GetSourceExchangeVersion()	{return m_bySourceExchangeVer;}

	void			SendPublicKeyPacket();
	void			SendSignaturePacket();
	void			ProcessPublicKeyPacket(byte* pachPacket, wxUint32 nSize);
	void			ProcessSignaturePacket(byte* pachPacket, wxUint32 nSize);
	wxUint8			GetSecureIdentState()		{return m_SecureIdentState;}
	void			SendSecIdentStatePacket();
	void			ProcessSecIdentStatePacket(unsigned char* pachPacket,wxUint32 nSize);
	wxUint8			GetInfoPacketsReceived() const { return m_byInfopacketsReceived; }
	void			InfoPacketsReceived();
	void			ResetFileStatusInfo();

	bool			SupportsPreview()		{return m_bSupportsPreview;}
	bool			SafeSendPacket(Packet* packet);

	CClientReqSocket*	socket;
	CClientCredits*		credits;
	CFriend*			m_Friend;
    bool SpecialPerson;
	//upload
	wxUint32	compressiongain; /// Add show compression
	wxUint32  notcompressed; // Add show compression
	wxUint8			GetUploadState()			{return m_byUploadState;}
	void			SetUploadState(wxUint8 news)	{m_byUploadState = news;}
	wxUint32			GetWaitStartTime()			{return m_dwWaitTime;}
	wxUint32			GetWaitTime()				{return m_dwUploadTime-m_dwWaitTime;}
	bool			IsDownloading()				{return (m_byUploadState == US_UPLOADING);}
	bool			HasBlocks()					{return !(m_BlockSend_queue.IsEmpty() && m_BlockRequests_queue.IsEmpty());}
	wxUint32			GetDatarate()				{return m_nUpDatarate;}	
	wxUint32			GetScore(bool sysvalue, bool isdownloading = false, bool onlybasevalue = false);
	void			AddReqBlock(Requested_Block_Struct* reqblock);
	bool			CreateNextBlockPackage();
	void			SetUpStartTime(wxUint32 dwTime = 0);
	wxUint32			GetUpStartTimeDelay()		{return ::GetTickCount() - m_dwUploadTime;}
	void			SetWaitStartTime(wxUint32 dwTime = 0);
	void			SendHashsetPacket(char* forfileid);
	void			SetUploadFileID(byte* tempreqfileid);
	byte*			GetUploadFileID()	{return requpfileid;}
	CPartFile*		GetDownloadFile()	{return reqfile;}
	void			SetDownloadFile(CPartFile*);
	wxUint32			SendBlockData(wxUint32 maxammount);
	void			ClearUploadBlockRequests();
	void			SendRankingInfo();
	void			SendCommentInfo(CKnownFile *file);
	wxUint32			GetLastAskedDelay();
	void			AddRequestCount(byte* fileid);
	bool 			IsDifferentPartBlock();
	void			UnBan();
	void			Ban();
	wxUint32			GetBanTime()				{return m_dwBanTime;}
	wxUint32			GetAskedCount()				{return m_cAsked;}
	void			AddAskedCount()				{m_cAsked++;}
	void			SetAskedCount( wxUint32 m_cInAsked)				{m_cAsked = m_cInAsked;}
	void			FlushSendBlocks();			// call this when you stop upload, or the socket might be not able to send
	void			SetLastUpRequest()			{m_dwLastUpRequest = ::GetTickCount();}
	wxUint32			GetLastUpRequest()			{return m_dwLastUpRequest;}
	void			UDPFileReasked();
	wxUint32			GetSessionUp()			{return m_nTransferedUp - m_nCurSessionUp;}
	void			ResetSessionUp()		{m_nCurSessionUp = m_nTransferedUp;} 
	void			ProcessUpFileStatus(char* packet,wxUint32 size);
	wxUint16			GetUpPartCount()			{return m_nUpPartCount;}
	void			DrawUpStatusBar(wxDC* dc, wxRect rect, bool onlygreyrect, bool  bFlat);

	//download
	wxUint32			GetAskedCountDown()				{return m_cDownAsked;} //<<--
	void			AddAskedCountDown()				{m_cDownAsked++;}
	void			SetAskedCountDown( wxUint32 m_cInDownAsked)				{m_cDownAsked = m_cInDownAsked;}
	wxUint8			GetDownloadState()			{return m_nDownloadState;}
	void			SetDownloadState(wxUint8 byNewState);
	wxUint32			GetLastAskedTime()			{return m_dwLastAskedTime;}
	inline bool			IsPartAvailable(wxUint16 iPart)	{return	( (iPart >= m_nPartCount) || (!m_abyPartStatus) )? 0:m_abyPartStatus[iPart];}
	bool			IsUpPartAvailable(wxUint16 iPart) {return ( (iPart
 >= m_nUpPartCount) || (!m_abyUpPartStatus) )? 0:m_abyUpPartStatus[iPart];}
	wxUint8*			GetPartStatus()				{return m_abyPartStatus;}
	wxUint32			GetDownloadDatarate()		{ return m_nDownDatarate; }
	wxUint16			GetRemoteQueueRank()		{ return m_nRemoteQueueRank; }
	void			SetRemoteQueueFull( bool flag )	{m_bRemoteQueueFull = flag;}
	bool			IsRemoteQueueFull()			{return m_bRemoteQueueFull;}
	void			SetRemoteQueueRank(wxUint16 nr);
	void			DrawStatusBar(wxDC* dc, wxRect rect, bool onlygreyrect, bool  bFlat);
	void			AskForDownload();
	void			SendFileRequest_HOPE();
	void			SendFileRequest();
	void			ProcessFileInfo(char* packet,wxUint32 size);
	void			ProcessFileStatus(char* packet,wxUint32 size);
	void			ProcessHashSet(unsigned char* packet,wxUint32 size);
	bool			AddRequestForAnotherFile(CPartFile* file);
	void			SendBlockRequests();
	void			ProcessBlockPacket(char* packet, wxUint32 size, bool packed = false);
	wxUint32			CalculateDownloadRate();
	wxUint16			GetAvailablePartCount();

	void			UDPReaskACK(wxUint16 nNewQR);
	void			UDPReaskFNF();
	void			UDPReaskForDownload();
	bool			IsSourceRequestAllowed();

	wxUint16 GetUpCompleteSourcesCount() { return m_nUpCompleteSourcesCount; }
	void SetUpCompleteSourcesCount(wxUint16 n) { m_nUpCompleteSourcesCount = n; }
	
	int				sourcesslot;

	//chat
	wxUint8			GetChatState()				{return m_byChatstate;}
	void			SetChatState(wxUint8 nNewS)	{m_byChatstate = nNewS;}
	bool			m_bIsSpammer;
	wxUint8			m_cMessagesReceived; //Count of chatmessages he sent to me
	wxUint8			m_cMessagesSend; //Count of chatmessages i sent to him

	//File Comment 
    CString			GetFileComment()			{return m_strComment;} 
    void			SetFileComment(char *desc)	{m_strComment.Format("%s",desc);}
    wxUint8			GetFileRate()				{return m_iRate;}
    void			SetFileRate(wxInt8 iNewRate)	{m_iRate=iNewRate;}

	// Barry - Process zip file as it arrives, don't need to wait until end of block
	int unzip(Pending_Block_Struct *block, byte *zipped, wxUint32 lenZipped, byte **unzipped, wxUint32 *lenUnzipped, bool recursive = false);
	// Barry - Sets string to show parts downloading, eg NNNYNNNNYYNYN
	void ShowDownloadingParts(wxString &partsYN);
	void UpdateDisplayedInfo(bool force=false);
	int  GetFileListRequested() { return m_iFileListRequested; }
	void SetFileListRequested(int iFileListRequested) { m_iFileListRequested = iFileListRequested; }
	wxUint8	m_cFailed;

private:
	CPartFile*		reqfile;

	// base
	void	Init();
	bool	ProcessHelloTypePacket(CMemFile* data);
	void	SendHelloTypePacket(CMemFile* data);
	bool	m_bIsBotuser;
	wxUint32	m_dwUserIP;
	wxUint32	m_dwServerIP;
	wxUint32	m_nUserID;
	wxInt16	m_nUserPort;
	wxInt16	m_nServerPort;
	wxUint32	m_nClientVersion;
	wxUint32	m_nUpDatarate;
	wxUint32	dataratems;
	wxUint32	m_cSendblock;
	wxUint8	m_byEmuleVersion;
	wxUint8	m_byDataCompVer;
	bool	m_bEmuleProtocol;
	char*	m_pszUsername;
	char	m_szFullUserIP[21];
	char	m_achUserHash[16];
	wxUint16	m_nUDPPort;
	wxUint8	m_byUDPVer;
	wxUint8	m_bySourceExchangeVer;
	wxUint8	m_byAcceptCommentVer;
	wxUint8	m_byExtendedRequestsVer;
	EClientSoftware	m_clientSoft;
	wxUint32	m_dwLastSourceRequest;
	wxUint32	m_dwLastSourceAnswer;
	wxUint32  m_dwLastAskedForSources;
	wxUint32  m_dwLastStateChange;
	int	m_iFileListRequested;
	bool	m_bFriendSlot;
	bool	m_bCommentDirty;
	bool	m_bIsHybrid;
	bool	m_bIsML;
	bool	m_bGPLEvildoer;
	bool	m_bPreviewReqPending;
	bool	m_bPreviewAnsPending;
	wxUint16	m_nKadPort;
	bool	m_bMultiPacket;

	ESecureIdentState	m_SecureIdentState;
	wxUint8	m_byInfopacketsReceived;
	wxUint32	m_dwLastSignatureIP;
	wxUint8	m_bySupportSecIdent;
	bool	m_bySupportsPreview;
	
	wxUint32	m_byCompatibleClient;
	CTypedPtrList<CPtrList, Packet*>				 m_WaitingPackets_list;
	DWORD	m_lastRefreshedDLDisplay;

	//upload
	void CreateStandartPackets(byte* data,wxUint32 togo, Requested_Block_Struct* currentblock);
	void CreatePackedPackets(byte* data,wxUint32 togo, Requested_Block_Struct* currentblock);
	bool		m_bBanned;
	wxUint32		m_nTransferedUp;
	wxUint8		m_byUploadState;
	wxUint32		m_dwWaitTime;
	wxUint32		m_dwUploadTime;
	wxUint32		m_nMaxSendAllowed;
	wxUint32		m_nAvUpDatarate;
	wxUint32		m_cAsked;
	wxUint32		m_dwLastUpRequest;
	wxUint32		m_dwBanTime;
	bool		m_bUsedComprUp;	//only used for interface output
	wxUint32		m_nCurSessionUp;
	wxUint16		m_nUpPartCount;
	static		CBarShader s_UpStatusBar;
	byte		requpfileid[16];
	wxUint16 m_nUpCompleteSourcesCount;
	public:
	wxUint8*		m_abyUpPartStatus;
	wxUint16		m_lastPartAsked;
	DWORD		m_dwEnteredConnectedState;
	CString		m_strModVersion;
	wxUint32		m_nSumForAvgUpDataRate;

	private:
	CList<int,int>	 m_AvarageUDR_list;
	
	CTypedPtrList<CPtrList, Packet*>	 m_BlockSend_queue;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> m_BlockRequests_queue;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> m_DoneBlocks_list;
	CTypedPtrList<CPtrList, Requested_File_Struct*>	 m_RequestedFiles_list;
	//download
	bool		m_bRemoteQueueFull;
	bool		usedcompressiondown; //only used for interface output
	wxUint8		m_nDownloadState;
	wxUint16		m_nPartCount;
	wxUint32		m_cDownAsked;
	wxUint8*		m_abyPartStatus;
	wxUint32		m_dwLastAskedTime;
	wxString	m_strClientFilename;
	char*		m_pszClientFilename;
	wxUint32		m_nTransferedDown;
	wxUint32      m_nLastBlockOffset;   // Patch for show parts that you download [Cax2]
	wxUint32		m_nDownDatarate;
	wxUint32		m_nDownDataRateMS;
	wxUint32		m_nAvDownDatarate;
	wxUint16		m_cShowDR;
	wxUint32		m_dwLastBlockReceived;
	wxUint16		m_nRemoteQueueRank;
	bool		m_bCompleteSource;
	bool		m_bReaskPending;
	bool		m_bUDPPending;
	wxUint32		m_nSumForAvgDownDataRate;
	bool		m_bHashsetRequested;
	bool		m_bSharedDirectories;
 	bool		m_bNoViewSharedFiles;
	bool		m_bSupportsPreview;

	CList<int,int>	 m_AvarageDDR_list;
	wxInt32		sumavgDDR;
	wxInt32		sumavgUDR;
	CTypedPtrList<CPtrList, Pending_Block_Struct*>	 m_PendingBlocks_list;
	CTypedPtrList<CPtrList, Requested_Block_Struct*> m_DownloadBlocks_list;
	CTypedPtrList<CPtrList, CPartFile*>				 m_OtherNoNeeded_list;

	static CBarShader s_StatusBar;
	// chat
	wxUint8 m_byChatstate;
	CString m_strComment;
	wxInt8 m_iRate;

  /* Razor 1a - Modif by MikaelB */
  
      public:

          /* m_OtherRequests_list --> public instead of private */
          CTypedPtrList<CPtrList, CPartFile*>	 m_OtherRequests_list;

          /* IsValidSource function
           * @return true id it's valid source
           */
          bool IsValidSource() const
          {
            return m_ValidSource;
          };

          /* SetValidSource function
           * @param boolean - set valid source
           */
          void SetValidSource(bool in)
          {
            m_ValidSource = in;
          };

          /* SwapToThisFile function
           * @param CPartFile* - the file
           */
          void SwapToThisFile(CPartFile* file);

          /* SwapToAnotherFile function */
          bool SwapToAnotherFile();

      private:
      
          /* valid source attribute */
          bool m_ValidSource;

  /* End modif */
	  
  // Support for tag ET_MOD_VERSION [BlackRat]
  public:
	
  		const wxString	GetClientModString() const { return m_clientModString; }
		const wxString	GetClientVerString() const { return m_clientVerString; }

  private:
	  
	    wxString		m_clientModString; 
	    wxString		m_clientVerString;
	
  // Hash anti-thief from HoaX_69 [BlackRat]
  public:

	bool			thief;  // is a thief ?
	wxUint64	getUID() 
 	{
			wxUint64 ip = ((wxUint64) m_dwUserIP) << 32;
			wxUint64 port = ((wxUint64) m_nUserPort) << 16;
			wxUint64 uid = ip + port;
			return uid;
	}		
	int				leechertype;  // what kind of leecher is it ?
  
};

#endif
