// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
#	include "xmule-headers.h"
#else
#	include "EMSocket.h"
#	include "opcodes.h"
#endif

#include <wx/listimpl.cpp>
WX_DEFINE_LIST(PacketListL);

IMPLEMENT_DYNAMIC_CLASS(CEMSocket, wxSocketClient)

//#include <io.h>
#include <fcntl.h>
#include <sys/stat.h>
#if 0
namespace
{
    inline void EMTrace(char *fmt, ...)
    {
#ifdef _DEBUG
        va_list argptr;
        char bufferline[512];
        va_start(argptr, fmt);
        _vsnprintf(bufferline, 512, fmt, argptr);
        va_end(argptr);
        //(Ornis+)
        char osDate[30], osTime[30];
        char temp[1024];
        _strtime(osTime);
        _strdate(osDate);
        int len = _snprintf(temp, 1021, "%s %s: %s", osDate, osTime, bufferline);
        temp[len++] = 0x0d;
        temp[len++] = 0x0a;
        temp[len + 1] = 0;
        // open MYFILE.TXT:
        HANDLE hFile = CreateFile("c:\\EMSocket.log",
        // open for reading:
        GENERIC_WRITE,
        // share for reading:
        FILE_SHARE_READ,
        // no security:
        NULL,
        // existing file only:
        OPEN_ALWAYS,
        // normal file:
        FILE_ATTRIBUTE_NORMAL,
        // no attr. template:
        NULL);
        if (hFile != INVALID_HANDLE_VALUE)
        {
            DWORD nbBytesWritten = 0;
            SetFilePointer(hFile, 0, NULL, FILE_END);
            BOOL b = WriteFile(
            // handle to file:
            hFile,
            // data buffer:
            temp,
            // number of bytes to write:
            len,
            // number of bytes written:
            &nbBytesWritten,
            // overlapped buffer:
            NULL
            );
            CloseHandle(hFile);
        }
#else
        va_list argptr;
        va_start(argptr, fmt);
        va_end(argptr);
#endif
    }
}

#endif

CEMSocket::CEMSocket(void)
{
    limitenabled = false;
    downloadlimit = 0;
    byConnected = ES_NOTCONNECTED;
    dataneeded = 0;
    datawaiting = 0;
    receivedpacket = 0;
    readbuffer = 0;
    sendbuffer = 0;
    sendblen = 0;
    sent = 0;
    m_bLinkedPackets = false;
}

CEMSocket::~CEMSocket()
{
    //EMTrace("CEMSocket::~CEMSocket() on %d",(SOCKET)this);
    ClearQueues();
    //AsyncSelect(0);
}

void CEMSocket::ClearQueues()
{
    //EMTrace("CEMSocket::ClearQueues on %d",(SOCKET)this);
    //for (POSITION pos = controlpacket_queue.GetHeadPosition();pos != 0;controlpacket_queue.GetNext(pos))
    for (PacketListL::Node *pos = controlpacket_queue.GetFirst() ; pos != 0 ; pos = pos->GetNext())
    //controlpacket_queue.GetAt(pos);:
    delete pos->GetData();
    //RemoveAll();:
    controlpacket_queue.Clear();
    //for (POSITION pos = standartpacket_queue.GetHeadPosition();pos != 0;standartpacket_queue.GetNext(pos))
    for (PacketListL::Node *pos = standartpacket_queue.GetFirst() ; pos != 0 ; pos = pos->GetNext())
    // standartpacket_queue.GetAt(pos);:
    delete pos->GetData();
    //standartpacket_queue.RemoveAll();
    standartpacket_queue.Clear();
    if (receivedpacket)
    {
        delete receivedpacket;
        receivedpacket = 0;
    }
    if (readbuffer)
    {
        delete[] readbuffer;
        readbuffer = 0;
    }
    datawaiting = 0;
    dataneeded = 0;
    if (sendbuffer)
    delete[] sendbuffer;
    sendbuffer = 0;
    sendblen = 0;
    sent = 0;
    limitenabled = false;
    m_bLinkedPackets = false;
}

void CEMSocket::OnClose(int nErrorCode)
{
    byConnected = ES_DISCONNECTED;
    //CAsyncSocket::OnClose(nErrorCode);
    ClearQueues();
}

;

#if 0
BOOL CEMSocket::AsyncSelect(long lEvent)
{
    EMTrace("CEMSocket::AsyncSelect on %d", (SOCKET) this);
    if (lEvent &FD_READ)
    EMTrace("  FD_READ");
    if (lEvent &FD_CLOSE)
    EMTrace("  FD_CLOSE");
    if (lEvent &FD_WRITE)
    EMTrace("  FD_WRITE");
    if (m_hSocket != INVALID_SOCKET)
    return CAsyncSocket::AsyncSelect(lEvent);
    return true;
}

#endif

void CEMSocket::OnReceive(int nErrorCode)
{
    if (nErrorCode)
    {
        OnError(nErrorCode);
        return;
    }
    if (byConnected == ES_DISCONNECTED)
    return;
    else
    byConnected = ES_CONNECTED;
    if (dataneeded == 0)
    {
        dataneeded = 6;
        datawaiting = 0;
        //:
    }
    if (!receivedpacket)
    {
        assert(dataneeded < 7);
        //Receive(header+datawaiting,dataneeded-datawaiting);
        Read(header + datawaiting, dataneeded - datawaiting);
        uint32 len = LastCount();
        //if (len == (uint32)-1)
        if (Error())
        return;
        datawaiting += len;
        if (datawaiting != dataneeded)
        return;
        receivedpacket = new Packet(header);
        dataneeded = 0;
        datawaiting = 0;
        switch (receivedpacket->prot)
        {
        case OP_EDONKEYPROT:
        case OP_PACKEDPROT:
        case OP_EMULEPROT:
            break;
        default:
            //EMTrace("CEMSocket::OnReceive ERROR Wrong header");
            delete receivedpacket;
            receivedpacket = 0;
            OnError(ERR_WRONGHEADER);
            return;
        }
        assert(receivedpacket->size < 200000);
        if (receivedpacket->size > 200000)
        {
            delete receivedpacket;
            receivedpacket = 0;
            OnError(ERR_TOOBIG);
            return;
        }
        dataneeded = receivedpacket->size;
        assert(readbuffer == NULL);
        readbuffer = new char[receivedpacket->size + 1];
    }
    assert(readbuffer != NULL);
    assert(receivedpacket != NULL);
    uint32 toreceive = dataneeded - datawaiting;
    if (limitenabled && (toreceive > downloadlimit))
    toreceive = downloadlimit;
    uint32 len = 0;
    if (toreceive)
    //Receive(readbuffer+datawaiting,toreceive);
    Read(readbuffer + datawaiting, toreceive);
    len = LastCount();
    //if (len == (uint32)(-1))
    if (Error())
    return;
    if (limitenabled)
    downloadlimit -= len;
    datawaiting += len;
    if (datawaiting != dataneeded)
    return;
    dataneeded = 6;
    datawaiting = 0;
    //assert (AfxIsValidAddress(readbuffer,receivedpacket->size,true));
    receivedpacket->pBuffer = readbuffer;
    readbuffer = 0;
    Packet *toprocess = receivedpacket;
    receivedpacket = 0;
    PacketReceived(toprocess);
    delete toprocess;
}

void CEMSocket::SetDownloadLimit(uint32 limit)
{
    limitenabled = true;
    if (downloadlimit == 0)
    {
        downloadlimit = limit;
        OnReceive(0);
    }
    else
    downloadlimit = limit;
}

void CEMSocket::DisableDownloadLimit()
{
    if (downloadlimit == 0 &&limitenabled)
    {
        limitenabled = false;
        OnReceive(0);
    }
    else
    {
        limitenabled = false;
        downloadlimit = 0;
    }
}

bool CEMSocket::SendPacket(Packet *packet, bool delpacket, bool controlpacket)
{
    if (!delpacket)
    {
        assert(!packet->IsSplitted());
        Packet *copy = new Packet(packet->opcode, packet->size);
        memcpy(copy->pBuffer, packet->pBuffer, packet->size);
        packet = copy;
    }
    if (((!IsConnected()) || IsBusy()) || (m_bLinkedPackets &&controlpacket))
    {
        if (controlpacket)
        {
            //AddTail(packet);:
            controlpacket_queue.Append(packet);
            return true;
        }
        else
        {
            //AddTail(packet);:
            standartpacket_queue.Append(packet);
            return true;
        }
    }
    bool bCheckControlQueue = false;
    if (packet->IsLastSplitted())
    {
        m_bLinkedPackets = false;
        bCheckControlQueue = true;
    }
    else if(packet->IsSplitted())
    m_bLinkedPackets = true;
    else if(m_bLinkedPackets)
    assert(false);
    Send(packet->DetachPacket(), packet->GetRealPacketSize());
    delete packet;
    if (!IsBusy() &&bCheckControlQueue)
    OnSend(0);
    return true;
}

void CEMSocket::OnSend(int nErrorCode)
{
    if (nErrorCode)
    {
        OnError(nErrorCode);
        return;
    }
    if (byConnected == ES_DISCONNECTED)
    return;
    else
    byConnected = ES_CONNECTED;
    if (IsBusy())
    Send(0, 0, 0);
    if (IsBusy())
    return;
    while (controlpacket_queue.GetFirst() != 0 && (!IsBusy()) &&IsConnected() && !m_bLinkedPackets)
    {
        //GetHead();:
        Packet *cur_packet = controlpacket_queue.GetFirst()->GetData();
        //		EMTrace("CEMSocket::OnSend sending control packet on %d, size=%u",(SOCKET)this, cur_packet->GetRealPacketSize());
        Send(cur_packet->DetachPacket(), cur_packet->GetRealPacketSize());
        controlpacket_queue.DeleteNode(controlpacket_queue.GetFirst());
        //controlpacket_queue.RemoveHead();
        delete cur_packet;
    }
    while (standartpacket_queue.GetFirst() != 0 && (!IsBusy()) &&IsConnected())
    {
        //GetHead();:
        Packet *cur_packet = standartpacket_queue.GetFirst()->GetData();
        if (cur_packet->IsLastSplitted())
        m_bLinkedPackets = false;
        else if(cur_packet->IsSplitted())
        m_bLinkedPackets = true;
        else if(m_bLinkedPackets)
        assert(false);
        //		EMTrace("CEMSocket::OnSend sending standart packet on %d, size=%u",(SOCKET)this, cur_packet->GetRealPacketSize());
        Send(cur_packet->DetachPacket(), cur_packet->GetRealPacketSize());
        //standartpacket_queue.RemoveHead();
        standartpacket_queue.DeleteNode(standartpacket_queue.GetFirst());
        delete cur_packet;
    }
    while (controlpacket_queue.GetFirst() != 0 && (!IsBusy()) &&IsConnected() && !m_bLinkedPackets)
    {
        //GetHead();:
        Packet *cur_packet = controlpacket_queue.GetFirst()->GetData();
        //		EMTrace("CEMSocket::OnSend sending control packet on %d, size=%u",(SOCKET)this, cur_packet->GetRealPacketSize());
        Send(cur_packet->DetachPacket(), cur_packet->GetRealPacketSize());
        //controlpacket_queue.RemoveHead();
        controlpacket_queue.DeleteNode(controlpacket_queue.GetFirst());
        delete cur_packet;
    }
}

int CEMSocket::Send(char *lpBuf, int nBufLen, int nFlags)
{
    assert(sendbuffer == NULL || lpBuf == NULL);
    if (lpBuf)
    {
        sendbuffer = lpBuf;
        sendblen = nBufLen;
        sent = 0;
    }
    while (true)
    {
        uint32 tosend = sendblen - sent;
        if (tosend > MAXFRAGSIZE)
        tosend = MAXFRAGSIZE;
        assert(tosend != 0);
        wxSocketBase::Write(sendbuffer + sent, tosend);
        uint32 result = LastCount();
        //if (result == (uint32)-1){
        if (Error())
        {
            //GetLastError();:
            uint32 error = LastError();
            if (error == wxSOCKET_WOULDBLOCK)
            {
                break;
            }
            else
            {
                //OnError(error);
                return - 1;
            }
        }
        sent += result;
        assert(sent <= sendblen);
        if (sent == sendblen)
        {
            delete[] sendbuffer;
            sendbuffer = 0;
            sent = 0;
            sendblen = 0;
            break;
        }
    }
    return 0;
}

// pach2:
// written this overriden Receive to handle transparently FIN notifications coming from calls to recv()
// This was maybe(??) the cause of a lot of socket error, notably after a brutal close from peer
// also added trace so that we can debug after the fact ...
int CEMSocket::Receive(void *lpBuf, int nBufLen, int nFlags)
{
#if 0
    //	EMTrace("CEMSocket::Receive on %d, maxSize=%d",(SOCKET)this,nBufLen);
    //int recvRetCode = CAsyncSocket::Receive(lpBuf,nBufLen,nFlags);
    switch (recvRetCode)
    {
    case 0:
        EMTrace("CEMSocket::##Received FIN on %d, maxSize=%d", (SOCKET) this, nBufLen);
        // FIN received on socket // Connection is being closed by peer
        //wxASSERT (false);
        if (0 == AsyncSelect(FD_CLOSE |FD_WRITE))
        {
            // no more READ notifications ...
            // oups, AsyncSelect failed !!!:
            int waserr = GetLastError();
            wxASSERT(false);
        }
        return 0;
    case SOCKET_ERROR:
        switch (GetLastError())
        {
        case WSANOTINITIALISED:
            wxASSERT(false);
            EMTrace("CEMSocket::OnReceive:A successful AfxSocketInit must occur before using this API.");
            break;
        case WSAENETDOWN:
            wxASSERT(true);
            EMTrace("CEMSocket::OnReceive:The socket %d received a net down error", (SOCKET) this);
            break;
            // The socket is not connected.:
        case WSAENOTCONN:
            EMTrace("CEMSocket::OnReceive:The socket %d is not connected", (SOCKET) this);
            break;
            // A blocking Windows Sockets operation is in progress.:
        case WSAEINPROGRESS:
            EMTrace("CEMSocket::OnReceive:The socket %d is blocked", (SOCKET) this);
            break;
            // The socket is marked as nonblocking and the Receive operation would block.:
        case WSAEWOULDBLOCK:
            EMTrace("CEMSocket::OnReceive:The socket %d would block", (SOCKET) this);
            break;
            // The descriptor is not a socket.:
        case WSAENOTSOCK:
            EMTrace("CEMSocket::OnReceive:The descriptor %d is not a socket (may have been closed or never created)", (SOCKET) this);
            break;
            // MSG_OOB was specified, but the socket is not of type SOCK_STREAM.:
        case WSAEOPNOTSUPP:
            break;
            // The socket has been shut down; it is not possible to call Receive on a socket after ShutDown has been invoked with nHow set to 0 or 2.:
        case WSAESHUTDOWN:
            EMTrace("CEMSocket::OnReceive:The socket %d has been shut down", (SOCKET) this);
            break;
            // The datagram was too large to fit into the specified buffer and was truncated.:
        case WSAEMSGSIZE:
            EMTrace("CEMSocket::OnReceive:The datagram was too large to fit and was truncated (socket %d)", (SOCKET) this);
            break;
            // The socket has not been bound with Bind.:
        case WSAEINVAL:
            EMTrace("CEMSocket::OnReceive:The socket %d has not been bound", (SOCKET) this);
            break;
            // The virtual circuit was aborted due to timeout or other failure.:
        case WSAECONNABORTED:
            EMTrace("CEMSocket::OnReceive:The socket %d has not been bound", (SOCKET) this);
            break;
            // The virtual circuit was reset by the remote side.:
        case WSAECONNRESET:
            EMTrace("CEMSocket::OnReceive:The socket %d has not been bound", (SOCKET) this);
            break;
        default:
            EMTrace("CEMSocket::OnReceive:Unexpected socket error %x on socket %d", GetLastError(), (SOCKET) this);
            break;
        }
        return SOCKET_ERROR;
    default:
        //		EMTrace("CEMSocket::OnReceive on %d, receivedSize=%d",(SOCKET)this,recvRetCode);
        return recvRetCode;
    }
    return SOCKET_ERROR;
#endif
}

