// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifdef PRECOMP
    #include "xmule-headers.h"
#endif

#include "FlowChart.h"                      // Needed for this Interface's Prototype

#include "wxTreeMultiCtrl.h"                // Needed for wxTreeMultiCtrl
#include "DynPrefs/DynPrefs.h"              // Needed for DynamicPreferences

//#include <wx/dc.h>                          // Needed for wxClientDC
//#include <wx/dirdlg.h>                      // Needed for wxDirDialog
//#include <wx/msgdlg.h>                      // Needed for wxMessageDialog
#include <wx/sizer.h>                       // Needed for wxBoxSizer
//#include <wx/statline.h>                    // Needed for wxStaticLine
//#include <wx/textdlg.h>                     // Needed for wxTextEntryDialog


BEGIN_EVENT_TABLE(CFlowChart, wxScrolledWindow)
    EVT_KILL_FOCUS(CFlowChart::OnLoseFocus)
    EVT_PREFS_CHANGED(CFlowChart::OnChangedPrefs)
END_EVENT_TABLE()

void CFlowChart::OnLoseFocus(wxFocusEvent& event)
{
}

int newprefs02_opt[101];

int newprefs03_opt[101];

wxString newprefs03info[256];

int newprefs04_opt[101];

wxString newprefs04info[256];

CFlowChart::CFlowChart(wxWindow *pParent, DynamicPreferences* in_prefs):
    wxScrolledWindow(pParent, -1, wxDefaultPosition, wxDefaultSize, wxHSCROLL |wxVSCROLL |wxNO_FULL_REPAINT_ON_RESIZE)
{
    if (in_prefs == NULL)
    {
        dynprefs = new DynamicPreferences;
    }
    else
    {
        dynprefs = in_prefs;
    }

    Init();
}

void CFlowChart::Init()
{
    SetScrollbars(4, 4, 400, 300);
    wxBoxSizer* root = new wxBoxSizer(wxVERTICAL);

    prefs_ctrl = new DynamicPreferencesCtrl(wxString(wxT("memory:resource/newprefs01.pm"), *wxConvCurrent), this, dynprefs);
    prefs_ctrl->Show(true);

    root->Add(prefs_ctrl, 1, wxEXPAND);

    this->SetAutoLayout(TRUE);
    this->SetSizer(root);
    root->SetSizeHints(this);
    root->Fit(this);
    root->Show(this, true);
}

CFlowChart::~CFlowChart()
{
//    delete dynprefs;
}

void CFlowChart::OnChangedPrefs(wxEvent& event)
{
    prefs_ctrl->AddPendingEvent(event);
}
