/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class ElementLister {
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java nu.xom.samples.ElementLister URL");
            return;
        }
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            Element element = document.getRootElement();
            ElementLister.listChildren(element, 0);
        }
        catch (ParsingException parsingException) {
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    public static void listChildren(Element element, int n) {
        ElementLister.printSpaces(n);
        System.out.println(element.getQualifiedName());
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            ElementLister.listChildren(elements.get(i), n + 1);
        }
    }

    private static void printSpaces(int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(' ');
        }
    }
}

