/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable;
    private static final char[] lookUpHexAlphabet;

    public static String encode(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        int n2 = n * 2;
        char[] cArray = new char[n2];
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[i];
            if (n3 < 0) {
                n3 += 256;
            }
            cArray[i * 2] = lookUpHexAlphabet[n3 >> 4];
            cArray[i * 2 + 1] = lookUpHexAlphabet[n3 & 0xF];
        }
        return new String(cArray);
    }

    public static byte[] decode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n % 2 != 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        int n2 = n / 2;
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byte by = hexNumberTable[cArray[i * 2]];
            if (by == -1) {
                return null;
            }
            byte by2 = hexNumberTable[cArray[i * 2 + 1]];
            if (by2 == -1) {
                return null;
            }
            byArray[i] = (byte)(by << 4 | by2);
        }
        return byArray;
    }

    static {
        int n;
        hexNumberTable = new byte[255];
        lookUpHexAlphabet = new char[16];
        for (n = 0; n < 255; ++n) {
            HexBin.hexNumberTable[n] = -1;
        }
        for (n = 57; n >= 48; --n) {
            HexBin.hexNumberTable[n] = (byte)(n - 48);
        }
        for (n = 70; n >= 65; --n) {
            HexBin.hexNumberTable[n] = (byte)(n - 65 + 10);
        }
        for (n = 102; n >= 97; --n) {
            HexBin.hexNumberTable[n] = (byte)(n - 97 + 10);
        }
        for (n = 0; n < 10; ++n) {
            HexBin.lookUpHexAlphabet[n] = (char)(48 + n);
        }
        for (n = 10; n <= 15; ++n) {
            HexBin.lookUpHexAlphabet[n] = (char)(65 + n - 10);
        }
    }
}

