/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.benchmarks;

import java.io.IOException;
import java.text.DecimalFormat;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;

class MemoryTest {
    MemoryTest() {
    }

    public static Document makeFullUnicode() {
        Element element;
        int n;
        Element element2 = new Element("root");
        Document document = new Document(element2);
        for (n = 32; n <= 55295; ++n) {
            element = new Element("d");
            element.appendChild((char)n + "");
            element.addAttribute(new Attribute("c", String.valueOf(n)));
            element2.appendChild((Node)element);
        }
        for (n = 57344; n <= 65533; ++n) {
            element = new Element("d");
            element.appendChild((char)n + "");
            element.addAttribute(new Attribute("c", String.valueOf(n)));
            element2.appendChild((Node)element);
        }
        System.gc();
        for (n = 0; n < 256; ++n) {
            int n2 = 119040 + n;
            int n3 = n2 - 65536;
            int n4 = 55296;
            int n5 = 56320;
            Element element3 = new Element("d");
            element3.appendChild((char)(n4 |= n3 & 0xFF800) + "" + (char)(n5 |= n3 & 0x7FF));
            element3.addAttribute(new Attribute("c", String.valueOf(n2)));
            element2.appendChild((Node)element3);
        }
        return document;
    }

    public static void main(String[] stringArray) throws IOException, ParsingException {
        Document document;
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(2);
        Runtime runtime = Runtime.getRuntime();
        System.gc();
        System.gc();
        System.gc();
        long l = runtime.totalMemory() - runtime.freeMemory();
        if (stringArray.length > 0) {
            Builder builder = new Builder();
            document = builder.build(stringArray[0]);
            builder = null;
        } else {
            document = MemoryTest.makeFullUnicode();
        }
        long l2 = runtime.totalMemory() - runtime.freeMemory();
        double d = (double)(l2 - l) / 1048576.0;
        System.out.println("Memory used: " + decimalFormat.format(d) + "M");
        System.gc();
        System.gc();
        System.gc();
        long l3 = runtime.totalMemory() - runtime.freeMemory();
        d = (double)(l3 - l) / 1048576.0;
        System.out.println("Memory used after garbage collection: " + decimalFormat.format(d) + "M");
        System.out.println("Meaningless number: " + document.toXML().length());
    }
}

