/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.benchmarks;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import nu.xom.Builder;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.ValidityException;

class TreeWalker {
    TreeWalker() {
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.benchmarks.TreeWalker URL");
            return;
        }
        TreeWalker treeWalker = new TreeWalker();
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            DocType docType = document.getDocType();
            if (docType != null) {
                document.removeChild((Node)docType);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)byteArrayOutputStream);
            serializer.write(document);
            serializer.flush();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            TreeWalker.warmup(byArray, builder, treeWalker, 5, stringArray[0]);
            System.gc();
            System.gc();
            System.gc();
            long l = System.currentTimeMillis();
            Document document2 = TreeWalker.build(byArray, stringArray[0], builder);
            long l2 = System.currentTimeMillis();
            System.out.println(l2 - l + "ms to build the tree");
            long l3 = System.currentTimeMillis();
            TreeWalker.walkTree(treeWalker, document2);
            long l4 = System.currentTimeMillis();
            System.out.println(l4 - l3 + "ms to walk tree");
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(3000000);
            long l5 = System.currentTimeMillis();
            TreeWalker.serialize(document2, byteArrayOutputStream2);
            long l6 = System.currentTimeMillis();
            System.out.println(l6 - l5 + "ms to serialize the tree in UTF-8");
            long l7 = System.currentTimeMillis();
            TreeWalker.prettyPrint(document2, byteArrayOutputStream2);
            long l8 = System.currentTimeMillis();
            System.out.println(l8 - l7 + "ms to pretty print the tree in UTF-8");
            long l9 = System.currentTimeMillis();
            TreeWalker.serializeUTF16(document2, byteArrayOutputStream2);
            long l10 = System.currentTimeMillis();
            System.out.println(l10 - l9 + "ms to serialize the tree in UTF-16");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
    }

    private static void serializeUTF16(Document document, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        Serializer serializer = new Serializer(outputStream, "UTF-16");
        serializer.write(document);
        serializer.flush();
    }

    private static void prettyPrint(Document document, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        Serializer serializer = new Serializer(outputStream, "UTF-8");
        serializer.setIndent(2);
        serializer.setMaxLength(72);
        serializer.write(document);
        serializer.flush();
    }

    private static void serialize(Document document, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        Serializer serializer = new Serializer(outputStream, "UTF-8");
        serializer.write(document);
        serializer.flush();
    }

    private static void walkTree(TreeWalker treeWalker, Document document) throws IOException {
        treeWalker.followNode((Node)document);
    }

    private static Document build(byte[] byArray, String string, Builder builder) throws ParsingException, ValidityException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        Document document = builder.build((InputStream)bufferedInputStream, string);
        return document;
    }

    private static void warmup(byte[] byArray, Builder builder, TreeWalker treeWalker, int n, String string) throws IOException, ParsingException {
        for (int i = 0; i < n; ++i) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            Document document = builder.build((InputStream)bufferedInputStream, string);
            TreeWalker.walkTree(treeWalker, document);
            TreeWalker.serialize(document, new ByteArrayOutputStream(3000000));
            TreeWalker.prettyPrint(document, new ByteArrayOutputStream(4000000));
            TreeWalker.serializeUTF16(document, new ByteArrayOutputStream(4000000));
        }
    }

    public void followNode(Node node) throws IOException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.followNode(node.getChild(i));
        }
    }
}

