/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.ParsingException;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CrimsonPrinter {
    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.CrimsonPrinter URL");
            return;
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
            Builder builder = new Builder(xMLReader);
            Document document = builder.build(stringArray[0]);
            System.out.println(document.toXML());
        }
        catch (ParsingException parsingException) {
            parsingException.printStackTrace();
            System.out.println(stringArray[0] + " is not well-formed.");
            System.out.println(parsingException.getMessage());
            System.out.println(" in line " + parsingException.getLineNumber() + " at column " + parsingException.getColumnNumber());
            parsingException.getCause().printStackTrace();
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not print " + stringArray[0]);
        }
        catch (SAXException sAXException) {
            System.err.println("Could not find the Crimson parser in the classpath.");
        }
    }
}

