/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.ParsingException;

public class ExampleLister {
    private static int chapter = 0;
    private static int exampleNumber = 0;

    public static void list(Element element) {
        chapter = 0;
        if (element.getLocalName().equals("chapter")) {
            ++chapter;
            exampleNumber = 0;
            ExampleLister.list(element);
        } else {
            Elements elements = element.getChildElements();
            for (int i = 0; i < elements.size(); ++i) {
                Element element2 = elements.get(i);
                if (element2.getLocalName().equals("chapter")) {
                    ++chapter;
                    exampleNumber = 0;
                    ExampleLister.findExamples(element2);
                    continue;
                }
                ExampleLister.list(element2);
            }
        }
    }

    private static void findExamples(Element element) {
        Elements elements = element.getChildElements();
        for (int i = 0; i < elements.size(); ++i) {
            Element element2 = elements.get(i);
            if (element2.getQualifiedName().equals("example")) {
                ExampleLister.printExample(element2);
                continue;
            }
            ExampleLister.findExamples(element2);
        }
    }

    private static void printExample(Element element) {
        Element element2 = element.getFirstChildElement("title");
        String string = "Example " + chapter + "." + ++exampleNumber + ": " + element2.getValue();
        System.out.println(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.ExampleLister URL");
            return;
        }
        String string = stringArray[0];
        try {
            Builder builder = new Builder();
            Document document = builder.build(stringArray[0]);
            ExampleLister.list(document.getRootElement());
        }
        catch (ParsingException parsingException) {
            System.out.println((Object)parsingException);
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + string);
            System.out.println(iOException);
        }
    }
}

