/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.SingleThreadModel;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import nu.xom.XMLException;

public class FibonacciXOMXMLRPCServlet
extends HttpServlet
implements SingleThreadModel {
    public static final int MALFORMED_REQUEST_DOCUMENT = 1;
    public static final int INVALID_REQUEST_DOCUMENT = 2;
    public static final int INDEX_MISSING = 3;
    public static final int NON_POSITIVE_INDEX = 4;
    public static final int BAD_INTEGER_FORMAT = 5;
    public static final int UNEXPECTED_PROBLEM = 255;
    private transient Builder parser;

    public void init() throws ServletException {
        try {
            this.parser = new Builder();
        }
        catch (Exception exception) {
            throw new ServletException("Could not locate a JAXP parser", (Throwable)exception);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Document document;
        Element element;
        httpServletResponse.setContentType("application/xml; charset=UTF-8");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        try {
            Document document2 = this.parser.build((InputStream)servletInputStream);
            element = document2.getRootElement();
            Element element2 = element.getFirstChildElement("params");
            String string = element2.getValue().trim();
            int n = Integer.parseInt(string);
            BigInteger bigInteger = FibonacciXOMXMLRPCServlet.calculateFibonacci(n);
            document = this.makeResponseDocument(bigInteger);
        }
        catch (XMLException xMLException) {
            document = this.makeFaultDocument(1, xMLException.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            document = this.makeFaultDocument(3, nullPointerException.getMessage());
        }
        catch (NumberFormatException numberFormatException) {
            document = this.makeFaultDocument(5, numberFormatException.getMessage());
        }
        catch (Exception exception) {
            document = this.makeFaultDocument(255, exception.getMessage());
        }
        try {
            element = new Serializer((OutputStream)servletOutputStream, "US-ASCII");
            element.write(document);
            httpServletResponse.flushBuffer();
            servletOutputStream.flush();
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }

    public Document makeResponseDocument(BigInteger bigInteger) {
        Element element = new Element("methodResponse");
        Element element2 = new Element("params");
        Element element3 = new Element("param");
        Element element4 = new Element("value");
        Element element5 = new Element("double");
        element.appendChild((Node)element2);
        element2.appendChild((Node)element3);
        element3.appendChild((Node)element4);
        element4.appendChild((Node)element5);
        element5.appendChild(bigInteger.toString());
        return new Document(element);
    }

    public Document makeFaultDocument(int n, String string) {
        Element element = new Element("methodResponse");
        Element element2 = new Element("fault");
        Element element3 = new Element("value");
        Element element4 = new Element("struct");
        Element element5 = new Element("member");
        Element element6 = new Element("name");
        Element element7 = new Element("value");
        Element element8 = new Element("int");
        Element element9 = new Element("member");
        Element element10 = new Element("value");
        Element element11 = new Element("string");
        element.appendChild((Node)element2);
        element2.appendChild((Node)element3);
        element3.appendChild((Node)element4);
        element4.appendChild((Node)element5);
        element4.appendChild((Node)element9);
        element5.appendChild((Node)element6);
        element5.appendChild((Node)element7);
        element9.appendChild("name");
        element9.appendChild((Node)element10);
        element6.appendChild("faultCode");
        element7.appendChild((Node)element8);
        element10.appendChild((Node)element11);
        element8.appendChild(String.valueOf(n));
        element11.appendChild(string);
        Document document = new Document(element);
        return document;
    }

    public static BigInteger calculateFibonacci(int n) throws IndexOutOfBoundsException {
        if (n < 1) {
            throw new IndexOutOfBoundsException("Fibonacci numbers are not defined for " + n + "or any other number less than one.");
        }
        BigInteger bigInteger = BigInteger.ONE;
        BigInteger bigInteger2 = BigInteger.ONE;
        for (int i = 2; i <= n; ++i) {
            BigInteger bigInteger3 = bigInteger2;
            bigInteger2 = bigInteger2.add(bigInteger);
            bigInteger = bigInteger3;
        }
        return bigInteger;
    }
}

