/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import java.io.IOException;
import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.ProcessingInstruction;

public class Restructurer {
    public static void processNode(Node node) {
        if (node instanceof Comment || node instanceof ProcessingInstruction) {
            Document document = node.getDocument();
            Element element = document.getRootElement();
            node.detach();
            document.insertChild(node, document.indexOf((Node)element));
        } else {
            for (int i = 0; i < node.getChildCount(); ++i) {
                Restructurer.processNode(node.getChild(i));
            }
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.out.println("Usage: java nu.xom.samples.RestructureDriver URL");
            return;
        }
        String string = stringArray[0];
        try {
            Builder builder = new Builder();
            Document document = builder.build(string);
            Restructurer.processNode((Node)document.getRootElement());
            System.out.println(document.toXML());
        }
        catch (ParsingException parsingException) {
            System.out.println(string + " is not well-formed.");
        }
        catch (IOException iOException) {
            System.out.println("Due to an IOException, the parser could not read " + string);
        }
    }
}

