/*
 * Decompiled with CFR 0.152.
 */
package nu.xom.samples;

import nu.xom.Builder;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

public class SourceCodeGenerator {
    private static int elementCount = 1;

    public static void main(String[] stringArray) {
        Builder builder = new Builder();
        try {
            Document document = builder.build(stringArray[0]);
            SourceCodeGenerator.generateClass(document);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
        }
    }

    public static void generateClass(Document document) {
        System.out.println("import nu.xom.*;");
        System.out.println();
        System.out.println();
        System.out.println("public class CodeMaker {");
        System.out.println();
        System.out.println("  public static void main(String[] args) throws Exception {");
        SourceCodeGenerator.generateDoc(document);
        System.out.println("    Serializer serializer = new Serializer(System.out);");
        System.out.println("    serializer.write(doc);");
        System.out.println("  }");
        System.out.println();
        System.out.println("}");
    }

    public static void generateSource(Node node, String string) {
        if (node instanceof Element) {
            Object object;
            int n;
            Element element = (Element)node;
            String string2 = "element" + elementCount;
            System.out.println("    Element " + string2 + " = " + "new Element(\"" + element.getQualifiedName() + "\", \"" + element.getNamespaceURI() + "\");");
            if ("doc".equals(string)) {
                System.out.println("    doc.setRootElement(" + string2 + ");");
            } else {
                System.out.println("    " + string + ".appendChild(" + string2 + ");");
            }
            for (n = 0; n < element.getAttributeCount(); ++n) {
                object = element.getAttribute(n);
                System.out.println("    " + string2 + ".addAttribute(new Attribute(\"" + object.getQualifiedName() + "\", \"" + object.getNamespaceURI() + "\", \"" + object.getValue() + "\"));");
            }
            for (n = 0; n < element.getNamespaceDeclarationCount(); ++n) {
                object = element.getNamespacePrefix(n);
                System.out.println("    " + string2 + ".addNamespaceDeclaration(\"" + (String)object + "\", \"" + element.getNamespaceURI((String)object) + "\");");
            }
            ++elementCount;
            for (n = 0; n < element.getChildCount(); ++n) {
                SourceCodeGenerator.generateSource(element.getChild(n), string2);
            }
        } else if (node instanceof ProcessingInstruction) {
            ProcessingInstruction processingInstruction = (ProcessingInstruction)node;
            System.out.println("    pi = new ProcessingInstruction(\"" + processingInstruction.getTarget() + "\", \"" + SourceCodeGenerator.javaEscape(processingInstruction.getValue()) + "\");");
            System.out.println("    " + string + ".appendChild(pi);");
        } else if (node instanceof Comment) {
            Comment comment = (Comment)node;
            System.out.println("    comment = new Comment(\"" + SourceCodeGenerator.javaEscape(comment.getValue()) + "\");");
            System.out.println("    " + string + ".appendChild(comment);");
        } else if (node instanceof Text) {
            Text text = (Text)node;
            System.out.println("    text = new Text(\"" + SourceCodeGenerator.javaEscape(text.getValue()) + "\");");
            System.out.println("    " + string + ".appendChild(text);");
        } else if (node instanceof DocType) {
            DocType docType = (DocType)node;
            String string3 = docType.getPublicID();
            String string4 = docType.getSystemID();
            System.out.println("    DocType doctype = new DocType(\"" + docType.getRootElementName() + "\");");
            if (string4 != null) {
                System.out.println("    doctype.setSystemID(\"" + string4 + "\");");
            }
            if (string3 != null) {
                System.out.println("    doctype.setPublicID(\"" + string3 + "\");");
            }
            System.out.println("    doc.setDocType(doctype);");
        }
    }

    private static String javaEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block7;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block7;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block7;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block7;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void generateDoc(Document document) {
        System.out.println("    Comment comment;");
        System.out.println("    Text text;");
        System.out.println("    ProcessingInstruction pi;");
        System.out.println("    Document doc = new Document(new Element(\"root\"));");
        for (int i = 0; i < document.getChildCount(); ++i) {
            SourceCodeGenerator.generateSource(document.getChild(i), "doc");
        }
    }
}

