.\"
.\" Copyright 2001 Keith Packard.\"
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation, and that the name of Keith Packard not be used in
.\" advertising or publicity pertaining to distribution of the software without
.\" specific, written prior permission.  Keith Packard makes no
.\" representations about the suitability of this software for any purpose.  It
.\" is provided "as is" without express or implied warranty.
.\"
.\" KEITH PACKARD DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
.\" EVENT SHALL KEITH PACKARD BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
.\" DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
.\" TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.
.\"
.\"
.\" $XFree86: xc/programs/xrandr/xrandr.man,v 1.6 2003/06/12 14:12:39 eich Exp $
.\"
.TH XRANDR __appmansuffix__ __vendorversion__
.SH NAME
xrandr \- primitive command line interface to RandR extension
.SH SYNOPSIS
.B "xrandr"
[-help]  [-display \fIdisplay\fP]
[-q] [-v]
[--verbose]
[--screen \fIsnum\fP]
.br
.B RandR version 1.2 options
.br
[--prop]
[--fb <width>x<height>]
[--fbmm <width>x<height>]
[--dpi <dpi>]
.br
.B Per-output options
.br
[--output <output>]
[--auto]
[--mode <mode>]
[--preferred]
[--pos <x>x<y>]
[--rate <rate>]
[--reflect \fIreflection\fP]
[--rotate \fIorientation\fP]
[--left-of <output>\]
[--right-of <output>\]
[--above <output>\]
[--below <output>\]
[--off]
[--crtc <crtc>]
.br
.B RandR version 1.0 and version 1.1 options
.br
[-o \fIorientation\fP]
[-s \fIsize\fP]
[-x] [-y]
.SH DESCRIPTION
.I Xrandr
is used to set the size, orientation and/or reflection of the outputs for a
screen. It can also set the screen size.
There are a few global options; the rest modify a particular output and
follow the specification of that output on the command line.
.IP --help
Print out a summary of the usage and exit.
.IP -v
Print out the RandR version reported by the X server and exit.
.IP --verbose
causes xrandr to be more verbose. When used with -q (or without other
options), xrandr will display more information about the server state. When
used along with options that reconfigure the system, progress will be
reported while executing the configuration changes.
.IP -q
When this option is present, or when no configuration changes are requested,
xrandr will display the current state of the system.
.IP "-screen \fIsnum\fP"
This option selects which screen to manipulate. Note this refers to the X
screen abstraction, not the monitor (or output).
.SH "RandR version 1.2 options"
These options are only available for X server supporting RandR version 1.2
or newer.
.IP --prop
This option causes xrandr to display the contents of properties for each
output. --verbose also enables --prop.
.IP "--fb <width>x<height"
Reconfigures the screen to the specified size. All configured monitors must
fit within this size. When this option is not provided, xrandr computes the
smallest screen size that will hold the set of configured outputs; this
option provides a way to override that behaviour.
.IP "--fbmm <width>x<height"
Sets the reported values for the physical size of the screen. Normally,
xrandr resets the reported physical size values to keep the DPI constant.
This overrides that computation.
.IP "--dpi <dpi>"
This also sets the reported physical size values of the screen, it uses the
specified DPI value to compute an appropriate physical size using whatever
pixel size will be set.
.PP
.B "Per-output options"
.IP "--output <output>"
Selects an output to reconfigure. Use either the name of the output or the
XID.
.IP --auto
For connected but disabled outputs, this will enable them using their
preferred mode (or, something close to 96dpi if they have no preferred
mode). For disconnected but enabled outputs, this will disable them.
.IP "--mode <mode>"
This selects a mode. Use either the name or the XID for <mode>
.IP "--preferred"
This selects the same mode as --auto, but it doesn't automatically enable or
disable the output.
.IP "--pos <x>x<y>"
Position the output within the screen using pixel coordinates.
.IP "--rate <rate>
This marks a preference for refresh rates close to the specified value, when
multiple modes have the same name, this will select the one with the nearest
refresh rate.
.IP "--reflect \fIreflection\fP"
Reflection can be one of 'normal' 'x', 'y' or 'xy'. This causes the output
contents to be reflected across the specified axes.
.IP "--rotate \fIrotation\fP"
Rotation can be one of 'normal', 'left', 'right' or 'inverted'. This causes
the output contents to be rotated in the specified direction.
.IP "--left-of, --right-of, --above, --below <another output>"
Use one of these options to position the output relative to the position of
another output. This allows convenient tiling of outputs within the screen.
The position is always computed relative to the new position of the other
output, so it is not valid to say --output a --left-of b --output 
b --left-of a.
.IP "--off"
Disables the output.
.IP "--crtc <crtc>"
Uses the specified crtc (either as an index in the list of CRTCs or XID).
In normal usage, this option is not required as xrandr tries to make
sensible choices about which crtc to use with each output. When that fails
for some reason, this option can override the normal selection.
.PP
.SH "RandR version 1.1 options"
These options are available for X server supporting RandR version 1.1 or
older. They are still valid for newer X servers, but they don't 
.IP "-s <size index> or -s <width>x<height>"
This sets the screen size, either matching by size or using the index into
the list of available sizes.
.IP "-o \fIrotation\fP"
This specifies the orientation of the screen,
and can be one of normal, inverted, left or right.
.IP -x
Reflect across the X axis.
.IP -y
Reflect across the Y axis.
.SH "SEE ALSO"
Xrandr(3)
.SH AUTHORS
Keith Packard,
Open Source Technology Center, Intel Corporation.
and
Jim Gettys, 
Cambridge Research Laboratory, HP Labs, HP.
