.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
projectiveplane - Draws a 4d embedding of the real projective plane.
.SH SYNOPSIS
.B projectiveplane
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-mode \fIdisplay-mode\fP]
[\-wireframe]
[\-surface]
[\-transparent]
[\-appearance \fIappearance\fP]
[\-solid]
[\-distance-bands]
[\-direction-bands]
[\-colors \fIcolor-scheme\fP]
[\-onesided-colors]
[\-twosided-colors]
[\-distance-colors]
[\-direction-colors]
[\-change-colors]
[\-depth-colors]
[\-view-mode \fIview-mode\fP]
[\-walk]
[\-turn]
[\-walk-turn]
[\-orientation-marks]
[\-projection-3d \fImode\fP]
[\-perspective-3d]
[\-orthographic-3d]
[\-projection-4d \fImode\fP]
[\-perspective-4d]
[\-orthographic-4d]
[\-speed-wx \fIfloat\fP]
[\-speed-wy \fIfloat\fP]
[\-speed-wz \fIfloat\fP]
[\-speed-xy \fIfloat\fP]
[\-speed-xz \fIfloat\fP]
[\-speed-yz \fIfloat\fP]
[\-walk-direction \fIfloat\fP]
[\-walk-speed \fIfloat\fP]
.SH DESCRIPTION
The \fIprojectiveplane\fP program shows a 4d embedding of the real
projective plane.  You can walk on the projective plane, see it turn
in 4d, or walk on it while it turns in 4d.  The fact that the surface
is an embedding of the real projective plane in 4d can be seen in the
depth colors mode (using static colors): set all rotation speeds to 0
and the projection mode to 4d orthographic projection.  In its default
orientation, the embedding of the real projective plane will then
project to the Roman surface, which has three lines of
self-intersection.  However, at the three lines of self-intersection
the parts of the surface that intersect have different colors, i.e.,
different 4d depths.
.PP
The real projective plane is a non-orientable surface.  To make this
apparent, the two-sided color mode can be used.  Alternatively,
orientation markers (curling arrows) can be drawn as a texture map on
the surface of the projective plane.  While walking on the projective
plane, you will notice that the orientation of the curling arrows
changes (which it must because the projective plane is
non-orientable).
.PP
The real projective plane is a model for the projective geometry in 2d
space.  One point can be singled out as the origin.  A line can be
singled out as the line at infinity, i.e., a line that lies at an
infinite distance to the origin.  The line at infinity, like all lines
in the projective plane, is topologically a circle.  Points on the
line at infinity are also used to model directions in projective
geometry.  The origin can be visualized in different manners.  When
using distance colors (and using static colors), the origin is the
point that is displayed as fully saturated red, which is easier to see
as the center of the reddish area on the projective plane.
Alternatively, when using distance bands, the origin is the center of
the only band that projects to a disk.  When using direction bands,
the origin is the point where all direction bands collapse to a point.
Finally, when orientation markers are being displayed, the origin the
the point where all orientation markers are compressed to a point.
The line at infinity can also be visualized in different ways.  When
using distance colors (and using static colors), the line at infinity
is the line that is displayed as fully saturated magenta.  When
two-sided (and static) colors are used, the line at infinity lies at
the points where the red and green "sides" of the projective plane
meet (of course, the real projective plane only has one side, so this
is a design choice of the visualization).  Alternatively, when
orientation markers are being displayed, the line at infinity is the
place where the orientation markers change their orientation.
.PP
Note that when the projective plane is displayed with bands, the
orientation markers are placed in the middle of the bands.  For
distance bands, the bands are chosen in such a way that the band at
the origin is only half as wide as the remaining bands, which results
in a disk being displayed at the origin that has the same diameter as
the remaining bands.  This choice, however, also implies that the band
at infinity is half as wide as the other bands.  Since the projective
plane is attached to itself (in a complicated fashion) at the line at
infinity, effectively the band at infinity is again as wide as the
remaining bands.  However, since the orientation markers are displayed
in the middle of the bands, this means that only one half of the
orientation markers will be displayed twice at the line at infinity if
distance bands are used.  If direction bands are used or if the
projective plane is displayed as a solid surface, the orientation
markers are displayed fully at the respective sides of the line at
infinity.
.PP
The program projects the 4d projective plane to 3d using either a
perspective or an orthographic projection.  Which of the two
alternatives looks more appealing is up to you.  However, two famous
surfaces are obtained if orthographic 4d projection is used: The Roman
surface and the cross cap.  If the projective plane is rotated in 4d,
the result of the projection for certain rotations is a Roman surface
and for certain rotations it is a cross cap.  The easiest way to see
this is to set all rotation speeds to 0 and the rotation speed around
the yz plane to a value different from 0.  However, for any 4d
rotation speeds, the projections will generally cycle between the
Roman surface and the cross cap.  The difference is where the origin
and the line at infinity will lie with respect to the
self-intersections in the projections to 3d.
.PP
The projected projective plane can then be projected to the screen
either perspectively or orthographically.  When using the walking
modes, perspective projection to the screen will be used.
.PP
There are three display modes for the projective plane: mesh
(wireframe), solid, or transparent.  Furthermore, the appearance of
the projective plane can be as a solid object or as a set of
see-through bands.  The bands can be distance bands, i.e., bands that
lie at increasing distances from the origin, or direction bands, i.e.,
bands that lie at increasing angles with respect to the origin.
.PP
When the projective plane is displayed with direction bands, you will
be able to see that each direction band (modulo the "pinching" at the
origin) is a Moebius strip, which also shows that the projective plane
is non-orientable.
.PP
Finally, the colors with with the projective plane is drawn can be set
to one-sided, two-sided, distance, direction, or depth.  In one-sided
mode, the projective plane is drawn with the same color on both
"sides."  In two-sided mode (using static colors), the projective
plane is drawn with red on one "side" and green on the "other side."
As described above, the projective plane only has one side, so the
color jumps from red to green along the line at infinity.  This mode
enables you to see that the projective plane is non-orientable.  If
changing colors are used in two-sided mode, changing complementary
colors are used on the respective "sides."  In distance mode, the
projective plane is displayed with fully saturated colors that depend
on the distance of the points on the projective plane to the origin.
If static colors are used, the origin is displayed in red, while the
line at infinity is displayed in magenta.  If the projective plane is
displayed as distance bands, each band will be displayed with a
different color.  In direction mode, the projective plane is displayed
with fully saturated colors that depend on the angle of the points on
the projective plane with respect to the origin.  Angles in opposite
directions to the origin (e.g., 15 and 205 degrees) are displayed in
the same color since they are projectively equivalent.  If the
projective plane is displayed as direction bands, each band will be
displayed with a different color.  Finally, in depth mode the
projective plane is displayed with colors chosen depending on the 4d
"depth" (i.e., the w coordinate) of the points on the projective plane
at its default orientation in 4d.  As discussed above, this mode
enables you to see that the projective plane does not intersect itself
in 4d.
.PP
The rotation speed for each of the six planes around which the
projective plane rotates can be chosen.  For the walk-and-turn mode,
only the rotation speeds around the true 4d planes are used (the xy,
xz, and yz planes).
.PP
Furthermore, in the walking modes the walking direction in the 2d base
square of the projective plane and the walking speed can be chosen.
The walking direction is measured as an angle in degrees in the 2d
square that forms the coordinate system of the surface of the
projective plane.  A value of 0 or 180 means that the walk is along a
circle at a randomly chosen distance from the origin (parallel to a
distance band).  A value of 90 or 270 means that the walk is directly
from the origin to the line at infinity and back (analogous to a
direction band).  Any other value results in a curved path from the
origin to the line at infinity and back.
.PP
This program is somewhat inspired by Thomas Banchoff's book "Beyond
the Third Dimension: Geometry, Computer Graphics, and Higher
Dimensions", Scientific American Library, 1990.
.SH OPTIONS
.I projectiveplane
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 10000, or 1/100th second.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following four options are mutually exclusive.  They determine how
the projective plane is displayed.
.TP 8
.B \-mode random
Display the projective plane in a random display mode (default).
.TP 8
.B \-mode wireframe \fP(Shortcut: \fB\-wireframe\fP)
Display the projective plane as a wireframe mesh.
.TP 8
.B \-mode surface \fP(Shortcut: \fB\-surface\fP)
Display the projective plane as a solid surface.
.TP 8
.B \-mode transparent \fP(Shortcut: \fB\-transparent\fP)
Display the projective plane as a transparent surface.
.PP
The following three options are mutually exclusive.  They determine
the appearance of the projective plane.
.TP 8
.B \-appearance random
Display the projective plane with a random appearance (default).
.TP 8
.B \-appearance solid \fP(Shortcut: \fB\-solid\fP)
Display the projective plane as a solid object.
.TP 8
.B \-appearance distance-bands \fP(Shortcut: \fB\-distance-bands\fP)
Display the projective plane as see-through bands that lie at
increasing distances from the origin.
.PP
.TP 8
.B \-appearance direction-bands \fP(Shortcut: \fB\-direction-bands\fP)
Display the projective plane as see-through bands that lie at
increasing angles with respect to the origin.
.PP
The following four options are mutually exclusive.  They determine how
to color the projective plane.
.TP 8
.B \-colors random
Display the projective plane with a random color scheme (default).
.TP 8
.B \-colors onesided \fP(Shortcut: \fB\-onesided-colors\fP)
Display the projective plane with a single color.
.TP 8
.B \-colors twosided \fP(Shortcut: \fB\-twosided-colors\fP)
Display the projective plane with two colors: one color one "side" and
the complementary color on the "other side."  For static colors, the
colors are red and green.  Note that the line at infinity lies at the
points where the red and green "sides" of the projective plane meet,
i.e., where the orientation of the projective plane reverses.
.TP 8
.B \-colors distance \fP(Shortcut: \fB\-distance-colors\fP)
Display the projective plane with fully saturated colors that depend
on the distance of the points on the projective plane to the origin.
For static colors, the origin is displayed in red, while the line at
infinity is displayed in magenta.  If the projective plane is
displayed as distance bands, each band will be displayed with a
different color.
.TP 8
.B \-colors direction \fP(Shortcut: \fB\-direction-colors\fP)
Display the projective plane with fully saturated colors that depend
on the angle of the points on the projective plane with respect to the
origin.  Angles in opposite directions to the origin (e.g., 15 and 205
degrees) are displayed in the same color since they are projectively
equivalent.  If the projective plane is displayed as direction bands,
each band will be displayed with a different color.
.TP 8
.B \-colors depth \fP(Shortcut: \fB\-depth\fP)
Display the projective plane with colors chosen depending on the 4d
"depth" (i.e., the w coordinate) of the points on the projective plane
at its default orientation in 4d.
.PP
The following options determine whether the colors with which the
projective plane is displayed are static or are changing dynamically.
.TP 8
.B \-change-colors
Change the colors with which the projective plane is displayed
dynamically.
.TP 8
.B \-no-change-colors
Use static colors to display the projective plane (default).
.PP
The following four options are mutually exclusive.  They determine how
to view the projective plane.
.TP 8
.B \-view-mode random
View the projective plane in a random view mode (default).
.TP 8
.B \-view-mode turn \fP(Shortcut: \fB\-turn\fP)
View the projective plane while it turns in 4d.
.TP 8
.B \-view-mode walk \fP(Shortcut: \fB\-walk\fP)
View the projective plane as if walking on its surface.
.TP 8
.B \-view-mode walk-turn \fP(Shortcut: \fB\-walk-turn\fP)
View the projective plane as if walking on its surface.  Additionally,
the projective plane turns around the true 4d planes (the xy, xz, and
yz planes).
.PP
The following options determine whether orientation marks are shown on
the projective plane.
.TP 8
.B \-orientation-marks
Display orientation marks on the projective plane.
.TP 8
.B \-no-orientation-marks
Don't display orientation marks on the projective plane (default).
.PP
The following three options are mutually exclusive.  They determine
how the projective plane is projected from 3d to 2d (i.e., to the
screen).
.TP 8
.B \-projection-3d random
Project the projective plane from 3d to 2d using a random projection
mode (default).
.TP 8
.B \-projection-3d perspective \fP(Shortcut: \fB\-perspective-3d\fP)
Project the projective plane from 3d to 2d using a perspective
projection.
.TP 8
.B \-projection-3d orthographic \fP(Shortcut: \fB\-orthographic-3d\fP)
Project the projective plane from 3d to 2d using an orthographic
projection.
.PP
The following three options are mutually exclusive.  They determine
how the projective plane is projected from 4d to 3d.
.TP 8
.B \-projection-4d random
Project the projective plane from 4d to 3d using a random projection
mode (default).
.TP 8
.B \-projection-4d perspective \fP(Shortcut: \fB\-perspective-4d\fP)
Project the projective plane from 4d to 3d using a perspective
projection.
.TP 8
.B \-projection-4d orthographic \fP(Shortcut: \fB\-orthographic-4d\fP)
Project the projective plane from 4d to 3d using an orthographic
projection.
.PP
The following six options determine the rotation speed of the
projective plane around the six possible hyperplanes.  The rotation
speed is measured in degrees per frame.  The speeds should be set to
relatively small values, e.g., less than 4 in magnitude.  In walk
mode, all speeds are ignored.  In walk-and-turn mode, the 3d rotation
speeds are ignored (i.e., the wx, wy, and wz speeds).  In
walk-and-turn mode, smaller speeds must be used than in the turn mode
to achieve a nice visualization.  Therefore, in walk-and-turn mode the
speeds you have selected are divided by 5 internally.
.TP 8
.B \-speed-wx \fIfloat\fP
Rotation speed around the wx plane (default: 1.1).
.TP 8
.B \-speed-wy \fIfloat\fP
Rotation speed around the wy plane (default: 1.3).
.TP 8
.B \-speed-wz \fIfloat\fP
Rotation speed around the wz plane (default: 1.5).
.TP 8
.B \-speed-xy \fIfloat\fP
Rotation speed around the xy plane (default: 1.7).
.TP 8
.B \-speed-xz \fIfloat\fP
Rotation speed around the xz plane (default: 1.9).
.TP 8
.B \-speed-yz \fIfloat\fP
Rotation speed around the yz plane (default: 2.1).
.PP
The following two options determine the walking speed and direction.
.TP 8
.B \-walk-direction \fIfloat\fP
The walking direction is measured as an angle in degrees in the 2d
square that forms the coordinate system of the surface of the
projective plane (default: 83.0).  A value of 0 or 180 means that the
walk is along a circle at a randomly chosen distance from the origin
(parallel to a distance band).  A value of 90 or 270 means that the
walk is directly from the origin to the line at infinity and back
(analogous to a direction band).  Any other value results in a curved
path from the origin to the line at infinity and back.
.TP 8
.B \-walk-speed \fIfloat\fP
The walking speed is measured in percent of some sensible maximum
speed (default: 20.0).
.SH INTERACTION
If you run this program in standalone mode in its turn mode, you can
rotate the projective plane by dragging the mouse while pressing the
left mouse button.  This rotates the projective plane in 3D, i.e.,
around the wx, wy, and wz planes.  If you press the shift key while
dragging the mouse with the left button pressed the projective plane
is rotated in 4D, i.e., around the xy, xz, and yz planes.  To examine
the projective plane at your leisure, it is best to set all speeds to
0.  Otherwise, the projective plane will rotate while the left mouse
button is not pressed.  This kind of interaction is not available in
the two walk modes.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2013-2020 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 06-jan-2020.
