.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
sphereeversion - Displays a sphere eversion.
.SH SYNOPSIS
.B sphereeversion
[\-display \fIhost:display.screen\fP]
[\-install]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fIusecs\fP]
[\-fps]
[\-eversion-method \fImethod\fP]
[\-analytic]
[\-corrugations]
[\-mode \fIdisplay-mode\fP]
[\-surface]
[\-transparent]
[\-appearance \fIappearance\fP]
[\-solid]
[\-parallel-bands]
[\-meridian-bands]
[\-graticule \fImode\fP]
[\-colors \fIcolor-scheme\fP]
[\-twosided-colors]
[\-parallel-colors]
[\-meridian-colors]
[\-earth-colors]
[\-deformation-speed \fIfloat\fP]
[\-projection \fImode\fP]
[\-perspective]
[\-orthographic]
[\-surface-order \fIorder\fP]
[\-lunes-1]
[\-lunes-2]
[\-lunes-4]
[\-lunes-8]
[\-hemispheres-1]
[\-hemispheres-2]
[\-speed-x \fIfloat\fP]
[\-speed-y \fIfloat\fP]
[\-speed-z \fIfloat\fP]
.SH DESCRIPTION
The \fIsphereeversion\fP program shows a sphere eversion, i.e., a
smooth deformation (homotopy) that turns a sphere inside out.  During
the eversion, the deformed sphere is allowed to intersect itself
transversally.  However, no creases or pinch points are allowed to
occur.
.PP
The sphere can be deformed with two eversion methods: analytic or
corrugations. The analytic sphere eversion method is described in the
following paper: Adam Bednorz, Witold Bednorz: "Analytic sphere
eversion using ruled surfaces", Differential Geometry and its
Applications 64:59-79, 2019. The corrugations sphere eversion method
is described in the video "Outside In" by the Geometry Center (Bill
Thurston, Silvio Levy, Delle Maxwell, Tamara Munzner, Nathaniel
Thurston, David Ben-Zvi, Matt Headrick, et al.), 1994, and the
accompanying booklet: Silvio Levy: "Making Waves - A Guide to the
Ideas Behind Outside In", A K Peters, Wellesley, MA, 1995. See also
the section "Brief Description of the Corrugations Sphere Eversion
Method" below.
.PP
The deformed sphere can be projected to the screen either
perspectively or orthographically.
.PP
There are three display modes for the sphere: solid, transparent, or
random.  If random mode is selected, the mode is changed each time an
eversion has been completed.
.PP
The appearance of the sphere can be as a solid object, as a set of
see-through bands, or random.  The bands can be parallel bands or
meridian bands, i.e., bands that run along the parallels (lines of
latitude) or bands that run along the meridians (lines of longitude)
of the sphere.  If random mode is selected, the appearance is changed
each time an eversion has been completed.
.PP
For the analytic sphere eversion, it is also possible to display a
graticule (i.e., a coordinate grid consisting of parallel and meridian
lines) on top of the surface.  The graticule mode can be set to on,
off, or random.  If random mode is selected, the graticule mode is
changed each time an eversion has been completed.
.PP
The colors with with the sphere is drawn can be set to two-sided,
parallel, meridian, earth, or random.  In two-sided mode, the sphere
is drawn with red on one side and green on the other side (analytic
eversion) or with gold on one side and purple on the other side
(corrugations eversion).  In parallel mode, the sphere is displayed
with colors that run from blue to white to orange on one side of the
surface and from magenta to black to green on the other side.  The
colors are aligned with the parallels of the sphere in this mode.  In
meridian mode, the the sphere is displayed with colors that run from
blue to white to orange to black and back to blue on one side of the
surface and from magenta to white to green to black and back to
magenta on the other side.  The colors are aligned with the meridians
of the sphere in this mode.  In earth mode, the sphere is drawn with a
texture of earth by day on one side and with a texture of earth by
night on the other side.  Initially, the earth by day is on the
outside and the earth by night on the inside.  After the first
eversion, the earth by night will be on the outside.  All points of
the earth on the inside and outside are at the same positions on the
sphere.  Since an eversion transforms the sphere into its inverse, the
earth by night will appear with all continents mirror reversed.  If
random mode is selected, the color scheme is changed each time an
eversion has been completed.
.PP
By default, the sphere is rotated to a new viewing position each time
an eversion has been completed.  In addition, it is possible to rotate
the sphere while it is deforming.  The rotation speed for each of the
three coordinate axes around which the sphere rotates can be chosen
arbitrarily.  For best effects, however, it is suggested to rotate
only around the z axis while the sphere is deforming.
.PP
For the analytic sphere eversion, it is possible to define a surface
order of the sphere eversion as random or as a value between 2 and 5.
This determines the the complexity of the deformation.  For higher
surface orders, some z-fighting might occur around the central stage
of the eversion, which might lead to some irregular flickering of the
displayed surface if it is displayed as a solid object.  For odd
surface orders, z-fighting will occur very close to the central stage
of the eversion since the deformed sphere is a doubly covered Boy
surface (for surface order 3) or a doubly covered generalized Boy
surface (for surface order 5) in this case.  If you find this
distracting, you should set the surface order to 2.  If a random
surface order is selected, the surface order is changed each time an
eversion has been completed.
.SH BRIEF DESCRIPTION OF THE CORRUGATIONS SPHERE EVERSION METHOD
The corrugations sphere eversion method is described in detail in the
video and booklet mentioned above. Briefly, the method works as
follows: Imagine the sphere cut into eight spherical lunes (spherical
biangles).  Now imagine each lune to be a belt.  The ends of the belt
(which correspond to the north and south poles of the sphere) are
pushed past each other.  This creates a loop in the belt.  If the belt
were straightened out, it would contain a 360 degree rotation.  This
rotation can be removed by rotating each end of the belt by 180
degrees.  Finally, the belt is pushed to the opposite side of the
sphere, which causes the side of the belt that initially was inside
the sphere to appear on the outside.
.PP
The method described so far only works for a single lune (belt) and
not for the entire sphere.  To make it work for the entire sphere,
corrugations (i.e., waves) must be added to the sphere.  This happens
in the first phase of the eversion.  Then, the method described above
is applied to the eight lunes.  Finally, the corrugations are removed
to obtain the everted sphere.
.PP
To see the eversion for a single lune, the option \fB\-lunes-1\fP can
be used.  Using this option, the eversion, as described above, is
easier to understand.  It is also possible to display two lunes using
\fB\-lunes-2\fP and four lunes using \fB\-lunes-4\fP.  Using fewer
than eight lunes reduces the visual complexity of the eversion and may
help to understand the method.
.PP
Furthermore, it is possible to display only one hemisphere using the
option \fB\-hemispheres-1\fP.  This allows to see what is happening in
the center of the sphere during the eversion.  Note that the north and
south half of the sphere move in a symmetric fashion during the
eversion.  Hence, the eversion is actually composed of 16 semi-lunes
(spherical triangles from the equator to the poles) that all deform in
the same manner.  By specifying \fB\-lunes-1 \-hemispheres-1\fP, the
deformation of one semi-lune can be observed.
.PP
Note that the options described above are only intended for
educational purposes.  They are not used if none of them are
explicitly specified.

.SH OPTIONS
.I sphereeversion
accepts the following options:
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-install
Install a private colormap for the window.
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 10000, or 1/100th second.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following three options are mutually exclusive.  They determine
which sphere eversion method is used.
.TP 8
.B \-eversion-method random
Use a random sphere eversion method (default).
.TP 8
.B \-eversion-method analytic \fP(Shortcut: \fB\-analytic\fP)
Use the analytic sphere eversion method.
.TP 8
.B \-eversion-method corrugations \fP(Shortcut: \fB\-corrugations\fP)
Use the corrugations sphere eversion method.
.PP
The following three options are mutually exclusive.  They determine
how the deformed sphere is displayed.
.TP 8
.B \-mode random
Display the sphere in a random display mode (default).
.TP 8
.B \-mode surface \fP(Shortcut: \fB\-surface\fP)
Display the sphere as a solid surface.
.TP 8
.B \-mode transparent \fP(Shortcut: \fB\-transparent\fP)
Display the sphere as a transparent surface.
.PP
The following four options are mutually exclusive.  They determine the
appearance of the deformed sphere.
.TP 8
.B \-appearance random
Display the sphere with a random appearance (default).
.TP 8
.B \-appearance solid \fP(Shortcut: \fB\-solid\fP)
Display the sphere as a solid object.
.TP 8
.B \-appearance parallel-bands \fP(Shortcut: \fB\-parallel-bands\fP)
Display the sphere as see-through bands that lie along the parallels
of the sphere.
.TP 8
.B \-appearance meridian-bands \fP(Shortcut: \fB\-meridian-bands\fP)
Display the sphere as see-through bands that lie along the meridians
of the sphere.
.PP
The following three options are mutually exclusive.  They determine
whether a graticule is displayed on top of the sphere.  These options
only have an effect if the analytic sphere eversion method is
selected.
.TP 8
.B \-graticule random
Randomly choose whether to display a graticule (default).
.TP 8
.B \-graticule on
Display a graticule.
.TP 8
.B \-graticule off
Do not display a graticule.
.PP
The following five options are mutually exclusive.  They determine how
to color the deformed sphere.
.TP 8
.B \-colors random
Display the sphere with a random color scheme (default).
.TP 8
.B \-colors twosided \fP(Shortcut: \fB\-twosided-colors\fP)
Display the sphere with two colors: red on one side and green on the
other side (analytic eversion) or gold on one side and purple on the
other side (corrugations eversion).
.TP 8
.B \-colors parallel \fP(Shortcut: \fB\-parallel-colors\fP)
Display the sphere with colors that run from from blue to white to
orange on one side of the surface and from magenta to black to green
on the other side.  The colors are aligned with the parallels of the
sphere.  If the sphere is displayed as parallel bands, each band will
be displayed with a different color.
.TP 8
.B \-colors meridian \fP(Shortcut: \fB\-meridian-colors\fP)
Display the sphere with colors that run from from blue to white to
orange to black and back to blue on one side of the surface and from
magenta to white to green to black and back to magenta on the other
side.  The colors are aligned with the meridians of the sphere.  If
the sphere is displayed as meridian bands, each band will be displayed
with a different color.
.TP 8
.B \-colors earth \fP(Shortcut: \fB\-earth-colors\fP)
Display the sphere with a texture of earth by day on one side and with
a texture of earth by night on the other side.  Initially, the earth
by day is on the outside and the earth by night on the inside.  After
the first eversion, the earth by night will be on the outside.  All
points of the earth on the inside and outside are at the same
positions on the sphere.  Since an eversion transforms the sphere into
its inverse, the earth by night will appear with all continents mirror
reversed.
.PP
The following option determines the deformation speed.
.TP 8
.B \-deformation-speed \fIfloat\fP
The deformation speed is measured in percent of some sensible maximum
speed (default: 10.0).
.PP
The following three options are mutually exclusive.  They determine
how the deformed sphere is projected from 3d to 2d (i.e., to the
screen).
.TP 8
.B \-projection random
Project the sphere from 3d to 2d using a random projection mode
(default).
.TP 8
.B \-projection perspective \fP(Shortcut: \fB\-perspective\fP)
Project the sphere from 3d to 2d using a perspective projection.
.TP 8
.B \-projection orthographic \fP(Shortcut: \fB\-orthographic\fP)
Project the sphere from 3d to 2d using an orthographic projection.
.PP
The following option determines the order of the surface to be
displayed.  This option only has an effect if the analytic sphere
eversion method is selected.
.TP 8
.B \-surface-order \fIorder\fP
The surface order can be set to random or to a value between 2 and 5
(default: random).  This determines the the complexity of the
deformation.
.PP
The following four options are mutually exclusive.  They determine how
many lunes of the sphere are displayed.  These options only have an
effect if the corrugations sphere eversion method is selected.
.TP 8
.B \-lunes-1
Display one of the eight lunes that form the sphere.
.TP 8
.B \-lunes-2
Display two of the eight lunes that form the sphere.
.TP 8
.B \-lunes-4
Display four of the eight lunes that form the sphere.
.TP 8
.B \-lunes-8
Display all eight lunes that form the sphere (default).
.PP
The following two options are mutually exclusive.  They determine how
many hemispheres of the sphere are displayed.  These options only have
an effect if the corrugations sphere eversion method is selected.
.TP 8
.B \-hemispheres-1
Display only one hemisphere of the sphere.
.TP 8
.B \-hemispheres-2
Display both hemispheres of the sphere (default).
.PP
The following three options determine the rotation speed of the
deformed sphere around the three possible axes.  The rotation speed is
measured in degrees per frame.  The speeds should be set to relatively
small values, e.g., less than 4 in magnitude.
.TP 8
.B \-speed-x \fIfloat\fP
Rotation speed around the x axis (default: 0.0).
.TP 8
.B \-speed-y \fIfloat\fP
Rotation speed around the y axis (default: 0.0).
.TP 8
.B \-speed-z \fIfloat\fP
Rotation speed around the z axis (default: 0.0).
.SH INTERACTION
If you run this program in standalone mode, you can rotate the
deformed sphere by dragging the mouse while pressing the left mouse
button.  This rotates the sphere in 3d.  To examine the deformed
sphere at your leisure, it is best to set all speeds to 0.  Otherwise,
the deformed sphere will rotate while the left mouse button is not
pressed.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2020 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.PP
Parts of the code in this program are based on the program
sphereEversion-0.4-src.zip
(https://profs.etsmtl.ca/mmcguffin/eversion/) by Michael J. McGuffin,
which, in turn, is based on the program evert.tar.Z
(http://www.geom.uiuc.edu/docs/outreach/oi/software.html) developed
by Nathaniel Thurston at the Geometry Center.  The modified code is
used with permission.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 01-jun-2020.
