.TH XScreenSaver 1 "6-Jan-2021 (6.00)" "X Version 11"
.SH NAME
xscreensaver-command - control a running xscreensaver process
.SH SYNOPSIS
.B xscreensaver-command
[\-\-display \fIhost:display.screen\fP] \
[\-\-help | \
\-\-quiet | \
\-\-verbose | \
\-\-activate | \
\-\-deactivate | \
\-\-cycle | \
\-\-next | \
\-\-prev | \
\-\-select \fIn\fP | \
\-\-lock | \
\-\-suspend | \
\-\-exit | \
\-\-restart | \
\-\-time | \
\-\-watch | \
\-\-version]
.SH DESCRIPTION
The \fIxscreensaver\-command\fP program controls a running
.BR xscreensaver (1)
daemon.
.SH OPTIONS
.I xscreensaver-command
accepts the following command-line options:
.TP 8
.B \-\-help
Prints a brief summary of command-line options.
.TP 8
.B \-\-quiet
Only print output if an error occurs.
.TP 8
.B \-\-verbose
Opposite of \-\-quiet. Default.
.TP 8
.B \-\-activate
Tell xscreensaver to turn on immediately (that is, blank the screen, as if
the user had been idle for long enough.)  The screensaver will deactivate as
soon as there is any user activity, as usual.
.TP 8
.B \-\-deactivate
This tells xscreensaver to pretend that there has just been user activity.
This means that if the screensaver is active (the screen is blanked),
then this command will cause the screen to un-blank as if there had been
keyboard or mouse activity.  If the screen is locked, then the password
dialog will pop up first, as usual.  If the screen is not blanked, then
this simulated user activity will re-start the countdown (so, issuing
the \fI\-\-deactivate\fP command periodically is \fIone\fP way to prevent
the screen from blanking.)
.TP 8
.B \-\-cycle
If the screensaver is active (the screen is blanked), then stop the current
graphics demo and run a new one (chosen randomly.)
.TP 8
.B \-\-next
This is like either \fI\-\-activate\fP or \fI\-\-cycle\fP, depending on which
is more appropriate, except that the graphics hack that will be run is the
next one in the list, instead of a randomly-chosen one.  In other words,
repeatedly executing -next will cause the xscreensaver process to invoke each
graphics demo sequentially.  (Though using the \fI\-\-settings\fP option is
probably an easier way to accomplish that.)
.TP 8
.B \-\-prev
This is like \fI\-\-next\fP, but cycles in the other direction.
.TP 8
.B \-\-select \fInumber\fP
Like \fI\-\-activate\fP, but runs the \fIN\fPth element in the list of hacks.
By knowing what is in the \fIprograms\fP list, and in what order, you can use
this to activate the screensaver with a particular graphics demo.  (The first
element in the list is numbered 1, not 0.)
.TP 8
.B \-\-lock
Tells the running xscreensaver process to lock the screen immediately.  
This is like \fI\-\-activate\fP, but forces locking as well, even if locking
is not the default (that is, even if xscreensaver's \fIlock\fP resource is
false, and even if the \fIlockTimeout\fP resource is non-zero.)

Note that locking doesn't work unless the \fIxscreensaver\fP process is
running as you.  See 
.BR xscreensaver (1)
for details.
.TP 8
.B \-\-suspend
Like \fI\-\-activate\fP, but ignores \fIlockTimeout\fP and immediately
powers off the screen without fading out.  This is intended to be run
just after your laptop's lid is closed, and just before the CPU halts,
to lock things down quickly.
.TP 8
.B \-\-exit
Causes the xscreensaver process to exit gracefully.  
This does nothing if the display is currently locked.
.B Warning:
never use \fIkill -9\fP with \fIxscreensaver\fP while the screensaver is
active.  If you are using a virtual root window manager, that can leave
things in an inconsistent state, and you may need to restart your window
manager to repair the damage.
.TP 8
.B \-\-restart
Causes the screensaver process to exit and then restart with the same command
line arguments as last time.  You shouldn't really need to do this,
since xscreensaver notices when the \fI.xscreensaver\fP file has
changed and re-reads it as needed.
.TP 8
.B \-\-time
Prints the time at which the screensaver last activated or 
deactivated (roughly, how long the user has been idle or non-idle: but 
not quite, since it only tells you when the screen became blanked or
un-blanked.)
.TP 8
.B \-\-watch
Prints a line each time the screensaver changes state: when the screen
blanks, locks, unblanks, or when the running hack is changed.  This option
never returns; it is intended for use by shell scripts that want to react to
the screensaver in some way.  An example of its output would be:
.nf
.sp
	BLANK Fri Nov  5 01:57:22 1999
	RUN 34
	RUN 79
	RUN 16
	LOCK Fri Nov  5 01:57:22 1999
	RUN 76
	RUN 12
	UNBLANK Fri Nov  5 02:05:59 1999
.sp
.fi
The above shows the screensaver activating, running three different
hacks, then locking (perhaps because the lock-timeout went off) then
unblanking (because the user became active, and typed the correct
password.)  The hack numbers are their index in the `programs'
list (starting with 1, not 0, as for the \fI\-\-select\fP command.)

For example, suppose you want to run a program that turns down the volume
on your machine when the screen blanks, and turns it back up when the screen
un-blanks.  You could do that by running a Perl program like the following
in the background.  The following program tracks the output of 
the \fI\-\-watch\fP command and reacts accordingly:
.nf
.sp
	#!/usr/bin/perl

	my $blanked = 0;
	open (my $in, "xscreensaver-command -watch |") || die;
	while (<$in>) {
	  if (m/^(BLANK|LOCK)/) {
	    if (!$blanked) {
	      system ("sound-off");
	      $blanked = 1;
	    }
	  } elsif (m/^UNBLANK/) {
	    system ("sound-on");
	    $blanked = 0;
	  }
	}
.sp
.fi
Note that LOCK might come either with or without a preceding BLANK
(depending on whether the lock-timeout is non-zero), so the above program
keeps track of both of them.
.TP 8
.B \-\-version
Prints the version of xscreensaver that is currently running on the display:
that is, the actual version number of the running xscreensaver background 
process, rather than the version number of xscreensaver-command.  (To see
the version number of \fIxscreensaver-command\fP itself, use 
the \fI\-\-help\fP option.)
.SH STOPPING GRAPHICS
If xscreensaver is running, but you want it to stop running screen hacks
(e.g., if you are logged in remotely, and you want the console to remain
locked but just be black, with no graphics processes running) you can 
accomplish that by simply powering down the monitor remotely.  In a
minute or so, xscreensaver will notice that the monitor is off, and
will stop running screen hacks.  You can power off the monitor like so:
.nf
.sp
	xset dpms force off
.sp
.fi
See the
.BR xset (1)
manual for more info.

You can also use
.BR xscreensaver\-settings (1)
to make the monitor power down after a few hours, meaning that xscreensaver
will run graphics until it has been idle for the length of time you
specified; and after that, the monitor will power off, and screen hacks
will stop being run.
.SH DIAGNOSTICS
If an error occurs while communicating with the \fIxscreensaver\fP daemon, or
if the daemon reports an error, a diagnostic message will be printed to
stderr, and \fIxscreensaver-command\fP will exit with a non-zero value.  If
the command is accepted, an indication of this will be printed to stdout, and
the exit value will be zero.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the host and display number of the screen whose saver is
to be manipulated.
.TP 8
.B PATH
to find the executable to restart (for the \fI\-\-restart\fP command).  
Note that this variable is consulted in the environment of 
the \fIxscreensaver\fP process, not the \fIxscreensaver-command\fP process.
.SH UPGRADES
The latest version of
.BR xscreensaver (1)
and related tools can always be found at https://www.jwz.org/xscreensaver/
.SH "SEE ALSO"
.BR X (1),
.BR xscreensaver (1),
.BR xscreensaver\-settings (1),
.BR xset (1)
.SH COPYRIGHT
Copyright \(co 1992-2021 by Jamie Zawinski.
Permission to use, copy, modify, distribute, and sell this software
and its documentation for any purpose is hereby granted without fee,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.  No representations are made about the
suitability of this software for any purpose.  It is provided "as is"
without express or implied warranty.
.SH AUTHOR
Jamie Zawinski <jwz@jwz.org>, 13-aug-1992.

Please let me know if you find any bugs or make any improvements.
