.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
lcdscrub \- attempt to repair burn-in on LCD screens
.SH SYNOPSIS
.B lcdscrub
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-spread \fInumber\fP]
[\-cycles \fInumber\fP]
[\-fps]
.SH DESCRIPTION
This screen saver is not meant to look pretty, but rather, to
repair burn-in on LCD monitors.

Believe it or not, screen burn is not a thing of the past.
It can happen to LCD screens pretty easily, even in this modern age.
However, leaving the screen on and displaying high contrast images
can often repair the damage.  That's what this screen saver does.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 1000000 (1 second.).
.TP 8
.B \-spread \fInumber\fP
Distance between lines.  Default 8.
.TP 8
.B \-cycles \fInumber\fP
Steps before switching display mode.  Default 60.
.TP 8
.B \-fps
Display the current frame rate and CPU load.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.br
https://support.apple.com/de-at/HT2387
.br
https://web.archive.org/web/20080207220955/http%3A//toastycode.com/blog/2008/02/05/lcd-scrub/
.SH COPYRIGHT
Copyright \(co 2008 by Jamie Zawinski.  Permission to use, copy, modify, 
distribute, and sell this software and its documentation for any purpose is 
hereby granted without fee, provided that the above copyright notice appear 
in all copies and that both that copyright notice and this permission notice
appear in supporting documentation.  No representations are made about the 
suitability of this software for any purpose.  It is provided "as is" without
express or implied warranty.
.SH AUTHOR
Inspired by the like-named program by Daniel Sandler.

Written by Jamie Zawinski.
