#!/usr/bin/perl
# $XTermId: 88colres.pl,v 1.16 2007/06/08 23:57:23 tom Exp $
# -----------------------------------------------------------------------------
# this file is part of xterm
#
# Copyright 1999-2005,2007 by Thomas E. Dickey
# Copyright 1999-2000 by Steve Wall
# 
#                         All Rights Reserved
# 
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, merge, publish,
# distribute, sublicense, and/or sell copies of the Software, and to
# permit persons to whom the Software is furnished to do so, subject to
# the following conditions:
# 
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
# OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE ABOVE LISTED COPYRIGHT HOLDER(S) BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# 
# Except as contained in this notice, the name(s) of the above copyright
# holders shall not be used in advertising or otherwise to promote the
# sale, use or other dealings in this Software without prior written
# authorization.
# -----------------------------------------------------------------------------
# Made from 256colres.pl

# Construct a header file defining default resources for the
# 88-color model of xterm.

# use the resources for colors 0-15 - usually more-or-less a
# reproduction of the standard ANSI colors, but possibly more
# pleasing shades

use strict;

our ( $line1, $line2, $line3 );
our ( $red, $green, $blue, $gray );
our ( $level, $code, @steps );

print <<EOF;
/*
 * This header file was generated by $0
 */
/* \$XTermId\$ */

#ifndef included_88colres_h
#define included_88colres_h

EOF

$line1="COLOR_RES(\"%d\",";
$line2="\tscreen.Acolors[%d],";
$line3="\tDFT_COLOR(\"rgb:%2.2x/%2.2x/%2.2x\")),\n";
@steps=(0,139,205,255);

# colors 16-79 are a 4x4x4 color cube
for ($red = 0; $red < 4; $red++) {
    for ($green = 0; $green < 4; $green++) {
	for ($blue = 0; $blue < 4; $blue++) {
	    $code = 16 + ($red * 16) + ($green * 4) + $blue;
	    printf($line1, $code);
	    printf($line2, $code);
	    printf($line3,
		   int (@steps[$red]),
		   int (@steps[$green]),
		   int (@steps[$blue]));
	}
    }
}

# colors 80-87 are a grayscale ramp, intentionally leaving out
# black and white
for ($gray = 0; $gray < 8; $gray++) {
    $level = ($gray * 23.18181818) + 46.36363636;
    if( $gray > 0 ) { $level += 23.18181818; }
    $code = 80 + $gray;
    printf($line1, $code);
    printf($line2, $code);
    printf($line3,
	   int($level), int($level), int($level));
}

print <<EOF;

#endif /* included_88colres_h */
EOF
