/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkCmdExecutor;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.util.stats.TimerContext;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedQueue {
    private static final Logger LOG = LoggerFactory.getLogger(DistributedQueue.class);
    private static long DEFAULT_TIMEOUT = 300000L;
    private final String dir;
    private SolrZkClient zookeeper;
    private List<ACL> acl = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private final String prefix = "qn-";
    private final String response_prefix = "qnr-";
    private final Overseer.Stats stats;

    public DistributedQueue(SolrZkClient zookeeper, String dir, List<ACL> acl) {
        this(zookeeper, dir, acl, new Overseer.Stats());
    }

    public DistributedQueue(SolrZkClient zookeeper, String dir, List<ACL> acl, Overseer.Stats stats) {
        this.dir = dir;
        ZkCmdExecutor cmdExecutor = new ZkCmdExecutor(zookeeper.getZkClientTimeout());
        try {
            cmdExecutor.ensureExists(dir, zookeeper);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        if (acl != null) {
            this.acl = acl;
        }
        this.zookeeper = zookeeper;
        this.stats = stats;
    }

    private TreeMap<Long, String> orderedChildren(Watcher watcher) throws KeeperException, InterruptedException {
        TreeMap<Long, String> orderedChildren = new TreeMap<Long, String>();
        List childNames = null;
        childNames = this.zookeeper.getChildren(this.dir, watcher, true);
        for (String childName : childNames) {
            try {
                if (!childName.regionMatches(0, "qn-", 0, "qn-".length())) {
                    LOG.debug("Found child node with improper name: " + childName);
                    continue;
                }
                String suffix = childName.substring("qn-".length());
                Long childId = new Long(suffix);
                orderedChildren.put(childId, childName);
            }
            catch (NumberFormatException e) {
                LOG.warn("Found child node with improper format : " + childName + " " + e, (Throwable)e);
            }
        }
        return orderedChildren;
    }

    public boolean containsTaskWithRequestId(String requestId) throws KeeperException, InterruptedException {
        List childNames = null;
        childNames = this.zookeeper.getChildren(this.dir, null, true);
        for (String childName : childNames) {
            if (childName == null) continue;
            try {
                ZkNodeProps message = ZkNodeProps.load((byte[])this.zookeeper.getData(this.dir + "/" + childName, null, null, true));
                if (!message.containsKey("async")) continue;
                LOG.info(">>>> {}", message.get("async"));
                if (!message.get("async").equals(requestId)) continue;
                return true;
            }
            catch (KeeperException.NoNodeException e) {
            }
        }
        return false;
    }

    private QueueEvent element() throws KeeperException, InterruptedException {
        block4: while (true) {
            TreeMap<Long, String> orderedChildren;
            try {
                orderedChildren = this.orderedChildren(null);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            if (orderedChildren.size() == 0) {
                return null;
            }
            Iterator<String> i$ = orderedChildren.values().iterator();
            while (true) {
                if (!i$.hasNext()) continue block4;
                String headNode = i$.next();
                if (headNode == null) continue;
                try {
                    return new QueueEvent(this.dir + "/" + headNode, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                }
                catch (KeeperException.NoNodeException e) {
                    continue;
                }
                break;
            }
            break;
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] remove() throws NoSuchElementException, KeeperException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] remove(QueueEvent event) throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_remove_event");
        try {
            String path = event.getId();
            String responsePath = this.dir + "/" + "qnr-" + path.substring(path.lastIndexOf("-") + 1);
            if (this.zookeeper.exists(responsePath, true).booleanValue()) {
                this.zookeeper.setData(responsePath, event.getBytes(), true);
            }
            byte[] data = this.zookeeper.getData(path, null, null, true);
            this.zookeeper.delete(path, -1, true);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] take() throws KeeperException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[DOLOOP]], but top level block is 5[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(byte[] data) throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_offer");
        try {
            boolean bl = this.createData(this.dir + "/" + "qn-", data, CreateMode.PERSISTENT_SEQUENTIAL) != null;
            return bl;
        }
        finally {
            time.stop();
        }
    }

    private String createData(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.create(path, data, this.acl, mode, true);
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException ne) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueEvent offer(byte[] data, long timeout) throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_offer");
        try {
            String path = this.createData(this.dir + "/" + "qn-", data, CreateMode.PERSISTENT_SEQUENTIAL);
            String watchID = this.createData(this.dir + "/" + "qnr-" + path.substring(path.lastIndexOf("-") + 1), null, CreateMode.EPHEMERAL);
            Object lock = new Object();
            LatchChildWatcher watcher = new LatchChildWatcher(lock);
            Object object = lock;
            synchronized (object) {
                if (this.zookeeper.exists(watchID, (Watcher)watcher, true) != null) {
                    watcher.await(timeout);
                }
            }
            byte[] bytes = this.zookeeper.getData(watchID, null, null, true);
            this.zookeeper.delete(watchID, -1, true);
            QueueEvent queueEvent = new QueueEvent(watchID, bytes, watcher.getWatchedEvent());
            return queueEvent;
        }
        finally {
            time.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] peek() throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_peek");
        try {
            QueueEvent element = this.element();
            if (element == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = element.getBytes();
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    public List<QueueEvent> peekTopN(int n, Set<String> excludeSet, Long wait) throws KeeperException, InterruptedException {
        ArrayList<QueueEvent> topN = new ArrayList<QueueEvent>();
        LOG.debug("Peeking for top {} elements. ExcludeSet: " + excludeSet.toString());
        boolean waitedEnough = false;
        TimerContext time = null;
        time = wait == Long.MAX_VALUE ? this.stats.time(this.dir + "_peekTopN_wait_forever") : this.stats.time(this.dir + "_peekTopN_wait" + wait);
        try {
            while (true) {
                ArrayList<QueueEvent> arrayList;
                TreeMap<Long, String> orderedChildren;
                LatchChildWatcher childWatcher = new LatchChildWatcher();
                try {
                    orderedChildren = this.orderedChildren(childWatcher);
                }
                catch (KeeperException.NoNodeException e) {
                    this.zookeeper.create(this.dir, new byte[0], this.acl, CreateMode.PERSISTENT, true);
                    continue;
                }
                if (orderedChildren.size() == 0) {
                    if (waitedEnough) {
                        List<QueueEvent> e = null;
                        return e;
                    }
                    childWatcher.await(wait == Long.MAX_VALUE ? DEFAULT_TIMEOUT : wait);
                    waitedEnough = wait != Long.MAX_VALUE;
                    continue;
                }
                for (String headNode : orderedChildren.values()) {
                    if (headNode != null && topN.size() < n) {
                        try {
                            String id = this.dir + "/" + headNode;
                            if (excludeSet != null && excludeSet.contains(id)) continue;
                            QueueEvent queueEvent = new QueueEvent(id, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                            topN.add(queueEvent);
                        }
                        catch (KeeperException.NoNodeException e) {}
                        continue;
                    }
                    if (topN.size() < 1) continue;
                    this.printQueueEventsListElementIds(topN);
                    ArrayList<QueueEvent> arrayList2 = topN;
                    return arrayList2;
                }
                if (topN.size() > 0) {
                    this.printQueueEventsListElementIds(topN);
                    arrayList = topN;
                    return arrayList;
                }
                if (waitedEnough) {
                    LOG.debug("Waited enough, returning null after peekTopN");
                    arrayList = null;
                    return arrayList;
                }
                childWatcher.await(wait == Long.MAX_VALUE ? DEFAULT_TIMEOUT : wait);
                waitedEnough = wait != Long.MAX_VALUE;
            }
        }
        finally {
            time.stop();
        }
    }

    private void printQueueEventsListElementIds(ArrayList<QueueEvent> topN) {
        if (LOG.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer("[");
            for (QueueEvent queueEvent : topN) {
                sb.append(queueEvent.getId()).append(", ");
            }
            sb.append("]");
            LOG.debug("Returning topN elements: {}", (Object)sb.toString());
        }
    }

    public String getTailId() throws KeeperException, InterruptedException {
        TreeMap<Long, String> orderedChildren = null;
        orderedChildren = this.orderedChildren(null);
        if (orderedChildren == null || orderedChildren.isEmpty()) {
            return null;
        }
        for (String headNode : orderedChildren.descendingMap().values()) {
            if (headNode == null) continue;
            try {
                QueueEvent queueEvent = new QueueEvent(this.dir + "/" + headNode, this.zookeeper.getData(this.dir + "/" + headNode, null, null, true), null);
                return queueEvent.getId();
            }
            catch (KeeperException.NoNodeException e) {
            }
        }
        return null;
    }

    public QueueEvent peek(boolean block) throws KeeperException, InterruptedException {
        return this.peek(block ? Long.MAX_VALUE : 0L);
    }

    /*
     * Exception decompiling
     */
    public QueueEvent peek(long wait) throws KeeperException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[UNCONDITIONALDOLOOP]], but top level block is 7[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] poll() throws KeeperException, InterruptedException {
        TimerContext time = this.stats.time(this.dir + "_poll");
        try {
            byte[] byArray = this.remove();
            return byArray;
        }
        catch (NoSuchElementException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            time.stop();
        }
    }

    public Overseer.Stats getStats() {
        return this.stats;
    }

    public static class QueueEvent {
        private WatchedEvent event = null;
        private String id;
        private byte[] bytes;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            QueueEvent other = (QueueEvent)obj;
            return !(this.id == null ? other.id != null : !this.id.equals(other.id));
        }

        QueueEvent(String id, byte[] bytes, WatchedEvent event) {
            this.id = id;
            this.bytes = bytes;
            this.event = event;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }

    private class LatchChildWatcher
    implements Watcher {
        Object lock = new Object();
        private WatchedEvent event = null;

        public LatchChildWatcher() {
        }

        public LatchChildWatcher(Object lock) {
            this.lock = lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            LOG.info("LatchChildWatcher fired on path: " + event.getPath() + " state: " + event.getState() + " type " + event.getType());
            Object object = this.lock;
            synchronized (object) {
                this.event = event;
                this.lock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void await(long timeout) throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(timeout);
            }
        }

        public WatchedEvent getWatchedEvent() {
            return this.event;
        }
    }
}

