/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.util.DOMUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginInfo {
    public final String name;
    public final String className;
    public final String type;
    public final NamedList initArgs;
    public final Map<String, String> attributes;
    public final List<PluginInfo> children;
    public static final PluginInfo EMPTY_INFO = new PluginInfo("", Collections.emptyMap(), new NamedList(), Collections.emptyList());
    private static final HashSet<String> NL_TAGS = new HashSet<String>(Arrays.asList("lst", "arr", "bool", "str", "int", "long", "float", "double"));

    public PluginInfo(String type, Map<String, String> attrs, NamedList initArgs, List<PluginInfo> children) {
        this.type = type;
        this.name = attrs.get("name");
        this.className = attrs.get("class");
        this.initArgs = initArgs;
        this.attributes = Collections.unmodifiableMap(attrs);
        this.children = children == null ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public PluginInfo(Node node, String err, boolean requireName, boolean requireClass) {
        this.type = node.getNodeName();
        this.name = DOMUtil.getAttr(node, "name", requireName ? err : null);
        this.className = DOMUtil.getAttr(node, "class", requireClass ? err : null);
        this.initArgs = DOMUtil.childNodesToNamedList(node);
        this.attributes = Collections.unmodifiableMap(DOMUtil.toMap(node.getAttributes()));
        this.children = this.loadSubPlugins(node);
    }

    private List<PluginInfo> loadSubPlugins(Node node) {
        ArrayList<PluginInfo> children = new ArrayList<PluginInfo>();
        NodeList nlst = node.getChildNodes();
        for (int i = 0; i < nlst.getLength(); ++i) {
            PluginInfo pluginInfo;
            Node nd = nlst.item(i);
            if (nd.getNodeType() != 1 || NL_TAGS.contains(nd.getNodeName()) || !(pluginInfo = new PluginInfo(nd, null, false, false)).isEnabled()) continue;
            children.add(pluginInfo);
        }
        return children.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(children);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.type != null) {
            sb.append("type = " + this.type + ",");
        }
        if (this.name != null) {
            sb.append("name = " + this.name + ",");
        }
        if (this.className != null) {
            sb.append("class = " + this.className + ",");
        }
        if (this.initArgs != null && this.initArgs.size() > 0) {
            sb.append("args = " + this.initArgs);
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean isEnabled() {
        String enable = this.attributes.get("enable");
        return enable == null || Boolean.parseBoolean(enable);
    }

    public boolean isDefault() {
        return Boolean.parseBoolean(this.attributes.get("default"));
    }

    public PluginInfo getChild(String type) {
        List<PluginInfo> l = this.getChildren(type);
        return l.isEmpty() ? null : l.get(0);
    }

    public List<PluginInfo> getChildren(String type) {
        if (this.children.isEmpty()) {
            return this.children;
        }
        ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        for (PluginInfo child : this.children) {
            if (!type.equals(child.type)) continue;
            result.add(child);
        }
        return result;
    }
}

