/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.lucene49.Lucene49Codec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.CodecFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.plugin.SolrCoreAware;

public class SchemaCodecFactory
extends CodecFactory
implements SolrCoreAware {
    private Codec codec;
    private volatile SolrCore core;

    @Override
    public void inform(SolrCore core) {
        this.core = core;
    }

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.codec = new Lucene49Codec(){

            public PostingsFormat getPostingsFormatForField(String field) {
                String postingsFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (postingsFormatName = schemaField.getType().getPostingsFormat()) != null) {
                    return PostingsFormat.forName((String)postingsFormatName);
                }
                return super.getPostingsFormatForField(field);
            }

            public DocValuesFormat getDocValuesFormatForField(String field) {
                String docValuesFormatName;
                SchemaField schemaField = SchemaCodecFactory.this.core.getLatestSchema().getFieldOrNull(field);
                if (schemaField != null && (docValuesFormatName = schemaField.getType().getDocValuesFormat()) != null) {
                    return DocValuesFormat.forName((String)docValuesFormatName);
                }
                return super.getDocValuesFormatForField(field);
            }
        };
    }

    @Override
    public Codec getCodec() {
        assert (this.core != null) : "inform must be called first";
        return this.codec;
    }
}

