/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.SolrSuggester;
import org.apache.solr.spelling.suggest.SuggesterOptions;
import org.apache.solr.spelling.suggest.SuggesterParams;
import org.apache.solr.spelling.suggest.SuggesterResult;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestComponent
extends SearchComponent
implements SolrCoreAware,
SuggesterParams,
Accountable {
    private static final Logger LOG = LoggerFactory.getLogger(SuggestComponent.class);
    public static final String COMPONENT_NAME = "suggest";
    private static final String DEFAULT_DICT_NAME = "default";
    private static final String CONFIG_PARAM_LABEL = "suggester";
    private static final String BUILD_ON_COMMIT_LABEL = "buildOnCommit";
    private static final String BUILD_ON_OPTIMIZE_LABEL = "buildOnOptimize";
    protected NamedList initParams;
    protected Map<String, SolrSuggester> suggesters = new ConcurrentHashMap<String, SolrSuggester>();

    @Override
    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    @Override
    public void inform(SolrCore core) {
        if (this.initParams != null) {
            LOG.info("Initializing SuggestComponent");
            boolean hasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                if (!this.initParams.getName(i).equals(CONFIG_PARAM_LABEL)) continue;
                SolrSuggester suggester = new SolrSuggester();
                NamedList suggesterParams = (NamedList)this.initParams.getVal(i);
                String dictionary = suggester.init(suggesterParams, core);
                if (dictionary != null) {
                    boolean isDefault = dictionary.equals(DEFAULT_DICT_NAME);
                    if (isDefault && !hasDefault) {
                        hasDefault = true;
                    } else if (isDefault) {
                        throw new RuntimeException("More than one dictionary is missing name.");
                    }
                    this.suggesters.put(dictionary, suggester);
                } else if (!hasDefault) {
                    this.suggesters.put(DEFAULT_DICT_NAME, suggester);
                    hasDefault = true;
                } else {
                    throw new RuntimeException("More than one dictionary is missing name.");
                }
                core.registerFirstSearcherListener(new SuggesterListener(core, suggester, false, false));
                boolean buildOnCommit = Boolean.parseBoolean((String)suggesterParams.get(BUILD_ON_COMMIT_LABEL));
                boolean buildOnOptimize = Boolean.parseBoolean((String)suggesterParams.get(BUILD_ON_OPTIMIZE_LABEL));
                if (!buildOnCommit && !buildOnOptimize) continue;
                LOG.info("Registering newSearcher listener for suggester: " + suggester.getName());
                core.registerNewSearcherListener(new SuggesterListener(core, suggester, buildOnCommit, buildOnOptimize));
            }
        }
    }

    @Override
    public void prepare(ResponseBuilder rb) throws IOException {
        SolrParams params = rb.req.getParams();
        LOG.info("SuggestComponent prepare with : " + params);
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        boolean buildAll = params.getBool("suggest.buildAll", false);
        boolean reloadAll = params.getBool("suggest.reloadAll", false);
        Collection<SolrSuggester> querysuggesters = buildAll || reloadAll ? this.suggesters.values() : this.getSuggesters(params);
        if (params.getBool("suggest.build", false) || buildAll) {
            for (SolrSuggester suggester : querysuggesters) {
                suggester.build(rb.req.getCore(), rb.req.getSearcher());
            }
            rb.rsp.add("command", !buildAll ? "build" : "buildAll");
        } else if (params.getBool("suggest.reload", false) || reloadAll) {
            for (SolrSuggester suggester : querysuggesters) {
                suggester.reload(rb.req.getCore(), rb.req.getSearcher());
            }
            rb.rsp.add("command", !reloadAll ? "reload" : "reloadAll");
        }
    }

    @Override
    public int distributedProcess(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        LOG.info("SuggestComponent distributedProcess with : " + params);
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 4;
            sreq.params = new ModifiableSolrParams(rb.req.getParams());
            sreq.params.remove("shards");
            rb.addRequest(this, sreq);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    @Override
    public void process(ResponseBuilder rb) throws IOException {
        Set<SolrSuggester> querySuggesters;
        SolrParams params = rb.req.getParams();
        LOG.info("SuggestComponent process with : " + params);
        if (!params.getBool(COMPONENT_NAME, false) || this.suggesters.isEmpty()) {
            return;
        }
        boolean buildAll = params.getBool("suggest.buildAll", false);
        boolean reloadAll = params.getBool("suggest.reloadAll", false);
        try {
            querySuggesters = this.getSuggesters(params);
        }
        catch (IllegalArgumentException ex) {
            if (!buildAll && !reloadAll) {
                throw ex;
            }
            querySuggesters = new HashSet<SolrSuggester>();
        }
        String query = params.get("suggest.q");
        if (query == null && (query = rb.getQueryString()) == null) {
            query = params.get("q");
        }
        if (query != null) {
            int count = params.getInt("suggest.count", 1);
            SuggesterOptions options = new SuggesterOptions(new CharsRef(query), count);
            HashMap<String, SimpleOrderedMap<NamedList<Object>>> namedListResults = new HashMap<String, SimpleOrderedMap<NamedList<Object>>>();
            for (SolrSuggester suggester : querySuggesters) {
                SuggesterResult suggesterResult = suggester.getSuggestions(options);
                this.toNamedList(suggesterResult, namedListResults);
            }
            rb.rsp.add(COMPONENT_NAME, namedListResults);
        }
    }

    @Override
    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        LOG.info("SuggestComponent finishStage with : " + params);
        if (!params.getBool(COMPONENT_NAME, false) || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        int count = params.getInt("suggest.count", 1);
        ArrayList<SuggesterResult> suggesterResults = new ArrayList<SuggesterResult>();
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                NamedList resp = srsp.getSolrResponse().getResponse();
                if (resp == null) continue;
                Map namedList = (Map)resp.get(COMPONENT_NAME);
                LOG.info(srsp.getShard() + " : " + namedList);
                suggesterResults.add(this.toSuggesterResult(namedList));
            }
        }
        SuggesterResult suggesterResult = SuggestComponent.merge(suggesterResults, count);
        HashMap<String, SimpleOrderedMap<NamedList<Object>>> namedListResults = new HashMap<String, SimpleOrderedMap<NamedList<Object>>>();
        this.toNamedList(suggesterResult, namedListResults);
        rb.rsp.add(COMPONENT_NAME, namedListResults);
    }

    private static SuggesterResult merge(List<SuggesterResult> suggesterResults, int count) {
        SuggesterResult result = new SuggesterResult();
        HashSet<String> allTokens = new HashSet<String>();
        HashSet<String> suggesterNames = new HashSet<String>();
        for (SuggesterResult shardResult : suggesterResults) {
            for (String suggesterName : shardResult.getSuggesterNames()) {
                allTokens.addAll(shardResult.getTokens(suggesterName));
                suggesterNames.add(suggesterName);
            }
        }
        for (String suggesterName : suggesterNames) {
            for (String token : allTokens) {
                Lookup.LookupPriorityQueue resultQueue = new Lookup.LookupPriorityQueue(count);
                for (SuggesterResult shardResult : suggesterResults) {
                    List<Lookup.LookupResult> suggests = shardResult.getLookupResult(suggesterName, token);
                    if (suggests == null) continue;
                    for (Lookup.LookupResult res : suggests) {
                        resultQueue.insertWithOverflow((Object)res);
                    }
                }
                LinkedList<Lookup.LookupResult> sortedSuggests = new LinkedList<Lookup.LookupResult>();
                Collections.addAll(sortedSuggests, resultQueue.getResults());
                result.add(suggesterName, token, sortedSuggests);
            }
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "Suggester component";
    }

    @Override
    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_9/solr/core/src/java/org/apache/solr/handler/component/SuggestComponent.java $";
    }

    @Override
    public NamedList getStatistics() {
        SimpleOrderedMap stats = new SimpleOrderedMap();
        stats.add("totalSizeInBytes", (Object)String.valueOf(this.ramBytesUsed()));
        for (Map.Entry<String, SolrSuggester> entry : this.suggesters.entrySet()) {
            SolrSuggester suggester = entry.getValue();
            stats.add(entry.getKey(), (Object)suggester.toString());
        }
        return stats;
    }

    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        for (SolrSuggester suggester : this.suggesters.values()) {
            sizeInBytes += suggester.ramBytesUsed();
        }
        return sizeInBytes;
    }

    private Set<SolrSuggester> getSuggesters(SolrParams params) {
        HashSet<SolrSuggester> solrSuggesters = new HashSet<SolrSuggester>();
        for (String suggesterName : this.getSuggesterNames(params)) {
            SolrSuggester curSuggester = this.suggesters.get(suggesterName);
            if (curSuggester != null) {
                solrSuggesters.add(curSuggester);
                continue;
            }
            throw new IllegalArgumentException("No suggester named " + suggesterName + " was configured");
        }
        if (solrSuggesters.size() == 0) {
            throw new IllegalArgumentException("No default suggester was configured");
        }
        return solrSuggesters;
    }

    private Set<String> getSuggesterNames(SolrParams params) {
        HashSet<String> suggesterNames = new HashSet<String>();
        String[] suggesterNamesFromParams = params.getParams("suggest.dictionary");
        if (suggesterNamesFromParams == null) {
            suggesterNames.add(DEFAULT_DICT_NAME);
        } else {
            for (String name : suggesterNamesFromParams) {
                suggesterNames.add(name);
            }
        }
        return suggesterNames;
    }

    private void toNamedList(SuggesterResult suggesterResult, Map<String, SimpleOrderedMap<NamedList<Object>>> resultObj) {
        for (String suggesterName : suggesterResult.getSuggesterNames()) {
            SimpleOrderedMap results = new SimpleOrderedMap();
            for (String token : suggesterResult.getTokens(suggesterName)) {
                SimpleOrderedMap suggestionBody = new SimpleOrderedMap();
                List<Lookup.LookupResult> lookupResults = suggesterResult.getLookupResult(suggesterName, token);
                suggestionBody.add("numFound", (Object)lookupResults.size());
                ArrayList<SimpleOrderedMap> suggestEntriesNamedList = new ArrayList<SimpleOrderedMap>();
                for (Lookup.LookupResult lookupResult : lookupResults) {
                    String suggestionString = lookupResult.key.toString();
                    long weight = lookupResult.value;
                    String payload = lookupResult.payload != null ? lookupResult.payload.utf8ToString() : "";
                    SimpleOrderedMap suggestEntryNamedList = new SimpleOrderedMap();
                    suggestEntryNamedList.add("term", (Object)suggestionString);
                    suggestEntryNamedList.add("weight", (Object)weight);
                    suggestEntryNamedList.add("payload", (Object)payload);
                    suggestEntriesNamedList.add(suggestEntryNamedList);
                }
                suggestionBody.add("suggestions", suggestEntriesNamedList);
                results.add(token, (Object)suggestionBody);
            }
            resultObj.put(suggesterName, (SimpleOrderedMap<NamedList<Object>>)results);
        }
    }

    private SuggesterResult toSuggesterResult(Map<String, SimpleOrderedMap<NamedList<Object>>> suggestionsMap) {
        SuggesterResult result = new SuggesterResult();
        if (suggestionsMap == null) {
            return result;
        }
        for (Map.Entry<String, SimpleOrderedMap<NamedList<Object>>> entry : suggestionsMap.entrySet()) {
            String suggesterName = entry.getKey();
            for (Map.Entry suggestions : entry.getValue()) {
                String tokenString = (String)suggestions.getKey();
                ArrayList<Lookup.LookupResult> lookupResults = new ArrayList<Lookup.LookupResult>();
                NamedList suggestion = (NamedList)suggestions.getValue();
                for (int j = 0; j < suggestion.size(); ++j) {
                    String property = suggestion.getName(j);
                    if (property.equals("suggestions")) {
                        List suggestionEntries = (List)suggestion.getVal(j);
                        for (NamedList suggestionEntry : suggestionEntries) {
                            String term = (String)suggestionEntry.get("term");
                            Long weight = (Long)suggestionEntry.get("weight");
                            String payload = (String)suggestionEntry.get("payload");
                            Lookup.LookupResult res = new Lookup.LookupResult((CharSequence)new CharsRef(term), weight.longValue(), new BytesRef((CharSequence)payload));
                            lookupResults.add(res);
                        }
                    }
                    result.add(suggesterName, tokenString, lookupResults);
                }
            }
        }
        return result;
    }

    private static class SuggesterListener
    implements SolrEventListener {
        private final SolrCore core;
        private final SolrSuggester suggester;
        private final boolean buildOnCommit;
        private final boolean buildOnOptimize;

        public SuggesterListener(SolrCore core, SolrSuggester checker, boolean buildOnCommit, boolean buildOnOptimize) {
            this.core = core;
            this.suggester = checker;
            this.buildOnCommit = buildOnCommit;
            this.buildOnOptimize = buildOnOptimize;
        }

        @Override
        public void init(NamedList args) {
        }

        @Override
        public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            if (currentSearcher == null) {
                try {
                    LOG.info("Loading suggester index for: " + this.suggester.getName());
                    this.suggester.reload(this.core, newSearcher);
                }
                catch (IOException e) {
                    log.error("Exception in reloading suggester index for: " + this.suggester.getName(), (Throwable)e);
                }
            } else if (this.buildOnCommit) {
                this.buildSuggesterIndex(newSearcher);
            } else if (this.buildOnOptimize) {
                if (newSearcher.getIndexReader().leaves().size() == 1) {
                    this.buildSuggesterIndex(newSearcher);
                } else {
                    LOG.info("Index is not optimized therefore skipping building suggester index for: " + this.suggester.getName());
                }
            }
        }

        private void buildSuggesterIndex(SolrIndexSearcher newSearcher) {
            try {
                LOG.info("Building suggester index for: " + this.suggester.getName());
                this.suggester.build(this.core, newSearcher);
            }
            catch (Exception e) {
                log.error("Exception in building suggester index for: " + this.suggester.getName(), (Throwable)e);
            }
        }

        @Override
        public void postCommit() {
        }

        @Override
        public void postSoftCommit() {
        }
    }

    private static class SuggesterResultLabels {
        static final String SUGGEST = "suggest";
        static final String SUGGESTIONS = "suggestions";
        static final String SUGGESTION_NUM_FOUND = "numFound";
        static final String SUGGESTION_TERM = "term";
        static final String SUGGESTION_WEIGHT = "weight";
        static final String SUGGESTION_PAYLOAD = "payload";

        private SuggesterResultLabels() {
        }
    }
}

