/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.complexPhrase.ComplexPhraseQueryParser;
import org.apache.lucene.search.Query;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.parser.QueryParser;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.search.SyntaxError;

class ComplexPhraseQParser
extends QParser {
    ComplexPhraseQueryParser lparser;
    boolean inOrder = true;

    public void setInOrder(boolean inOrder) {
        this.inOrder = inOrder;
    }

    public ComplexPhraseQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws SyntaxError {
        String qstr = this.getString();
        String defaultField = this.getParam("df");
        if (defaultField == null) {
            defaultField = this.getReq().getSchema().getDefaultSearchFieldName();
        }
        this.lparser = new ComplexPhraseQueryParser(this.getReq().getCore().getSolrConfig().luceneMatchVersion, defaultField, this.getReq().getSchema().getQueryAnalyzer());
        if (this.localParams != null) {
            this.inOrder = this.localParams.getBool("inOrder", this.inOrder);
        }
        this.lparser.setInOrder(this.inOrder);
        QueryParser.Operator defaultOperator = QueryParsing.getQueryParserDefaultOperator(this.getReq().getSchema(), this.getParam("q.op"));
        if (QueryParser.Operator.AND.equals((Object)defaultOperator)) {
            this.lparser.setDefaultOperator(QueryParser.Operator.AND);
        } else {
            this.lparser.setDefaultOperator(QueryParser.Operator.OR);
        }
        try {
            return this.lparser.parse(qstr);
        }
        catch (ParseException pe) {
            throw new SyntaxError(pe);
        }
    }

    @Override
    public String[] getDefaultHighlightFields() {
        String[] stringArray;
        if (this.lparser == null) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.lparser.getField();
        }
        return stringArray;
    }
}

