/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.flac.metadatablock.BlockType;

public class MetadataBlockHeader {
    public static final int BLOCK_TYPE_LENGTH = 1;
    public static final int BLOCK_LENGTH = 3;
    public static final int HEADER_LENGTH = 4;
    private boolean isLastBlock;
    private int dataLength;
    private byte[] bytes;
    private BlockType blockType;

    public static MetadataBlockHeader readHeader(RandomAccessFile raf) throws IOException {
        ByteBuffer rawdata = ByteBuffer.allocate(4);
        int bytesRead = raf.getChannel().read(rawdata);
        if (bytesRead < 4) {
            throw new IOException("Unable to read required number of databytes read:" + bytesRead + ":required:" + 4);
        }
        rawdata.rewind();
        return new MetadataBlockHeader(rawdata);
    }

    public String toString() {
        return "BlockType:" + (Object)((Object)this.blockType) + " DataLength:" + this.dataLength + " isLastBlock:" + this.isLastBlock;
    }

    public MetadataBlockHeader(ByteBuffer rawdata) {
        this.isLastBlock = (rawdata.get(0) & 0x80) >>> 7 == 1;
        int type = rawdata.get(0) & 0x7F;
        if (type < BlockType.values().length) {
            this.blockType = BlockType.values()[type];
        }
        this.dataLength = (this.u(rawdata.get(1)) << 16) + (this.u(rawdata.get(2)) << 8) + this.u(rawdata.get(3));
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.bytes[i] = rawdata.get(i);
        }
    }

    public MetadataBlockHeader(boolean isLastBlock, BlockType blockType, int dataLength) {
        ByteBuffer rawdata = ByteBuffer.allocate(4);
        this.blockType = blockType;
        this.isLastBlock = isLastBlock;
        this.dataLength = dataLength;
        byte type = isLastBlock ? (byte)(0x80 | blockType.getId()) : (byte)blockType.getId();
        rawdata.put(type);
        rawdata.put((byte)((dataLength & 0xFF0000) >>> 16));
        rawdata.put((byte)((dataLength & 0xFF00) >>> 8));
        rawdata.put((byte)(dataLength & 0xFF));
        this.bytes = new byte[4];
        for (int i = 0; i < 4; ++i) {
            this.bytes[i] = rawdata.get(i);
        }
    }

    private int u(int i) {
        return i & 0xFF;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public BlockType getBlockType() {
        return this.blockType;
    }

    public boolean isLastBlock() {
        return this.isLastBlock;
    }

    public byte[] getBytesWithoutIsLastBlockFlag() {
        this.bytes[0] = (byte)(this.bytes[0] & 0x7F);
        return this.bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

