/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.exceptions.ReadOnlyFileException;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagException;

public abstract class AudioFileReader {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic");
    private static final int MINIMUM_SIZE_FOR_VALID_AUDIO_FILE = 150;

    protected abstract GenericAudioHeader getEncodingInfo(RandomAccessFile var1) throws CannotReadException, IOException;

    protected abstract Tag getTag(RandomAccessFile var1) throws CannotReadException, IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AudioFile read(File f) throws CannotReadException, IOException, TagException, ReadOnlyFileException, InvalidAudioFrameException {
        AudioFile audioFile;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config(ErrorMessage.GENERAL_READ.getMsg(f.getAbsolutePath()));
        }
        if (!f.canRead()) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(f.getAbsolutePath()));
        }
        if (f.length() <= 150L) {
            throw new CannotReadException(ErrorMessage.GENERAL_READ_FAILED_FILE_TOO_SMALL.getMsg(f.getAbsolutePath()));
        }
        RandomAccessFile raf = null;
        try {
            try {
                raf = new RandomAccessFile(f, "r");
                raf.seek(0L);
                GenericAudioHeader info = this.getEncodingInfo(raf);
                raf.seek(0L);
                Tag tag = this.getTag(raf);
                audioFile = new AudioFile(f, (AudioHeader)info, tag);
                Object var7_8 = null;
            }
            catch (CannotReadException cre) {
                throw cre;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, ErrorMessage.GENERAL_READ.getMsg(f.getAbsolutePath()), e);
                throw new CannotReadException(f.getAbsolutePath() + ":" + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (raf == null) throw throwable;
                raf.close();
                throw throwable;
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ErrorMessage.GENERAL_READ_FAILED_UNABLE_TO_CLOSE_RANDOM_ACCESS_FILE.getMsg(f.getAbsolutePath()));
                throw throwable;
            }
        }
        try {}
        catch (Exception ex) {
            logger.log(Level.WARNING, ErrorMessage.GENERAL_READ_FAILED_UNABLE_TO_CLOSE_RANDOM_ACCESS_FILE.getMsg(f.getAbsolutePath()));
            return audioFile;
        }
        if (raf == null) return audioFile;
        raf.close();
        return audioFile;
    }
}

