/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp4.atom;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.Mp4AtomIdentifier;
import org.jaudiotagger.audio.mp4.atom.AbstractMp4Box;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.audio.mp4.atom.Mp4MvhdBox;

public class Mp4StcoBox
extends AbstractMp4Box {
    public static final int VERSION_FLAG_POS = 0;
    public static final int OTHER_FLAG_POS = 1;
    public static final int NO_OF_OFFSETS_POS = 4;
    public static final int VERSION_FLAG_LENGTH = 1;
    public static final int OTHER_FLAG_LENGTH = 3;
    public static final int NO_OF_OFFSETS_LENGTH = 4;
    public static final int OFFSET_LENGTH = 4;
    private int noOfOffSets = 0;
    private int firstOffSet;

    public Mp4StcoBox(Mp4BoxHeader header, ByteBuffer buffer) {
        this.header = header;
        this.dataBuffer = buffer.slice();
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3);
        this.noOfOffSets = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        this.firstOffSet = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
    }

    public void printTotalOffset() {
        int offset = 0;
        this.dataBuffer.rewind();
        this.dataBuffer.position(8);
        for (int i = 0; i < this.noOfOffSets - 1; ++i) {
            offset += Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            this.dataBuffer.position(this.dataBuffer.position() + 4);
        }
        System.out.println("Print Offset Total:" + (offset += Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1)));
    }

    public void printAlloffsets() {
        System.out.println("Print Offsets:start");
        this.dataBuffer.rewind();
        this.dataBuffer.position(8);
        for (int i = 0; i < this.noOfOffSets - 1; ++i) {
            int offset = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            System.out.println("offset into audio data is:" + offset);
            this.dataBuffer.position(this.dataBuffer.position() + 4);
        }
        int offset = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        System.out.println("offset into audio data is:" + offset);
        System.out.println("Print Offsets:end");
    }

    public void adjustOffsets(int adjustment) {
        this.dataBuffer.rewind();
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3 + 4);
        for (int i = 0; i < this.noOfOffSets; ++i) {
            int offset = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            this.dataBuffer.put(Utils.getSizeBEInt32(offset += adjustment));
        }
    }

    public Mp4StcoBox(Mp4BoxHeader header, ByteBuffer originalDataBuffer, int adjustment) {
        this.header = header;
        this.dataBuffer = originalDataBuffer.slice();
        this.dataBuffer.position(this.dataBuffer.position() + 1 + 3);
        this.noOfOffSets = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
        this.dataBuffer.position(this.dataBuffer.position() + 4);
        for (int i = 0; i < this.noOfOffSets; ++i) {
            int offset = Utils.getIntBE(this.dataBuffer, this.dataBuffer.position(), this.dataBuffer.position() + 4 - 1);
            this.dataBuffer.put(Utils.getSizeBEInt32(offset += adjustment));
        }
    }

    public int getNoOfOffSets() {
        return this.noOfOffSets;
    }

    public int getFirstOffSet() {
        return this.firstOffSet;
    }

    public static void debugShowStcoInfo(RandomAccessFile raf) throws IOException, CannotReadException {
        Mp4BoxHeader moovHeader = Mp4BoxHeader.seekWithinLevel(raf, Mp4AtomIdentifier.MOOV.getFieldName());
        if (moovHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        ByteBuffer moovBuffer = ByteBuffer.allocate(moovHeader.getLength() - 8);
        raf.getChannel().read(moovBuffer);
        moovBuffer.rewind();
        Mp4BoxHeader boxHeader = Mp4BoxHeader.seekWithinLevel(moovBuffer, Mp4AtomIdentifier.MVHD.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        ByteBuffer mvhdBuffer = moovBuffer.slice();
        Mp4MvhdBox mvhd = new Mp4MvhdBox(boxHeader, mvhdBuffer);
        mvhdBuffer.position(mvhdBuffer.position() + boxHeader.getDataLength());
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.TRAK.getFieldName());
        int endOfFirstTrackInBuffer = mvhdBuffer.position() + boxHeader.getDataLength();
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.MDIA.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.MDHD.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        mvhdBuffer.position(mvhdBuffer.position() + boxHeader.getDataLength());
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.MINF.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.SMHD.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        mvhdBuffer.position(mvhdBuffer.position() + boxHeader.getDataLength());
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.STBL.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        boxHeader = Mp4BoxHeader.seekWithinLevel(mvhdBuffer, Mp4AtomIdentifier.STCO.getFieldName());
        if (boxHeader == null) {
            throw new CannotReadException("This file does not appear to be an audio file");
        }
        Mp4StcoBox stco = new Mp4StcoBox(boxHeader, mvhdBuffer);
        stco.printAlloffsets();
    }
}

