/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.AbstractString;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public class PartOfSet
extends AbstractString {
    public PartOfSet(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
    }

    public PartOfSet(PartOfSet object) {
        super(object);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PartOfSet)) {
            return false;
        }
        PartOfSet that = (PartOfSet)obj;
        return EqualsUtil.areEqual(this.value, that.value);
    }

    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        logger.finest("Reading from array from offset:" + offset);
        String charSetName = this.getTextEncodingCharSet();
        CharsetDecoder decoder = Charset.forName(charSetName).newDecoder();
        ByteBuffer inBuffer = ByteBuffer.wrap(arr, offset, arr.length - offset).slice();
        CharBuffer outBuffer = CharBuffer.allocate(arr.length - offset);
        decoder.reset();
        CoderResult coderResult = decoder.decode(inBuffer, outBuffer, true);
        if (coderResult.isError()) {
            logger.warning("Decoding error:" + coderResult.toString());
        }
        decoder.flush(outBuffer);
        outBuffer.flip();
        String stringValue = outBuffer.toString();
        this.value = new PartOfSetValue(stringValue);
        this.setSize(arr.length - offset);
        logger.config("Read SizeTerminatedString:" + this.value + " size:" + this.size);
    }

    public byte[] writeByteArray() {
        byte[] data;
        String value = this.getValue().toString();
        try {
            String charSetName;
            if (TagOptionSingleton.getInstance().isRemoveTrailingTerminatorOnWrite() && value.length() > 0 && value.charAt(value.length() - 1) == '\u0000') {
                value = value.substring(0, value.length() - 1);
            }
            if ((charSetName = this.getTextEncodingCharSet()).equals("UTF-16")) {
                charSetName = "UTF-16LE";
                CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
                ByteBuffer bb = encoder.encode(CharBuffer.wrap('\ufeff' + value));
                data = new byte[bb.limit()];
                bb.get(data, 0, bb.limit());
            } else {
                CharsetEncoder encoder = Charset.forName(charSetName).newEncoder();
                ByteBuffer bb = encoder.encode(CharBuffer.wrap(value));
                data = new byte[bb.limit()];
                bb.get(data, 0, bb.limit());
            }
        }
        catch (CharacterCodingException ce) {
            logger.severe(ce.getMessage());
            throw new RuntimeException(ce);
        }
        this.setSize(data.length);
        return data;
    }

    protected String getTextEncodingCharSet() {
        byte textEncoding = this.getBody().getTextEncoding();
        String charSetName = TextEncoding.getInstanceOf().getValueForId(textEncoding);
        logger.finest("text encoding:" + textEncoding + " charset:" + charSetName);
        return charSetName;
    }

    public PartOfSetValue getValue() {
        return (PartOfSetValue)this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static class PartOfSetValue {
        private static final Pattern trackNoPatternWithTotalCount = Pattern.compile("([0-9]+)/([0-9]+)(.*)", 2);
        private static final Pattern trackNoPattern = Pattern.compile("([0-9]+)(.*)", 2);
        private static final String SEPARATOR = "/";
        private Integer count;
        private Integer total;
        private String extra;

        public PartOfSetValue() {
        }

        public PartOfSetValue(String value) {
            try {
                Matcher m = trackNoPatternWithTotalCount.matcher(value);
                if (m.matches()) {
                    this.extra = m.group(3);
                    this.count = Integer.parseInt(m.group(1));
                    this.total = Integer.parseInt(m.group(2));
                    return;
                }
                m = trackNoPattern.matcher(value);
                if (m.matches()) {
                    this.extra = m.group(2);
                    this.count = Integer.parseInt(m.group(1));
                }
            }
            catch (NumberFormatException nfe) {
                this.count = 0;
            }
        }

        public PartOfSetValue(Integer count, Integer total) {
            this.count = count;
            this.total = total;
        }

        public Integer getCount() {
            return this.count;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setCount(Integer count) {
            this.count = count;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public void setCount(String count) {
            try {
                this.count = Integer.parseInt(count);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public void setTotal(String total) {
            try {
                this.total = Integer.parseInt(total);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (!TagOptionSingleton.getInstance().isPadNumbers()) {
                if (this.count != null) {
                    sb.append(this.count);
                } else if (this.total != null) {
                    sb.append('0');
                }
                if (this.total != null) {
                    sb.append(SEPARATOR).append(this.total);
                }
                if (this.extra != null) {
                    sb.append(this.extra);
                }
            } else {
                if (this.count != null) {
                    if (this.count > 0 && this.count < 10) {
                        sb.append("0").append(this.count);
                    } else {
                        sb.append(this.count);
                    }
                } else if (this.total != null) {
                    sb.append('0');
                }
                if (this.total != null) {
                    if (this.total > 0 && this.total < 10) {
                        sb.append("/0").append(this.total);
                    } else {
                        sb.append(SEPARATOR).append(this.total);
                    }
                }
                if (this.extra != null) {
                    sb.append(this.extra);
                }
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PartOfSetValue)) {
                return false;
            }
            PartOfSetValue that = (PartOfSetValue)obj;
            return EqualsUtil.areEqual(this.getCount(), that.getCount()) && EqualsUtil.areEqual(this.getTotal(), that.getTotal());
        }
    }
}

