/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.io.PrintWriter;
import pt.tumba.parser.swf.SWFActionCodes;
import pt.tumba.parser.swf.SWFActions;

public class ActionTextWriter
implements SWFActions,
SWFActionCodes {
    protected PrintWriter printer;
    protected String indent = "";

    public ActionTextWriter(PrintWriter printer) {
        this.printer = printer;
    }

    protected void print(String mnemonic, String[] args) {
        this.printer.print(String.valueOf(this.indent) + "    ");
        this.writePaddedString(String.valueOf(mnemonic) + " ", 15);
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if (i > 0) {
                    this.printer.print(", ");
                }
                this.printer.print(args[i]);
                ++i;
            }
        }
        this.printer.println();
    }

    protected void writePaddedString(String s, int length) {
        int pad = length - s.length();
        this.printer.print(s);
        while (pad > 0) {
            this.printer.print(" ");
            --pad;
        }
    }

    public void start(int conditions) throws IOException {
        this.print("conditions", new String[]{Integer.toBinaryString(conditions)});
        this.printer.flush();
    }

    public void end() throws IOException {
        this.print("end", null);
        this.printer.println();
    }

    public void done() throws IOException {
        this.printer.flush();
    }

    public void blob(byte[] blob) throws IOException {
        this.print("(blob)", null);
        this.printer.println();
    }

    public void unknown(int code, byte[] data) throws IOException {
        this.print("unknown code =", new String[]{Integer.toString(code)});
    }

    public void initArray() throws IOException {
        this.print("initArray", null);
    }

    public void jumpLabel(String label) throws IOException {
        this.printer.println(String.valueOf(this.indent) + label + ":");
    }

    public void gotoFrame(int frameNumber) throws IOException {
        this.print("gotoFrame", new String[]{Integer.toString(frameNumber)});
    }

    public void gotoFrame(String label) throws IOException {
        this.print("gotoFrame", new String[]{"\"" + label + "\""});
    }

    public void getURL(String url, String target) throws IOException {
        this.print("getURL", new String[]{"\"" + url + "\"", "\"" + target + "\""});
    }

    public void nextFrame() throws IOException {
        this.print("nextFrame", null);
    }

    public void prevFrame() throws IOException {
        this.print("previousFrame", null);
    }

    public void play() throws IOException {
        this.print("play", null);
    }

    public void stop() throws IOException {
        this.print("stop", null);
    }

    public void toggleQuality() throws IOException {
        this.print("toggleQuality", null);
    }

    public void stopSounds() throws IOException {
        this.print("stopSounds", null);
    }

    public void setTarget(String target) throws IOException {
        this.print("setTarget", new String[]{"\"" + target + "\""});
    }

    public void jump(String jumpLabel) throws IOException {
        this.print("jump", new String[]{"\"" + jumpLabel + "\""});
    }

    public void ifJump(String jumpLabel) throws IOException {
        this.print("ifJump", new String[]{"\"" + jumpLabel + "\""});
    }

    public void waitForFrame(int frameNumber, String jumpLabel) throws IOException {
        this.print("waitForFrame", new String[]{Integer.toString(frameNumber), "\"" + jumpLabel + "\""});
    }

    public void waitForFrame(String jumpLabel) throws IOException {
        this.print("waitForFrame", new String[]{"\"" + jumpLabel + "\""});
    }

    public void pop() throws IOException {
        this.print("pop", null);
    }

    public void push(String value) throws IOException {
        this.print("push", new String[]{"\"" + value + "\""});
    }

    public void push(float value) throws IOException {
        this.print("push", new String[]{"float " + value});
    }

    public void push(double value) throws IOException {
        this.print("push", new String[]{"double " + value});
    }

    public void pushNull() throws IOException {
        this.print("push", new String[]{"null"});
    }

    public void pushRegister(int registerNumber) throws IOException {
        this.print("push", new String[]{"register( " + registerNumber + " )"});
    }

    public void push(boolean value) throws IOException {
        this.print("push", new String[]{value ? "true" : "false"});
    }

    public void push(int value) throws IOException {
        this.print("push", new String[]{"" + value});
    }

    public void lookup(int dictionaryIndex) throws IOException {
        this.print("push", new String[]{"lookup( " + dictionaryIndex + " )"});
    }

    public void add() throws IOException {
        this.print("add", null);
    }

    public void substract() throws IOException {
        this.print("substract", null);
    }

    public void multiply() throws IOException {
        this.print("multiply", null);
    }

    public void divide() throws IOException {
        this.print("divide", null);
    }

    public void equals() throws IOException {
        this.print("equals", null);
    }

    public void lessThan() throws IOException {
        this.print("lessThan", null);
    }

    public void and() throws IOException {
        this.print("and", null);
    }

    public void or() throws IOException {
        this.print("or", null);
    }

    public void not() throws IOException {
        this.print("not", null);
    }

    public void stringEquals() throws IOException {
        this.print("stringEquals", null);
    }

    public void stringLength() throws IOException {
        this.print("stringLength", null);
    }

    public void concat() throws IOException {
        this.print("concat", null);
    }

    public void substring() throws IOException {
        this.print("substring", null);
    }

    public void stringLessThan() throws IOException {
        this.print("stringLessThan", null);
    }

    public void stringLengthMB() throws IOException {
        this.print("stringLengthMB", null);
    }

    public void substringMB() throws IOException {
        this.print("substringMB", null);
    }

    public void toInteger() throws IOException {
        this.print("toInteger", null);
    }

    public void charToAscii() throws IOException {
        this.print("charToAscii", null);
    }

    public void asciiToChar() throws IOException {
        this.print("asciiToChar", null);
    }

    public void charMBToAscii() throws IOException {
        this.print("charMBToAscii", null);
    }

    public void asciiToCharMB() throws IOException {
        this.print("asciiToCharMB", null);
    }

    public void call() throws IOException {
        this.print("call", null);
    }

    public void getVariable() throws IOException {
        this.print("getVariable", null);
    }

    public void setVariable() throws IOException {
        this.print("setVariable", null);
    }

    public void getURL(int sendVars, int loadMode) throws IOException {
        String sendVars_ = null;
        switch (sendVars) {
            case 1: {
                sendVars_ = "send vars via GET";
                break;
            }
            case 2: {
                sendVars_ = "send vars via POST";
                break;
            }
            default: {
                sendVars_ = "no send";
            }
        }
        String mode = null;
        switch (loadMode) {
            case 0: {
                mode = "load movie into level";
                break;
            }
            case 1: {
                mode = "load movie into sprite";
                break;
            }
            case 3: {
                mode = "load vars into level";
                break;
            }
            case 4: {
                mode = "load vars into sprite";
                break;
            }
            default: {
                mode = "???";
            }
        }
        this.print("getURL", new String[]{sendVars_, mode});
    }

    public void gotoFrame(boolean play) throws IOException {
        this.print("gotoFrame", new String[]{play ? "and play" : "and stop"});
    }

    public void setTarget() throws IOException {
        this.print("setTarget", null);
    }

    public void getProperty() throws IOException {
        this.print("getProperty", null);
    }

    public void setProperty() throws IOException {
        this.print("setProperty", null);
    }

    public void cloneSprite() throws IOException {
        this.print("cloneSprite", null);
    }

    public void removeSprite() throws IOException {
        this.print("removeSprite", null);
    }

    public void startDrag() throws IOException {
        this.print("startDrag", null);
    }

    public void endDrag() throws IOException {
        this.print("endDrag", null);
    }

    public void trace() throws IOException {
        this.print("trace", null);
    }

    public void getTime() throws IOException {
        this.print("getTime", null);
    }

    public void randomNumber() throws IOException {
        this.print("randomNumber", null);
    }

    public void lookupTable(String[] values) throws IOException {
        this.print("lookupTable", null);
        int i = 0;
        while (i < values.length) {
            this.printer.print(String.valueOf(this.indent) + "        ");
            this.writePaddedString(String.valueOf(Integer.toString(i)) + ":", 5);
            this.printer.println("\"" + values[i] + "\"");
            ++i;
        }
    }

    public void callFunction() throws IOException {
        this.print("callFunction", null);
    }

    public void callMethod() throws IOException {
        this.print("callMethod", null);
    }

    public void startFunction(String name, String[] paramNames) throws IOException {
        String args = String.valueOf(name) + "(";
        if (paramNames != null) {
            int i = 0;
            while (i < paramNames.length) {
                if (i > 0) {
                    args = String.valueOf(args) + ",";
                }
                args = String.valueOf(args) + " " + paramNames[i];
                ++i;
            }
            if (paramNames.length > 0) {
                args = String.valueOf(args) + " ";
            }
        }
        args = String.valueOf(args) + ")";
        this.printer.println();
        this.print("defineFunction", new String[]{args});
        this.print("{", null);
        this.indent = String.valueOf(this.indent) + "    ";
    }

    public void endBlock() throws IOException {
        if (this.indent.length() <= 4) {
            this.indent = "";
        } else if (this.indent.length() >= 4) {
            this.indent = this.indent.substring(4);
        }
        this.print("}", null);
        this.printer.println();
    }

    public void comment(String comment) throws IOException {
        this.printer.println(String.valueOf(this.indent) + "    // " + comment);
    }

    public void defineLocalValue() throws IOException {
        this.print("defineLocalValue", null);
    }

    public void defineLocal() throws IOException {
        this.print("defineLocal", null);
    }

    public void deleteProperty() throws IOException {
        this.print("deleteProperty", null);
    }

    public void deleteThreadVars() throws IOException {
        this.print("deleteThreadVars", null);
    }

    public void enumerate() throws IOException {
        this.print("enumerate", null);
    }

    public void typedEquals() throws IOException {
        this.print("typedEquals", null);
    }

    public void getMember() throws IOException {
        this.print("getMember", null);
    }

    public void initObject() throws IOException {
        this.print("initObject", null);
    }

    public void newMethod() throws IOException {
        this.print("newMethod", null);
    }

    public void newObject() throws IOException {
        this.print("newObject", null);
    }

    public void setMember() throws IOException {
        this.print("setMember", null);
    }

    public void getTargetPath() throws IOException {
        this.print("getTargetPath", null);
    }

    public void startWith() throws IOException {
        this.printer.println();
        this.print("with", null);
        this.print("{", null);
        this.indent = String.valueOf(this.indent) + "    ";
    }

    public void duplicate() throws IOException {
        this.print("duplicate", null);
    }

    public void returnValue() throws IOException {
        this.print("return", null);
    }

    public void swap() throws IOException {
        this.print("swap", null);
    }

    public void storeInRegister(int registerNumber) throws IOException {
        this.print("register", new String[]{Integer.toString(registerNumber)});
    }

    public void convertToNumber() throws IOException {
        this.print("convertToNumber", null);
    }

    public void convertToString() throws IOException {
        this.print("convertToString", null);
    }

    public void typeOf() throws IOException {
        this.print("typeOf", null);
    }

    public void typedAdd() throws IOException {
        this.print("typedAdd", null);
    }

    public void typedLessThan() throws IOException {
        this.print("typedLessThan", null);
    }

    public void modulo() throws IOException {
        this.print("modulo", null);
    }

    public void bitAnd() throws IOException {
        this.print("bitAnd", null);
    }

    public void bitOr() throws IOException {
        this.print("bitOr", null);
    }

    public void bitXor() throws IOException {
        this.print("bitXor", null);
    }

    public void shiftLeft() throws IOException {
        this.print("shiftLeft", null);
    }

    public void shiftRight() throws IOException {
        this.print("shiftRight", null);
    }

    public void shiftRightUnsigned() throws IOException {
        this.print("shiftRightUnsigned", null);
    }

    public void decrement() throws IOException {
        this.print("decrement", null);
    }

    public void increment() throws IOException {
        this.print("increment", null);
    }
}

