/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import pt.tumba.parser.swf.OutStream;
import pt.tumba.parser.swf.SWFActionCodes;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.TagWriter;

public class ActionWriter
implements SWFActions,
SWFActionCodes {
    protected TagWriter tagWriter;
    protected OutStream out;
    protected ByteArrayOutputStream bout;
    protected int count;
    protected int flashVersion;
    protected List pushValues;
    protected Hashtable labels;
    protected List jumps;
    protected List skips;
    protected List blocks;
    protected Stack blockStack;

    public ActionWriter(TagWriter tagWriter, int flashVersion) {
        this.flashVersion = flashVersion;
        this.tagWriter = tagWriter;
    }

    protected int writeCode(int code) throws IOException {
        if (this.pushValues.size() > 0) {
            this.flushPushValues();
        }
        this.out.writeUI8(code);
        ++this.count;
        return this.count;
    }

    public void start(int conditions) throws IOException {
        this.count = 0;
        this.bout = new ByteArrayOutputStream();
        this.out = new OutStream(this.bout);
        this.pushValues = new Vector();
        this.labels = null;
        this.jumps = null;
        this.skips = null;
        this.blocks = null;
        this.blockStack = null;
    }

    public void end() throws IOException {
        this.writeCode(0);
        this.out.flush();
        byte[] bytes = this.bout.toByteArray();
        if (this.labels != null) {
            if (this.jumps != null) {
                this.fixupJumps(bytes);
            }
            if (this.skips != null) {
                this.fixupSkips(bytes);
            }
        }
        if (this.blocks != null) {
            this.fixupBlocks(bytes);
        }
        this.writeBytes(bytes);
    }

    public void blob(byte[] blob) throws IOException {
        this.writeBytes(blob);
    }

    protected void writeBytes(byte[] bytes) throws IOException {
        this.tagWriter.getOutStream().write(bytes);
    }

    public void done() throws IOException {
        this.tagWriter.completeTag();
    }

    protected void fixupBlocks(byte[] bytes2) {
        byte[] bytes = bytes2;
        Iterator iterator = this.blocks.iterator();
        while (iterator.hasNext()) {
            int[] info = (int[])iterator.next();
            int codeSize = info[1];
            int offset = info[0];
            byte[] sizeBytes = OutStream.sintTo2Bytes(codeSize);
            bytes[offset] = sizeBytes[0];
            bytes[offset + 1] = sizeBytes[1];
        }
    }

    protected void fixupJumps(byte[] bytes2) {
        byte[] bytes = bytes2;
        Iterator iterator = this.jumps.iterator();
        while (iterator.hasNext()) {
            Object[] obja = (Object[])iterator.next();
            String label = (String)obja[0];
            int target = (Integer)obja[1];
            int[] labelInfo = (int[])this.labels.get(label);
            if (labelInfo == null) {
                System.out.println("Missing label '" + label + "' in action code");
                continue;
            }
            int absolute = labelInfo[0];
            int relative = absolute - (target + 2);
            byte[] val = OutStream.sintTo2Bytes(relative);
            bytes[target] = val[0];
            bytes[target + 1] = val[1];
        }
    }

    protected void fixupSkips(byte[] bytes2) {
        byte[] bytes = bytes2;
        Iterator iterator = this.skips.iterator();
        while (iterator.hasNext()) {
            byte val;
            Object[] obja = (Object[])iterator.next();
            String label = (String)obja[0];
            int[] skipInfo = (int[])obja[1];
            int skipIndex = skipInfo[0];
            int skipLoc = skipInfo[1];
            int[] labelInfo = (int[])this.labels.get(label);
            if (labelInfo == null) {
                System.out.println("Missing label '" + label + "' in action code");
                continue;
            }
            int labelIndex = labelInfo[1];
            int skip = labelIndex - skipIndex - 1;
            bytes[skipLoc] = val = OutStream.uintToByte(skip);
        }
    }

    public void comment(String comment) throws IOException {
    }

    public void unknown(int code, byte[] data) throws IOException {
        int length;
        this.writeCode(code);
        int n = length = data != null ? data.length : 0;
        if (code >= 128 || length > 0) {
            this.out.writeUI16(length);
        }
        if (length > 0) {
            this.out.write(data);
        }
    }

    public void initArray() throws IOException {
        this.writeCode(66);
    }

    public void jumpLabel(String label) throws IOException {
        if (this.pushValues.size() > 0) {
            this.flushPushValues();
        }
        int offset = (int)this.out.getBytesWritten();
        if (this.labels == null) {
            this.labels = new Hashtable();
        }
        this.labels.put(label, new int[]{offset, this.count + 1});
    }

    public void gotoFrame(int frameNumber) throws IOException {
        this.writeCode(129);
        this.out.writeUI16(2);
        this.out.writeUI16(frameNumber);
    }

    public void gotoFrame(String label) throws IOException {
        this.writeCode(140);
        this.out.writeUI16(OutStream.getStringLength(label));
        this.out.writeString(label);
    }

    public void getURL(String url, String target) throws IOException {
        this.writeCode(131);
        this.out.writeUI16(OutStream.getStringLength(url) + OutStream.getStringLength(target));
        this.out.writeString(url);
        this.out.writeString(target);
    }

    public void nextFrame() throws IOException {
        this.writeCode(4);
    }

    public void prevFrame() throws IOException {
        this.writeCode(5);
    }

    public void play() throws IOException {
        this.writeCode(6);
    }

    public void stop() throws IOException {
        this.writeCode(7);
    }

    public void toggleQuality() throws IOException {
        this.writeCode(8);
    }

    public void stopSounds() throws IOException {
        this.writeCode(9);
    }

    public void setTarget(String target) throws IOException {
        this.writeCode(139);
        this.out.writeUI16(OutStream.getStringLength(target));
        this.out.writeString(target);
    }

    protected void writeJump(String label, int code) throws IOException {
        this.writeCode(code);
        this.out.writeUI16(2);
        int here = (int)this.out.getBytesWritten();
        this.out.writeUI16(0);
        if (this.jumps == null) {
            this.jumps = new Vector();
        }
        this.jumps.add(new Object[]{label, new Integer(here)});
    }

    public void jump(String jumpLabel) throws IOException {
        this.writeJump(jumpLabel, 153);
    }

    public void ifJump(String jumpLabel) throws IOException {
        this.writeJump(jumpLabel, 157);
    }

    public void waitForFrame(int frameNumber, String jumpLabel) throws IOException {
        this.writeCode(138);
        this.out.writeUI16(3);
        this.out.writeUI16(frameNumber);
        int here = (int)this.out.getBytesWritten();
        this.out.writeUI8(0);
        if (this.skips == null) {
            this.skips = new Vector();
        }
        this.skips.add(new Object[]{jumpLabel, new int[]{this.count, here}});
    }

    public void waitForFrame(String jumpLabel) throws IOException {
        this.writeCode(141);
        this.out.writeUI16(1);
        int here = (int)this.out.getBytesWritten();
        this.out.writeUI8(0);
        if (this.skips == null) {
            this.skips = new Vector();
        }
        this.skips.add(new Object[]{jumpLabel, new int[]{this.count, here}});
    }

    public void pop() throws IOException {
        this.writeCode(23);
    }

    public void add() throws IOException {
        this.writeCode(10);
    }

    public void substract() throws IOException {
        this.writeCode(11);
    }

    public void multiply() throws IOException {
        this.writeCode(12);
    }

    public void divide() throws IOException {
        this.writeCode(13);
    }

    public void equals() throws IOException {
        this.writeCode(14);
    }

    public void lessThan() throws IOException {
        this.writeCode(15);
    }

    public void and() throws IOException {
        this.writeCode(16);
    }

    public void or() throws IOException {
        this.writeCode(17);
    }

    public void not() throws IOException {
        this.writeCode(18);
    }

    public void stringEquals() throws IOException {
        this.writeCode(19);
    }

    public void stringLength() throws IOException {
        this.writeCode(20);
    }

    public void concat() throws IOException {
        this.writeCode(33);
    }

    public void substring() throws IOException {
        this.writeCode(21);
    }

    public void stringLessThan() throws IOException {
        this.writeCode(41);
    }

    public void stringLengthMB() throws IOException {
        this.writeCode(49);
    }

    public void substringMB() throws IOException {
        this.writeCode(53);
    }

    public void toInteger() throws IOException {
        this.writeCode(24);
    }

    public void charToAscii() throws IOException {
        this.writeCode(50);
    }

    public void asciiToChar() throws IOException {
        this.writeCode(51);
    }

    public void charMBToAscii() throws IOException {
        this.writeCode(54);
    }

    public void asciiToCharMB() throws IOException {
        this.writeCode(55);
    }

    public void call() throws IOException {
        this.writeCode(158);
        this.out.writeUI16(0);
    }

    public void getVariable() throws IOException {
        this.writeCode(28);
    }

    public void setVariable() throws IOException {
        this.writeCode(29);
    }

    public void getURL(int sendVars, int loadMode) throws IOException {
        this.writeCode(154);
        this.out.writeUI16(1);
        int flags = 0;
        switch (sendVars) {
            case 1: {
                flags = 1;
                break;
            }
            case 2: {
                flags = 2;
                break;
            }
        }
        switch (loadMode) {
            case 0: {
                break;
            }
            case 1: {
                flags |= 0x40;
                break;
            }
            case 3: {
                flags |= 0x80;
                break;
            }
            case 4: {
                flags |= 0xC0;
                break;
            }
        }
        this.out.writeUI8(flags);
    }

    public void gotoFrame(boolean play) throws IOException {
        this.writeCode(159);
        this.out.writeUI16(1);
        this.out.writeUI8(play ? 1 : 0);
    }

    public void setTarget() throws IOException {
        this.writeCode(32);
    }

    public void getProperty() throws IOException {
        this.writeCode(34);
    }

    public void setProperty() throws IOException {
        this.writeCode(35);
    }

    public void cloneSprite() throws IOException {
        this.writeCode(36);
    }

    public void removeSprite() throws IOException {
        this.writeCode(37);
    }

    public void startDrag() throws IOException {
        this.writeCode(39);
    }

    public void endDrag() throws IOException {
        this.writeCode(40);
    }

    public void trace() throws IOException {
        this.writeCode(38);
    }

    public void getTime() throws IOException {
        this.writeCode(52);
    }

    public void randomNumber() throws IOException {
        this.writeCode(48);
    }

    public void lookupTable(String[] values) throws IOException {
        this.writeCode(136);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        OutStream bout = new OutStream(baout);
        bout.writeUI16(values.length);
        int i = 0;
        while (i < values.length) {
            bout.writeString(values[i]);
            ++i;
        }
        bout.flush();
        byte[] data = baout.toByteArray();
        this.out.writeUI16(data.length);
        this.out.write(data);
    }

    public void callFunction() throws IOException {
        this.writeCode(61);
    }

    public void callMethod() throws IOException {
        this.writeCode(82);
    }

    public void startFunction(String name, String[] paramNames) throws IOException {
        if (this.blockStack == null) {
            this.blockStack = new Stack();
        }
        this.writeCode(155);
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        OutStream bout = new OutStream(baout);
        bout.writeString(name);
        bout.writeUI16(paramNames.length);
        int i = 0;
        while (i < paramNames.length) {
            bout.writeString(paramNames[i]);
            ++i;
        }
        bout.writeUI16(0);
        bout.flush();
        byte[] data = baout.toByteArray();
        this.out.writeUI16(data.length);
        this.out.write(data);
        int[] nArray = new int[2];
        nArray[0] = (int)this.out.getBytesWritten();
        this.blockStack.push(nArray);
    }

    public void endBlock() throws IOException {
        if (this.blockStack == null || this.blockStack.isEmpty()) {
            return;
        }
        int[] blockInfo = (int[])this.blockStack.pop();
        if (this.blocks == null) {
            this.blocks = new Vector();
        }
        int offset = blockInfo[0];
        int codeSize = (int)this.out.getBytesWritten() - offset;
        blockInfo[0] = offset - 2;
        blockInfo[1] = codeSize;
        this.blocks.add(blockInfo);
    }

    public void defineLocalValue() throws IOException {
        this.writeCode(60);
    }

    public void defineLocal() throws IOException {
        this.writeCode(65);
    }

    public void deleteProperty() throws IOException {
        this.writeCode(58);
    }

    public void deleteThreadVars() throws IOException {
        this.writeCode(59);
    }

    public void enumerate() throws IOException {
        this.writeCode(70);
    }

    public void typedEquals() throws IOException {
        this.writeCode(73);
    }

    public void getMember() throws IOException {
        this.writeCode(78);
    }

    public void initObject() throws IOException {
        this.writeCode(67);
    }

    public void newMethod() throws IOException {
        this.writeCode(83);
    }

    public void newObject() throws IOException {
        this.writeCode(64);
    }

    public void setMember() throws IOException {
        this.writeCode(79);
    }

    public void getTargetPath() throws IOException {
        this.writeCode(69);
    }

    public void startWith() throws IOException {
        this.writeCode(148);
        this.out.writeUI16(2);
        this.out.writeUI16(0);
        if (this.blockStack == null) {
            this.blockStack = new Stack();
        }
        int[] nArray = new int[2];
        nArray[0] = (int)this.out.getBytesWritten();
        this.blockStack.push(nArray);
    }

    public void duplicate() throws IOException {
        this.writeCode(76);
    }

    public void returnValue() throws IOException {
        this.writeCode(62);
    }

    public void swap() throws IOException {
        this.writeCode(77);
    }

    public void storeInRegister(int registerNumber) throws IOException {
        this.writeCode(135);
        this.out.writeUI16(1);
        this.out.writeUI8(registerNumber);
    }

    public void convertToNumber() throws IOException {
        this.writeCode(74);
    }

    public void convertToString() throws IOException {
        this.writeCode(75);
    }

    public void typeOf() throws IOException {
        this.writeCode(68);
    }

    public void typedAdd() throws IOException {
        this.writeCode(71);
    }

    public void typedLessThan() throws IOException {
        this.writeCode(72);
    }

    public void modulo() throws IOException {
        this.writeCode(63);
    }

    public void bitAnd() throws IOException {
        this.writeCode(96);
    }

    public void bitOr() throws IOException {
        this.writeCode(97);
    }

    public void bitXor() throws IOException {
        this.writeCode(98);
    }

    public void shiftLeft() throws IOException {
        this.writeCode(99);
    }

    public void shiftRight() throws IOException {
        this.writeCode(100);
    }

    public void shiftRightUnsigned() throws IOException {
        this.writeCode(101);
    }

    public void decrement() throws IOException {
        this.writeCode(81);
    }

    public void increment() throws IOException {
        this.writeCode(80);
    }

    protected void flushPushValues() throws IOException {
        this.out.writeUI8(150);
        ++this.count;
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        OutStream bout = new OutStream(baout);
        Iterator iterator = this.pushValues.iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof String) {
                bout.writeUI8(0);
                bout.writeString(value.toString());
                continue;
            }
            if (value instanceof Boolean) {
                bout.writeUI8(5);
                bout.writeUI8((Boolean)value != false ? 1 : 0);
                continue;
            }
            if (value instanceof Integer) {
                bout.writeUI8(7);
                bout.writeSI32((Integer)value);
                continue;
            }
            if (value instanceof Short) {
                bout.writeUI8(8);
                bout.writeUI8(((Short)value).intValue());
                continue;
            }
            if (value instanceof Byte) {
                bout.writeUI8(4);
                bout.writeUI8(((Byte)value).intValue());
                continue;
            }
            if (value instanceof Float) {
                bout.writeUI8(1);
                bout.writeFloat(((Float)value).floatValue());
                continue;
            }
            if (value instanceof Double) {
                bout.writeUI8(6);
                bout.writeDouble((Double)value);
                continue;
            }
            bout.writeUI8(2);
        }
        this.pushValues.clear();
        bout.flush();
        byte[] data = baout.toByteArray();
        this.out.writeUI16(data.length);
        this.out.write(data);
    }

    public void push(String value) throws IOException {
        this.pushValues.add(value);
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(float value) throws IOException {
        this.pushValues.add(new Float(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(double value) throws IOException {
        this.pushValues.add(new Double(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void pushNull() throws IOException {
        this.pushValues.add(new Object());
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void pushRegister(int registerNumber) throws IOException {
        this.pushValues.add(new Byte((byte)registerNumber));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(boolean value) throws IOException {
        this.pushValues.add(value);
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void push(int value) throws IOException {
        this.pushValues.add(new Integer(value));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }

    public void lookup(int dictionaryIndex) throws IOException {
        this.pushValues.add(new Short((short)dictionaryIndex));
        if (this.flashVersion < 5) {
            this.flushPushValues();
        }
    }
}

