/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.InStream;
import pt.tumba.parser.swf.OutStream;

public class AlphaColor
extends Color {
    protected int alpha;

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public AlphaColor(int red, int green, int blue, int alpha) {
        super(red, green, blue);
        this.alpha = alpha;
    }

    public AlphaColor(Color color, int alpha) {
        this(color.getRed(), color.getGreen(), color.getBlue(), alpha);
    }

    public AlphaColor(InStream in) throws IOException {
        super(in);
        this.alpha = in.readUI8();
    }

    public void write(OutStream out) throws IOException {
        this.writeRGB(out);
        out.writeUI8(this.alpha);
    }

    public void writeWithAlpha(OutStream out) throws IOException {
        this.write(out);
    }

    public boolean equals(Object color) {
        return super.equals(color) && this.alpha == ((AlphaColor)color).getAlpha();
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "RGBA(" + this.red + "," + this.green + "," + this.blue + "," + this.alpha + ")";
    }
}

