/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pt.tumba.parser.swf.Actions;
import pt.tumba.parser.swf.AlphaTransform;
import pt.tumba.parser.swf.ButtonRecord2;
import pt.tumba.parser.swf.Movie;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.Symbol;
import pt.tumba.parser.swf.Transform;

public class Button
extends Symbol {
    protected List actions = new ArrayList();
    protected List layers = new ArrayList();
    protected boolean trackAsMenu;

    public Button(boolean trackAsMenu) {
        this.trackAsMenu = trackAsMenu;
    }

    public boolean isTrackedAsMenu() {
        return this.trackAsMenu;
    }

    public void trackAsMenu(boolean f) {
        this.trackAsMenu = f;
    }

    public List getButtonLayers() {
        return this.layers;
    }

    public List getActions() {
        return this.actions;
    }

    public Layer addLayer(Symbol symbol, Transform matrix, AlphaTransform cxform, int depth, boolean usedForHitArea, boolean usedForUp, boolean usedForDown, boolean usedForOver) {
        Layer layer = new Layer(symbol, matrix, cxform, depth, usedForHitArea, usedForUp, usedForDown, usedForOver);
        this.layers.add(layer);
        return layer;
    }

    public Actions addActions(int conditionFlags, int flashVersion) {
        Actions acts = new Actions(conditionFlags, flashVersion);
        this.actions.add(acts);
        return acts;
    }

    protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        int id = this.getNextId(movie);
        Vector<ButtonRecord2> recs = new Vector<ButtonRecord2>();
        Iterator it = this.layers.iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            recs.addElement(layer.getRecord(movie, timelineWriter, definitionWriter));
        }
        SWFActions acts = definitionWriter.tagDefineButton2(id, this.trackAsMenu, recs);
        Iterator it2 = this.actions.iterator();
        while (it2.hasNext()) {
            Actions actions = (Actions)it2.next();
            acts.start(actions.getConditions());
            acts.blob(actions.bytes);
        }
        acts.done();
        return id;
    }

    public static class Layer {
        protected Symbol symbol;
        protected Transform matrix;
        protected AlphaTransform cxform;
        protected int depth;
        protected boolean usedForHitArea;
        protected boolean usedForUp;
        protected boolean usedForDown;
        protected boolean usedForOver;

        public Symbol getSymbol() {
            return this.symbol;
        }

        public Transform getTransform() {
            return this.matrix;
        }

        public AlphaTransform getColoring() {
            return this.cxform;
        }

        public int getDepth() {
            return this.depth;
        }

        public boolean isUsedForHitArea() {
            return this.usedForHitArea;
        }

        public boolean isUsedForUp() {
            return this.usedForUp;
        }

        public boolean isUsedForDown() {
            return this.usedForDown;
        }

        public boolean isUsedForOver() {
            return this.usedForOver;
        }

        public void setSymbol(Symbol symbol) {
            this.symbol = symbol;
        }

        public void setTransform(Transform matrix) {
            this.matrix = matrix;
        }

        public void setColoring(AlphaTransform cxform) {
            this.cxform = cxform;
        }

        public void setDepth(int depth) {
            this.depth = depth;
        }

        public void usedForHitArea(boolean f) {
            this.usedForHitArea = f;
        }

        public void usedForUp(boolean f) {
            this.usedForUp = f;
        }

        public void usedForDown(boolean f) {
            this.usedForDown = f;
        }

        public void usedForOver(boolean f) {
            this.usedForOver = f;
        }

        public Layer(Symbol symbol, Transform matrix, AlphaTransform cxform, int depth, boolean usedForHitArea, boolean usedForUp, boolean usedForDown, boolean usedForOver) {
            if (matrix == null) {
                matrix = new Transform();
            }
            if (cxform == null) {
                cxform = new AlphaTransform();
            }
            this.symbol = symbol;
            this.matrix = matrix;
            this.cxform = cxform;
            this.depth = depth;
            this.usedForHitArea = usedForHitArea;
            this.usedForUp = usedForUp;
            this.usedForDown = usedForDown;
            this.usedForOver = usedForOver;
        }

        protected ButtonRecord2 getRecord(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
            int symId = this.symbol.define(movie, timelineWriter, definitionWriter);
            int flags = 0;
            if (this.usedForHitArea) {
                flags |= 8;
            }
            if (this.usedForUp) {
                flags |= 1;
            }
            if (this.usedForDown) {
                flags |= 4;
            }
            if (this.usedForOver) {
                flags |= 2;
            }
            return new ButtonRecord2(symId, this.depth, this.matrix, this.cxform, flags);
        }
    }
}

