/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import pt.tumba.parser.swf.InStream;
import pt.tumba.parser.swf.OutStream;

public class ColorTransform {
    protected double multRed = 1.0;
    protected double multGreen = 1.0;
    protected double multBlue = 1.0;
    protected int addRed = 0;
    protected int addGreen = 0;
    protected int addBlue = 0;
    protected double multAlpha = 1.0;
    protected int addAlpha = 0;

    public double getMultRed() {
        return this.multRed;
    }

    public double getMultGreen() {
        return this.multGreen;
    }

    public double getMultBlue() {
        return this.multBlue;
    }

    public int getAddRed() {
        return this.addRed;
    }

    public int getAddGreen() {
        return this.addGreen;
    }

    public int getAddBlue() {
        return this.addBlue;
    }

    public void setMultRed(double multRed) {
        this.multRed = multRed;
    }

    public void setMultGreen(double multGreen) {
        this.multGreen = multGreen;
    }

    public void setMultBlue(double multBlue) {
        this.multBlue = multBlue;
    }

    public void setAddRed(int addRed) {
        this.addRed = addRed;
    }

    public void setAddGreen(int addGreen) {
        this.addGreen = addGreen;
    }

    public void setAddBlue(int addBlue) {
        this.addBlue = addBlue;
    }

    public ColorTransform() {
    }

    public ColorTransform(double multRed, double multGreen, double multBlue, int addRed, int addGreen, int addBlue) {
        this.multRed = multRed;
        this.multGreen = multGreen;
        this.multBlue = multBlue;
        this.addRed = addRed;
        this.addGreen = addGreen;
        this.addBlue = addBlue;
    }

    public ColorTransform(int addRed, int addGreen, int addBlue) {
        this.addRed = addRed;
        this.addGreen = addGreen;
        this.addBlue = addBlue;
    }

    public ColorTransform(double multRed, double multGreen, double multBlue) {
        this.multRed = multRed;
        this.multGreen = multGreen;
        this.multBlue = multBlue;
    }

    public ColorTransform(InStream in) throws IOException {
        in.synchBits();
        boolean hasAddTerms = in.readUBits(1) == 1L;
        boolean hasMultTerms = in.readUBits(1) == 1L;
        int numBits = (int)in.readUBits(4);
        if (hasMultTerms) {
            this.multRed = (double)in.readSBits(numBits) / 256.0;
            this.multGreen = (double)in.readSBits(numBits) / 256.0;
            this.multBlue = (double)in.readSBits(numBits) / 256.0;
        }
        if (hasAddTerms) {
            this.addRed = in.readSBits(numBits);
            this.addGreen = in.readSBits(numBits);
            this.addBlue = in.readSBits(numBits);
        }
    }

    public void write(OutStream out) throws IOException {
        int blueBits;
        int greenBits;
        int redBits;
        out.flushBits();
        boolean hasAddTerms = this.addRed != 0 || this.addGreen != 0 || this.addBlue != 0;
        boolean hasMultTerms = this.multRed != 1.0 || this.multGreen != 1.0 || this.multBlue != 1.0;
        int intMultRed = (int)(this.multRed * 256.0);
        int intMultGreen = (int)(this.multGreen * 256.0);
        int intMultBlue = (int)(this.multBlue * 256.0);
        int numBits = 1;
        if (hasAddTerms) {
            redBits = OutStream.determineSignedBitSize(this.addRed);
            greenBits = OutStream.determineSignedBitSize(this.addGreen);
            blueBits = OutStream.determineSignedBitSize(this.addBlue);
            if (numBits < redBits) {
                numBits = redBits;
            }
            if (numBits < greenBits) {
                numBits = greenBits;
            }
            if (numBits < blueBits) {
                numBits = blueBits;
            }
        }
        if (hasMultTerms) {
            redBits = OutStream.determineSignedBitSize(intMultRed);
            greenBits = OutStream.determineSignedBitSize(intMultGreen);
            blueBits = OutStream.determineSignedBitSize(intMultBlue);
            if (numBits < redBits) {
                numBits = redBits;
            }
            if (numBits < greenBits) {
                numBits = greenBits;
            }
            if (numBits < blueBits) {
                numBits = blueBits;
            }
        }
        out.writeUBits(1, hasAddTerms ? 1L : 0L);
        out.writeUBits(1, hasMultTerms ? 1L : 0L);
        out.writeUBits(4, numBits);
        if (hasMultTerms) {
            out.writeSBits(numBits, intMultRed);
            out.writeSBits(numBits, intMultGreen);
            out.writeSBits(numBits, intMultBlue);
        }
        if (hasAddTerms) {
            out.writeSBits(numBits, this.addRed);
            out.writeSBits(numBits, this.addGreen);
            out.writeSBits(numBits, this.addBlue);
        }
        out.flushBits();
    }

    public void writeWithoutAlpha(OutStream out) throws IOException {
        this.write(out);
    }

    public void writeWithAlpha(OutStream out) throws IOException {
        int alphaBits;
        int blueBits;
        int greenBits;
        int redBits;
        out.flushBits();
        boolean hasAddTerms = this.addRed != 0 || this.addGreen != 0 || this.addBlue != 0 || this.addAlpha != 0;
        boolean hasMultTerms = this.multRed != 1.0 || this.multGreen != 1.0 || this.multBlue != 1.0 || this.multAlpha != 1.0;
        int intMultRed = (int)(this.multRed * 256.0);
        int intMultGreen = (int)(this.multGreen * 256.0);
        int intMultBlue = (int)(this.multBlue * 256.0);
        int intMultAlpha = (int)(this.multAlpha * 256.0);
        int numBits = 1;
        if (hasAddTerms) {
            redBits = OutStream.determineSignedBitSize(this.addRed);
            greenBits = OutStream.determineSignedBitSize(this.addGreen);
            blueBits = OutStream.determineSignedBitSize(this.addBlue);
            alphaBits = OutStream.determineSignedBitSize(this.addAlpha);
            if (numBits < redBits) {
                numBits = redBits;
            }
            if (numBits < greenBits) {
                numBits = greenBits;
            }
            if (numBits < blueBits) {
                numBits = blueBits;
            }
            if (numBits < alphaBits) {
                numBits = alphaBits;
            }
        }
        if (hasMultTerms) {
            redBits = OutStream.determineSignedBitSize(intMultRed);
            greenBits = OutStream.determineSignedBitSize(intMultGreen);
            blueBits = OutStream.determineSignedBitSize(intMultBlue);
            alphaBits = OutStream.determineSignedBitSize(intMultAlpha);
            if (numBits < redBits) {
                numBits = redBits;
            }
            if (numBits < greenBits) {
                numBits = greenBits;
            }
            if (numBits < blueBits) {
                numBits = blueBits;
            }
            if (numBits < alphaBits) {
                numBits = alphaBits;
            }
        }
        out.writeUBits(1, hasAddTerms ? 1L : 0L);
        out.writeUBits(1, hasMultTerms ? 1L : 0L);
        out.writeUBits(4, numBits);
        if (hasMultTerms) {
            out.writeSBits(numBits, intMultRed);
            out.writeSBits(numBits, intMultGreen);
            out.writeSBits(numBits, intMultBlue);
            out.writeSBits(numBits, intMultAlpha);
        }
        if (hasAddTerms) {
            out.writeSBits(numBits, this.addRed);
            out.writeSBits(numBits, this.addGreen);
            out.writeSBits(numBits, this.addBlue);
            out.writeSBits(numBits, this.addAlpha);
        }
        out.flushBits();
    }

    public String toString() {
        return " cxform(+rgb,*rgb)=(" + this.addRed + "," + this.addGreen + "," + this.addBlue + "," + this.multRed + "," + this.multGreen + "," + this.multBlue + ")";
    }
}

