/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.SWFActionsImpl;

public class Decompiler
extends SWFActionsImpl
implements SWFActions {
    protected Writer writer;
    protected int indent = 0;
    protected Stack labelStack = new Stack();
    protected Stack stack = new Stack();
    protected String[] lookupTable = null;
    protected Object[] registers = new Object[10];
    protected Stack writerStack = new Stack();
    protected boolean duplicated = false;
    protected String gotoFrame;

    public Decompiler(Writer writer) {
        this.writer = writer;
    }

    public Decompiler(Writer writer, int indent) {
        this.writer = writer;
        this.indent = indent;
    }

    protected void indent() throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.writer.write("    ");
            ++i;
        }
    }

    protected String destring(String s2) {
        String s = s2.trim();
        if (s.startsWith("\"") && s.endsWith("\"")) {
            if (s.length() >= 3) {
                return s.substring(1, s.length() - 1);
            }
            return "";
        }
        return s;
    }

    protected String string(String s) {
        StringBuffer buff = new StringBuffer("\"");
        int len = s.length();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    buff.append("\\b");
                    break;
                }
                case '\f': {
                    buff.append("\\f");
                    break;
                }
                case '\n': {
                    buff.append("\\n");
                    break;
                }
                case '\r': {
                    buff.append("\\r");
                    break;
                }
                case '\t': {
                    buff.append("\\t");
                    break;
                }
                case '\"': {
                    buff.append("\\\"");
                    break;
                }
                case '\\': {
                    buff.append("\\\\");
                    break;
                }
                default: {
                    buff.append("" + c);
                }
            }
            ++i;
        }
        buff.append("\"");
        return buff.toString();
    }

    public void start(int flags) throws IOException {
        this.writeConditions(flags);
        this.labelStack.clear();
        this.stack.clear();
        this.writerStack.clear();
        this.lookupTable = null;
    }

    protected void writeConditions(int flags) throws IOException {
        this.indent();
        this.writer.write("Conditions: " + Integer.toBinaryString(flags) + "\n\n");
    }

    protected Object pop2() {
        if (this.stack.isEmpty()) {
            return "void()";
        }
        this.duplicated = false;
        return this.stack.pop();
    }

    protected Object peek() {
        if (this.stack.isEmpty()) {
            return "void()";
        }
        return this.stack.peek();
    }

    public void done() {
    }

    public void end() throws IOException {
        this.writer.write("\n");
    }

    public void blob(byte[] blob) {
    }

    public void unknown(int code, byte[] data) {
    }

    public void jumpLabel(String label) throws IOException {
        if (!this.labelStack.isEmpty()) {
            while (!this.labelStack.isEmpty() && this.labelStack.peek().equals(label)) {
                this.labelStack.pop();
                --this.indent;
                this.indent();
                this.writer.write("}\n\n");
            }
        }
    }

    public void comment(String comment) throws IOException {
        this.writer.write("\n");
        this.indent();
        this.writer.write("/* ");
        this.writer.write(comment);
        this.writer.write(" */\n");
    }

    public void gotoFrame(int frameNumber) throws IOException {
        this.gotoFrame = Integer.toString(frameNumber + 1);
    }

    public void gotoFrame(String label) throws IOException {
        this.gotoFrame = this.string(label);
    }

    public void getURL(String url2, String target) throws IOException {
        String url = url2;
        if (url == null) {
            url = "";
        }
        this.indent();
        this.writer.write("getURL( ");
        this.writer.write(this.string(url));
        if (target != null) {
            this.writer.write(", ");
            this.writer.write(this.string(target));
        }
        this.writer.write(" );\n");
    }

    public void nextFrame() throws IOException {
        this.indent();
        this.writer.write("nextFrame();\n");
    }

    public void prevFrame() throws IOException {
        this.indent();
        this.writer.write("prevFrame();\n");
    }

    public void play() throws IOException {
        this.indent();
        if (this.gotoFrame != null) {
            this.writer.write("gotoAndPlay( ");
            this.writer.write(this.gotoFrame);
            this.writer.write(" );\n");
            this.gotoFrame = null;
        } else {
            this.writer.write("play();\n");
        }
    }

    public void stop() throws IOException {
        this.indent();
        if (this.gotoFrame != null) {
            this.writer.write("gotoAndStop( ");
            this.writer.write(this.gotoFrame);
            this.writer.write(" );\n");
            this.gotoFrame = null;
        } else {
            this.writer.write("stop();\n");
        }
    }

    public void toggleQuality() throws IOException {
        this.indent();
        this.writer.write("toggleHighQuality();\n");
    }

    public void stopSounds() throws IOException {
        this.indent();
        this.writer.write("stopAllSounds();\n");
    }

    public void waitForFrame(int frameNumber, String jumpLabel) throws IOException {
        this.writer.write("\n");
        this.indent();
        this.writer.write("ifFrameLoaded( ");
        this.writer.write(Integer.toString(frameNumber + 1));
        this.writer.write(" )\n");
        this.indent();
        this.writer.write("{\n");
        ++this.indent;
        this.labelStack.push(jumpLabel);
    }

    public void setTarget(String target) throws IOException {
        if (target == null || target.length() == 0) {
            --this.indent;
            this.indent();
            this.writer.write("}\n\n");
        } else {
            this.writer.write("\n");
            this.indent();
            this.writer.write("tellTarget( ");
            this.writer.write(this.string(target));
            this.writer.write(" )\n");
            this.indent();
            this.writer.write("{\n");
            ++this.indent;
        }
    }

    protected void operator(String op) throws IOException {
        Object one = this.pop2();
        Object two = this.pop2();
        if (one instanceof StringBuffer) {
            one = "(" + one + ")";
        }
        if (two instanceof StringBuffer) {
            two = "(" + two + ")";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(two.toString());
        buff.append(op);
        buff.append(one.toString());
        this.stack.push(buff);
    }

    public void add() throws IOException {
        this.operator(" + ");
    }

    public void substract() throws IOException {
        this.operator(" - ");
    }

    public void multiply() throws IOException {
        this.operator(" * ");
    }

    public void divide() throws IOException {
        this.operator(" / ");
    }

    public void equals() throws IOException {
        this.operator(" == ");
    }

    public void lessThan() throws IOException {
        this.operator(" < ");
    }

    public void and() throws IOException {
        this.operator(" && ");
    }

    public void or() throws IOException {
        this.operator(" || ");
    }

    public void not() throws IOException {
        StringBuffer buff = new StringBuffer("not( ");
        buff.append(this.pop2());
        buff.append(" )");
        this.stack.push(buff);
    }

    public void toInteger() throws IOException {
        this.stack.push("int( " + this.pop2().toString() + " )");
    }

    public void getVariable() throws IOException {
        Object name = this.pop2();
        name = name instanceof String && ((String)name).startsWith("\"") ? this.destring((String)name) : "eval( " + name.toString() + " )";
        this.stack.push(name);
    }

    public void setVariable() throws IOException {
        this.indent();
        String value = this.stack.size() < 2 ? "void()" : this.pop2().toString();
        String varname = this.destring(this.pop2().toString());
        this.writer.write(String.valueOf(varname) + " = " + value);
        if (!value.trim().endsWith("}")) {
            this.writer.write(";\n");
        }
    }

    public void trace() throws IOException {
        this.indent();
        this.writer.write("trace( " + this.pop2().toString() + " );\n");
    }

    public void getTime() throws IOException {
        this.stack.push("getTimer()");
    }

    public void randomNumber() throws IOException {
        this.stack.push("random( " + this.destring(this.pop2().toString()) + " )");
    }

    public void callFunction() throws IOException {
        String name = this.destring(this.pop2().toString());
        int numargs = ((Number)this.pop2()).intValue();
        StringBuffer buff = new StringBuffer();
        buff.append(name);
        buff.append("(");
        int i = 0;
        while (i < numargs) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(" ");
            buff.append(this.destring(this.pop2().toString()));
            ++i;
        }
        if (numargs > 0) {
            buff.append(" ");
        }
        buff.append(")");
        this.stack.push(buff);
    }

    public void callMethod() throws IOException {
        String name = this.pop2().toString();
        String obj = this.pop2().toString();
        int numargs = ((Number)this.pop2()).intValue();
        if (obj instanceof StringBuffer) {
            obj = "(" + obj + ")";
        }
        name = name.startsWith("\"") ? "." + this.destring(name) : "[" + name + "]";
        StringBuffer buff = new StringBuffer();
        buff.append(obj.toString());
        buff.append(name);
        buff.append("(");
        int i = 0;
        while (i < numargs) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(" ");
            buff.append(this.destring(this.pop2().toString()));
            ++i;
        }
        if (numargs > 0) {
            buff.append(" ");
        }
        buff.append(")");
        this.stack.push(buff);
    }

    public void lookupTable(String[] values) throws IOException {
        this.lookupTable = values;
    }

    public void startFunction(String name, String[] paramNames2) throws IOException {
        String[] paramNames = paramNames2;
        if (name == null || name.trim().length() == 0) {
            this.writerStack.push(this.writer);
            this.writer = new StringWriter();
            this.writer.write("function(");
        } else {
            this.indent();
            this.writer.write("function " + name + "(");
        }
        if (paramNames == null) {
            paramNames = new String[]{};
        }
        int i = 0;
        while (i < paramNames.length) {
            if (i > 0) {
                this.writer.write(",");
            }
            this.writer.write(" ");
            this.writer.write(paramNames[i]);
            ++i;
        }
        if (paramNames.length > 0) {
            this.writer.write(" ");
        }
        this.writer.write(")\n");
        this.indent();
        this.writer.write("{\n");
        ++this.indent;
    }

    public void endBlock() throws IOException {
        --this.indent;
        this.indent();
        this.writer.write("}\n\n");
        if (!this.writerStack.isEmpty()) {
            this.stack.push(((StringWriter)this.writer).getBuffer());
            this.writer = (Writer)this.writerStack.pop();
        }
    }

    public void defineLocalValue() throws IOException {
        String value = this.pop2().toString();
        String name = this.destring(this.pop2().toString());
        this.indent();
        this.writer.write("var " + name + " = " + value + ";\n");
    }

    public void defineLocal() throws IOException {
        String name = this.destring(this.pop2().toString());
        this.indent();
        this.writer.write("var " + name + ";\n");
    }

    public void typedEquals() throws IOException {
        this.equals();
    }

    public void startWith() throws IOException {
        this.indent();
        this.writer.write("with( " + this.destring(this.pop2().toString()) + " )\n");
        this.indent();
        this.writer.write("{\n");
        ++this.indent;
    }

    public void convertToNumber() throws IOException {
        this.stack.push("Number( " + this.pop2().toString() + " )");
    }

    public void convertToString() throws IOException {
        this.stack.push("String( " + this.pop2().toString() + " )");
    }

    public void typeOf() throws IOException {
        this.stack.push("typeOf( " + this.pop2().toString() + " )");
    }

    public void typedAdd() throws IOException {
        this.add();
    }

    public void typedLessThan() throws IOException {
        this.lessThan();
    }

    public void modulo() throws IOException {
        this.operator(" % ");
    }

    public void bitAnd() throws IOException {
        this.operator(" & ");
    }

    public void bitOr() throws IOException {
        this.operator(" | ");
    }

    public void bitXor() throws IOException {
        this.operator(" % ");
    }

    public void shiftLeft() throws IOException {
        this.operator(" << ");
    }

    public void shiftRight() throws IOException {
        this.operator(" >> ");
    }

    public void shiftRightUnsigned() throws IOException {
        this.operator(" >>> ");
    }

    public void decrement() throws IOException {
        Object value = this.pop2();
        if (value instanceof StringBuffer) {
            value = "(" + value + ")";
        }
        StringBuffer buff = new StringBuffer(value.toString());
        buff.append(" - 1");
        this.stack.push(buff);
    }

    public void increment() throws IOException {
        Object value = this.pop2();
        if (value instanceof StringBuffer) {
            value = "(" + value + ")";
        }
        StringBuffer buff = new StringBuffer(value.toString());
        buff.append(" + 1");
        this.stack.push(buff);
    }

    public void duplicate() throws IOException {
        this.stack.push(this.peek());
        this.duplicated = true;
    }

    public void swap() throws IOException {
        Object top = this.pop2();
        Object two = this.pop2();
        this.stack.push(top);
        this.stack.push(two);
    }

    public void storeInRegister(int registerNumber) throws IOException {
        if (registerNumber >= this.registers.length) {
            throw new IOException("Register index out of bounds");
        }
        this.registers[registerNumber] = this.peek();
    }

    public void push(double value) throws IOException {
        this.stack.push(new Double(value));
    }

    public void pushNull() throws IOException {
        this.stack.push("null");
    }

    public void pushRegister(int registerNumber) throws IOException {
        if (registerNumber >= this.registers.length) {
            throw new IOException("Register index out of bounds");
        }
        Object value = this.registers[registerNumber];
        if (value == null) {
            value = "null";
        }
        this.stack.push(value);
    }

    public void push(boolean value) throws IOException {
        this.stack.push(value);
    }

    public void push(int value) throws IOException {
        this.stack.push(new Integer(value));
    }

    public void push(String value) throws IOException {
        this.stack.push(this.string(value));
    }

    public void push(float value) throws IOException {
        this.stack.push(new Float(value));
    }

    public void pop() throws IOException {
        this.indent();
        this.writer.write(String.valueOf(this.pop2().toString()) + ";\n");
    }

    public void lookup(int dictionaryIndex) throws IOException {
        if (this.lookupTable == null || dictionaryIndex >= this.lookupTable.length) {
            throw new IOException("Lookup index is out of bounds of the lookup table");
        }
        this.stack.push(this.string(this.lookupTable[dictionaryIndex]));
    }
}

