/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pt.tumba.parser.swf.Shape;

public class FontDefinition {
    protected String name;
    protected double ascent;
    protected double descent;
    protected double leading;
    protected boolean isUnicode;
    protected boolean isShiftJIS;
    protected boolean isAnsi;
    protected boolean isItalic;
    protected boolean isBold;
    protected boolean hasMetrics;
    protected List glyphs = new ArrayList();
    protected List kerning = new ArrayList();
    protected Map glyphLookup;
    protected Map kernLookup;

    public String getName() {
        return this.name;
    }

    public double getAscent() {
        return this.ascent;
    }

    public double getDescent() {
        return this.descent;
    }

    public double getLeading() {
        return this.leading;
    }

    public boolean isUnicode() {
        return this.isUnicode;
    }

    public boolean isShiftJIS() {
        return this.isShiftJIS;
    }

    public boolean isAnsi() {
        return this.isAnsi;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean hasMetrics() {
        return this.hasMetrics;
    }

    public List getGlyphList() {
        return this.glyphs;
    }

    public List getKerningPairList() {
        return this.kerning;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAscent(double ascent) {
        this.ascent = ascent;
    }

    public void setDescent(double descent) {
        this.descent = descent;
    }

    public void setLeading(double leading) {
        this.leading = leading;
    }

    public void setFontFlags(boolean isUnicode, boolean isShiftJIS, boolean isAnsi, boolean isItalic, boolean isBold, boolean hasMetrics) {
        this.isUnicode = isUnicode;
        this.isShiftJIS = isShiftJIS;
        this.isAnsi = isAnsi;
        this.isItalic = isItalic;
        this.isBold = isBold;
        this.hasMetrics = hasMetrics;
    }

    public FontDefinition() {
    }

    public FontDefinition(String name, double ascent, double descent, double leading, boolean isUnicode, boolean isShiftJIS, boolean isAnsi, boolean isItalic, boolean isBold, boolean hasMetrics) {
        this.name = name;
        this.ascent = ascent;
        this.descent = descent;
        this.leading = leading;
        this.isUnicode = isUnicode;
        this.isShiftJIS = isShiftJIS;
        this.isAnsi = isAnsi;
        this.isItalic = isItalic;
        this.isBold = isBold;
        this.hasMetrics = hasMetrics;
    }

    public Glyph getGlyph(int code) {
        if (this.glyphLookup == null) {
            this.glyphLookup = new HashMap();
            Iterator it = this.glyphs.iterator();
            while (it.hasNext()) {
                Glyph g = (Glyph)it.next();
                this.glyphLookup.put(new Integer(g.code), g);
            }
        }
        Glyph g = (Glyph)this.glyphLookup.get(new Integer(code));
        return g;
    }

    public double getKerningOffset(int code1, int code2) {
        if (this.kernLookup == null) {
            this.kernLookup = new HashMap();
            Iterator it = this.kerning.iterator();
            while (it.hasNext()) {
                KerningPair pair = (KerningPair)it.next();
                Integer i1 = new Integer(pair.code1);
                Integer i2 = new Integer(pair.code2);
                HashMap<Integer, KerningPair> kerns = (HashMap<Integer, KerningPair>)this.kernLookup.get(i1);
                if (kerns == null) {
                    kerns = new HashMap<Integer, KerningPair>();
                    this.kernLookup.put(i1, kerns);
                }
                kerns.put(i2, pair);
            }
        }
        Integer i1 = new Integer(code1);
        Integer i2 = new Integer(code2);
        HashMap kerns = (HashMap)this.kernLookup.get(i1);
        if (kerns == null) {
            return 0.0;
        }
        KerningPair pair = (KerningPair)kerns.get(i2);
        if (pair == null) {
            return 0.0;
        }
        return pair.adjustment;
    }

    public static class Glyph {
        protected int code;
        protected double advance;
        protected Shape shape;

        public Shape getShape() {
            return this.shape;
        }

        public int getCode() {
            return this.code;
        }

        public double getAdvance() {
            return this.advance;
        }

        public void setShape(Shape shape) {
            this.shape = shape;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setAdvance(double advance) {
            this.advance = advance;
        }

        public Glyph(Shape shape, double advance, int code) {
            this.shape = shape;
            this.advance = advance;
            this.code = code;
        }
    }

    public static class KerningPair {
        protected int code1;
        protected int code2;
        protected double adjustment;

        public int getCode1() {
            return this.code1;
        }

        public int getCode2() {
            return this.code2;
        }

        public double getAdjustment() {
            return this.adjustment;
        }

        public void setCode1(int code) {
            this.code1 = code;
        }

        public void setCode2(int code) {
            this.code2 = code;
        }

        public void setAdjustment(double offset) {
            this.adjustment = offset;
        }

        public KerningPair(int code1, int code2, double adjustment) {
            this.code1 = code1;
            this.code2 = code2;
            this.adjustment = adjustment;
        }
    }
}

