/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import pt.tumba.parser.swf.FontDefinition;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFReader;
import pt.tumba.parser.swf.SWFTagTypesImpl;
import pt.tumba.parser.swf.SWFTags;
import pt.tumba.parser.swf.SWFVectors;
import pt.tumba.parser.swf.Shape;
import pt.tumba.parser.swf.TagParser;

public class FontLoader
extends SWFTagTypesImpl {
    protected FontDefinition fontDef;

    public FontLoader() {
        super(null);
    }

    public static FontDefinition loadFont(String filename) throws IOException {
        FileInputStream in = new FileInputStream(filename);
        FontDefinition def = FontLoader.loadFont(in);
        in.close();
        return def;
    }

    public static FontDefinition loadFont(InputStream flashMovie) throws IOException {
        FontLoader fontloader = new FontLoader();
        TagParser swfparser = new TagParser(fontloader);
        SWFReader swfreader = new SWFReader((SWFTags)swfparser, flashMovie);
        swfreader.readFile();
        return fontloader.fontDef;
    }

    public SWFVectors tagDefineFont2(int id, int flags, String name, int numGlyphs, int ascent, int descent, int leading, int[] codes, int[] advances, Rect[] bounds, int[] kernCodes1, int[] kernCodes2, int[] kernAdjustments) throws IOException {
        if (this.fontDef != null) {
            return null;
        }
        double twips = 20.0;
        this.fontDef = new FontDefinition(name, (double)ascent / twips, (double)descent / twips, (double)leading / twips, (flags & 0x20) != 0, (flags & 0x40) != 0, (flags & 0x10) != 0, (flags & 2) != 0, (flags & 1) != 0, (flags & 0x80) != 0);
        if (kernCodes1 != null && kernCodes1.length > 0) {
            List kerns = this.fontDef.getKerningPairList();
            int i = 0;
            while (i < kernCodes1.length) {
                FontDefinition.KerningPair pair = new FontDefinition.KerningPair(kernCodes1[i], kernCodes2[i], (double)kernAdjustments[i] / twips);
                kerns.add(pair);
                ++i;
            }
        }
        return new VectorImpl(codes, advances, bounds);
    }

    protected class VectorImpl
    implements SWFVectors {
        protected int[] codes;
        protected int[] advances;
        protected Rect[] bounds;
        protected int i;
        protected Shape shape;
        protected int currx;
        protected int curry;
        protected double twips = 20.0;

        protected VectorImpl(int[] codes, int[] advances, Rect[] bounds) {
            this.codes = codes;
            this.advances = advances;
            this.bounds = bounds;
            this.i = 0;
            this.shape = new Shape();
        }

        public void done() {
            double advance = this.advances == null ? 0.0 : (double)this.advances[this.i] / this.twips;
            int code = this.codes[this.i];
            Rect rect = this.bounds[this.i];
            this.shape.minX = (double)rect.getMinX() / this.twips;
            this.shape.minY = (double)rect.getMinY() / this.twips;
            this.shape.maxX = (double)rect.getMaxX() / this.twips;
            this.shape.maxY = (double)rect.getMaxY() / this.twips;
            FontDefinition.Glyph g = new FontDefinition.Glyph(this.shape, advance, code);
            FontLoader.this.fontDef.getGlyphList().add(g);
            ++this.i;
            if (this.i < this.codes.length) {
                this.shape = new Shape();
            }
            this.curry = 0;
            this.currx = 0;
        }

        public void line(int dx, int dy) {
            this.currx += dx;
            this.curry += dy;
            this.shape.line((double)this.currx / this.twips, (double)this.curry / this.twips);
        }

        public void curve(int cx2, int cy2, int dx2, int dy2) {
            int cx = cx2 + this.currx;
            int cy = cy2 + this.curry;
            int dx = dx2 + cx;
            int dy = dy2 + cy;
            this.currx = dx;
            this.curry = dy;
            this.shape.curve((double)dx / this.twips, (double)dy / this.twips, (double)cx / this.twips, (double)cy / this.twips);
        }

        public void move(int x, int y) {
            this.currx = x;
            this.curry = y;
            this.shape.move((double)x / this.twips, (double)y / this.twips);
        }
    }
}

