/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import pt.tumba.parser.swf.Actions;
import pt.tumba.parser.swf.AlphaTransform;
import pt.tumba.parser.swf.Instance;
import pt.tumba.parser.swf.Movie;
import pt.tumba.parser.swf.Placement;
import pt.tumba.parser.swf.SWFActions;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.Symbol;
import pt.tumba.parser.swf.TimeLine;
import pt.tumba.parser.swf.Transform;

public class Frame {
    protected int frameNumber;
    protected String label;
    protected List placements = new Vector();
    protected boolean stop;
    protected TimeLine timeline;
    protected Actions actions;

    protected Frame(int number, TimeLine timeline) {
        this.frameNumber = number;
        this.timeline = timeline;
    }

    public Actions getActions() {
        return this.actions;
    }

    public void setActions(Actions actions) {
        this.actions = actions;
    }

    public Actions actions(int flashVersion) {
        this.actions = new Actions(0, flashVersion);
        return this.actions;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public Placement[] getPlacements() {
        Placement[] p = new Placement[this.placements.size()];
        this.placements.toArray(p);
        return p;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void stop() {
        this.stop = true;
    }

    public Instance placeSymbol(Symbol symbol, int x, int y) {
        return this.placeSymbol(symbol, new Transform(x, y), null, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform matrix, AlphaTransform cxform) {
        return this.placeSymbol(symbol, matrix, cxform, -1, -1);
    }

    public Instance placeSymbol(Symbol symbol, Transform matrix2, AlphaTransform cxform, int ratio, int clipDepth) {
        Transform matrix = matrix2;
        int depth = this.timeline.getAvailableDepth();
        Instance inst = new Instance(symbol, depth);
        this.timeline.setAvailableDepth(depth + 1);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, null, ratio, clipDepth, this.frameNumber, false, false, null);
        this.placements.add(placement);
        return inst;
    }

    public Instance replaceSymbol(Symbol symbol, int depth, Transform matrix2, AlphaTransform cxform, int ratio, int clipDepth) {
        Transform matrix = matrix2;
        Instance inst = new Instance(symbol, depth);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, null, ratio, clipDepth, this.frameNumber, false, true, null);
        this.placements.add(placement);
        return inst;
    }

    public Instance placeMovieClip(Symbol symbol, Transform matrix2, AlphaTransform cxform, String name, Actions[] clipActions) {
        Transform matrix = matrix2;
        int depth = this.timeline.getAvailableDepth();
        Instance inst = new Instance(symbol, depth);
        this.timeline.setAvailableDepth(depth + 1);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, name, -1, -1, this.frameNumber, false, false, clipActions);
        this.placements.add(placement);
        return inst;
    }

    public Instance replaceMovieClip(Symbol symbol, int depth, Transform matrix2, AlphaTransform cxform, String name, Actions[] clipActions) {
        Transform matrix = matrix2;
        Instance inst = new Instance(symbol, depth);
        if (matrix == null) {
            matrix = new Transform();
        }
        Placement placement = new Placement(inst, matrix, cxform, name, -1, -1, this.frameNumber, false, true, clipActions);
        this.placements.add(placement);
        return inst;
    }

    public void remove(Instance instance) {
        this.placements.add(new Placement(instance, this.frameNumber));
    }

    public void alter(Instance instance, int x, int y) {
        this.alter(instance, new Transform(x, y), null, -1);
    }

    public void alter(Instance instance, Transform matrix, AlphaTransform cxform) {
        this.alter(instance, matrix, cxform, -1);
    }

    public void alter(Instance instance, Transform matrix, AlphaTransform cxform, int ratio) {
        Placement placement = new Placement(instance, matrix, cxform, null, ratio, -1, this.frameNumber, true, false, null);
        this.placements.add(placement);
    }

    protected void flushDefinitions(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
        Iterator iterator = this.placements.iterator();
        while (iterator.hasNext()) {
            Placement placement = (Placement)iterator.next();
            placement.flushDefinitions(movie, timelineWriter, definitionWriter);
        }
    }

    protected void write(Movie movie, SWFTagTypes movieTagWriter, SWFTagTypes timelineTagWriter) throws IOException {
        if (this.actions != null) {
            SWFActions acts = timelineTagWriter.tagDoAction();
            acts.start(0);
            acts.blob(this.actions.bytes);
            acts.done();
        }
        if (this.stop) {
            SWFActions actions = timelineTagWriter.tagDoAction();
            actions.start(0);
            actions.stop();
            actions.end();
            actions.done();
        }
        Iterator iterator = this.placements.iterator();
        while (iterator.hasNext()) {
            Placement placement = (Placement)iterator.next();
            placement.write(movie, movieTagWriter, timelineTagWriter);
        }
        if (this.label != null) {
            timelineTagWriter.tagFrameLabel(this.label);
        }
        timelineTagWriter.tagShowFrame();
    }
}

