/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.io.InputStream;
import pt.tumba.parser.swf.Color;
import pt.tumba.parser.swf.Movie;
import pt.tumba.parser.swf.SWFTagTypes;
import pt.tumba.parser.swf.Symbol;

public abstract class Image
extends Symbol {

    public static class Lossless
    extends Image {
        protected byte[] imageData;
        protected Color[] colorTable;
        protected double width;
        protected double height;
        protected boolean hasAlpha;
        protected int format;

        public Lossless(Color[] colorTable, byte[] imageData, double width, double height, boolean hasAlpha, int format) {
            this.colorTable = colorTable;
            this.imageData = imageData;
            this.width = width;
            this.height = height;
            this.hasAlpha = hasAlpha;
            this.format = format;
        }

        public byte[] getImageData() {
            return this.imageData;
        }

        public Color[] getColorTable() {
            return this.colorTable;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean hasAlpha() {
            return this.hasAlpha;
        }

        public int getFormat() {
            return this.format;
        }

        protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
            int id = this.getNextId(movie);
            if (this.hasAlpha) {
                definitionWriter.tagDefineBitsLossless2(id, this.format, (int)this.width, (int)this.height, this.colorTable, this.imageData);
            } else {
                definitionWriter.tagDefineBitsLossless(id, this.format, (int)this.width, (int)this.height, this.colorTable, this.imageData);
            }
            return id;
        }
    }

    public static class JPEG
    extends Image {
        protected InputStream jpegIn;
        protected byte[] jpegData;

        public JPEG(InputStream jpegImage) {
            this.jpegIn = jpegImage;
        }

        public JPEG(byte[] imageData) {
            this.jpegData = imageData;
        }

        public byte[] getImageData() {
            return this.jpegData;
        }

        protected int defineSymbol(Movie movie, SWFTagTypes timelineWriter, SWFTagTypes definitionWriter) throws IOException {
            int id = this.getNextId(movie);
            if (this.jpegData != null) {
                definitionWriter.tagDefineBitsJPEG2(id, this.jpegData);
            } else if (this.jpegIn != null) {
                definitionWriter.tagDefineBitsJPEG2(id, this.jpegIn);
            }
            return id;
        }
    }
}

