/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class InStream {
    protected InputStream in;
    protected long bytesRead = 0L;
    protected int bitBuf;
    protected int bitPos;

    public InStream(InputStream in) {
        this.in = in;
        this.bitBuf = 0;
        this.bitPos = 0;
    }

    public InStream(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public byte[] readStringBytes() throws IOException {
        this.synchBits();
        Vector<Byte> chars = new Vector<Byte>();
        byte[] aChar = new byte[1];
        int num = 0;
        while ((num = this.in.read(aChar)) == 1) {
            ++this.bytesRead;
            if (aChar[0] == 0) {
                byte[] string = new byte[chars.size()];
                int i = 0;
                Enumeration enumeration = chars.elements();
                while (enumeration.hasMoreElements()) {
                    string[i++] = (Byte)enumeration.nextElement();
                }
                return string;
            }
            chars.addElement(new Byte(aChar[0]));
        }
        throw new IOException("Unterminated string - reached end of input before null char");
    }

    public String readString() throws IOException {
        return new String(this.readStringBytes());
    }

    public byte[] read() throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int b = 0;
        while ((b = this.in.read()) >= 0) {
            bout.write(b);
        }
        return bout.toByteArray();
    }

    public byte[] read(int length) throws IOException {
        byte[] data = new byte[length];
        if (length > 0) {
            int read = 0;
            while (read < length) {
                int count = this.in.read(data, read, length - read);
                if (count < 0) {
                    this.bytesRead += (long)read;
                    throw new IOException("Unexpected end of input while reading a specified number of bytes");
                }
                read += count;
            }
            this.bytesRead += (long)read;
        }
        return data;
    }

    public void synchBits() {
        this.bitBuf = 0;
        this.bitPos = 0;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void setBytesRead(long read) {
        this.bytesRead = read;
    }

    public void skipBytes(long length) throws IOException {
        long skipped = 0L;
        while (skipped < length) {
            int val = this.in.read();
            if (val < 0) {
                throw new IOException("Unexpected end of input");
            }
            ++skipped;
        }
        this.bytesRead += length;
    }

    public long readUBits(int numBits) throws IOException {
        int shift;
        if (numBits == 0) {
            return 0L;
        }
        int bitsLeft = numBits;
        long result = 0L;
        if (this.bitPos == 0) {
            this.bitBuf = this.in.read();
            this.bitPos = 8;
            ++this.bytesRead;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= (long)(this.bitBuf << shift);
            bitsLeft -= this.bitPos;
            this.bitBuf = this.in.read();
            this.bitPos = 8;
            ++this.bytesRead;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= (long)(this.bitBuf >> -shift);
    }

    public int readUI8() throws IOException {
        this.synchBits();
        int ui8 = this.in.read();
        if (ui8 < 0) {
            throw new IOException("Unexpected end of input");
        }
        ++this.bytesRead;
        return ui8;
    }

    public int readUI16() throws IOException {
        this.synchBits();
        int ui16 = this.in.read();
        if (ui16 < 0) {
            throw new IOException("Unexpected end of input");
        }
        int val = this.in.read();
        if (val < 0) {
            throw new IOException("Unexpected end of input");
        }
        this.bytesRead += 2L;
        return ui16 += val << 8;
    }

    public short readSI16() throws IOException {
        this.synchBits();
        int lowerByte = this.in.read();
        if (lowerByte < 0) {
            throw new IOException("Unexpected end of input");
        }
        byte[] aByte = new byte[1];
        int count = this.in.read(aByte);
        if (count < 1) {
            throw new IOException("Unexpected end of input");
        }
        this.bytesRead += 2L;
        return (short)(aByte[0] * 256 + lowerByte);
    }

    public long readUI32() throws IOException {
        this.synchBits();
        long ui32 = this.in.read();
        if (ui32 < 0L) {
            throw new IOException("Unexpected end of input");
        }
        long val = this.in.read();
        if (val < 0L) {
            throw new IOException("Unexpected end of input");
        }
        ui32 += val << 8;
        val = this.in.read();
        if (val < 0L) {
            throw new IOException("Unexpected end of input");
        }
        ui32 += val << 16;
        val = this.in.read();
        if (val < 0L) {
            throw new IOException("Unexpected end of input");
        }
        this.bytesRead += 4L;
        return ui32 += val << 24;
    }

    public int readSBits(int numBits) throws IOException {
        long uBits = this.readUBits(numBits);
        if ((uBits & 1L << numBits - 1) != 0L) {
            uBits |= -1L << numBits;
        }
        return (int)uBits;
    }

    public int readSI32() throws IOException {
        this.synchBits();
        int b0 = this.in.read();
        if (b0 < 0) {
            throw new IOException("Unexpected end of input");
        }
        int b1 = this.in.read();
        if (b1 < 0) {
            throw new IOException("Unexpected end of input");
        }
        int b2 = this.in.read();
        if (b2 < 0) {
            throw new IOException("Unexpected end of input");
        }
        byte[] aByte = new byte[1];
        int count = this.in.read(aByte);
        if (count < 1) {
            throw new IOException("Unexpected end of input");
        }
        this.bytesRead += 4L;
        return aByte[0] * 256 * 256 * 256 + b2 * 256 * 256 + b1 * 256 + b0;
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readSI32());
    }

    public double readDouble() throws IOException {
        byte[] bytes = this.read(8);
        byte[] bytes2 = new byte[]{bytes[3], bytes[2], bytes[1], bytes[0], bytes[7], bytes[6], bytes[5], bytes[4]};
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes2);
        return new DataInputStream(bin).readDouble();
    }

    public static int ubyteToInt(byte b2) {
        int b;
        boolean highbit = b2 < 0;
        int i = b = (int)(b2 & 0x7F);
        if (highbit) {
            i += 128;
        }
        return i;
    }

    public static int bytesToSigned(byte lo, byte hi) {
        int low = InStream.ubyteToInt(lo);
        int high = InStream.ubyteToInt(hi);
        int value = (high << 8) + low;
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }
}

