/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class MP3Frame {
    public static final int MPEG_Version_2_5 = 0;
    public static final int MPEG_Version_2 = 2;
    public static final int MPEG_Version_1 = 3;
    public static final int MPEG_Layer_3 = 1;
    public static final int MPEG_Layer_2 = 2;
    public static final int MPEG_Layer_1 = 3;
    public static final int CHANNEL_MODE_STEREO = 0;
    public static final int CHANNEL_MODE_JOINT_STEREO = 1;
    public static final int CHANNEL_MODE_DUAL_CHANNEL = 2;
    public static final int CHANNEL_MODE_MONO = 3;
    public static final int EMPHASIS_NONE = 0;
    public static final int EMPHASIS_50_15_MS = 1;
    public static final int EMPHASIS_RESERVED = 2;
    public static final int EMPHASIS_CCIT_J17 = 3;
    protected static final int[] MPEG1BitRates;
    protected static final int[] MPEG2BitRates;
    protected static final int[] MPEG10SampleRates;
    protected static final int[] MPEG20SampleRates;
    protected static final int[] MPEG25SampleRates;
    private static int FRAME_SAMPLES_MPEG_1;
    private static int FRAME_SAMPLES_MPEG_2;
    protected int mpegVersion;
    protected int mpegLayer;
    protected boolean isProtected;
    protected int bitRate;
    protected int sampleRate;
    protected boolean padded;
    protected int channelMode;
    protected int modeExtension;
    protected boolean copyrighted;
    protected boolean original;
    protected int emphasis;
    protected byte[] data;
    protected int bit_rate;
    protected int sample_rate;

    static {
        int[] nArray = new int[16];
        nArray[1] = 32000;
        nArray[2] = 40000;
        nArray[3] = 48000;
        nArray[4] = 56000;
        nArray[5] = 64000;
        nArray[6] = 80000;
        nArray[7] = 96000;
        nArray[8] = 112000;
        nArray[9] = 128000;
        nArray[10] = 160000;
        nArray[11] = 192000;
        nArray[12] = 224000;
        nArray[13] = 256000;
        nArray[14] = 320000;
        MPEG1BitRates = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 8000;
        nArray2[2] = 16000;
        nArray2[3] = 24000;
        nArray2[4] = 32000;
        nArray2[5] = 40000;
        nArray2[6] = 48000;
        nArray2[7] = 56000;
        nArray2[8] = 64000;
        nArray2[9] = 80000;
        nArray2[10] = 96000;
        nArray2[11] = 112000;
        nArray2[12] = 128000;
        nArray2[13] = 144000;
        nArray2[14] = 160000;
        MPEG2BitRates = nArray2;
        int[] nArray3 = new int[4];
        nArray3[0] = 44100;
        nArray3[1] = 48000;
        nArray3[2] = 32000;
        MPEG10SampleRates = nArray3;
        int[] nArray4 = new int[4];
        nArray4[0] = 22050;
        nArray4[1] = 24000;
        nArray4[2] = 16000;
        MPEG20SampleRates = nArray4;
        int[] nArray5 = new int[4];
        nArray5[0] = 11025;
        nArray5[1] = 12000;
        nArray5[2] = 8000;
        MPEG25SampleRates = nArray5;
        FRAME_SAMPLES_MPEG_1 = 1152;
        FRAME_SAMPLES_MPEG_2 = 576;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public boolean isStereo() {
        return this.channelMode != 3;
    }

    public int getDataLength() {
        return this.data.length;
    }

    public int getSamplesPerFrame() {
        if (this.mpegVersion == 3) {
            return FRAME_SAMPLES_MPEG_1;
        }
        return FRAME_SAMPLES_MPEG_2;
    }

    public static MP3Frame readFrame(InputStream in) throws IOException {
        int r;
        int b;
        MP3Frame frame = new MP3Frame();
        while (true) {
            if ((b = in.read()) < 0) {
                return null;
            }
            if (b != 255) continue;
            b = in.read();
            if (b < 0) {
                return null;
            }
            if ((b & 0xE0) != 224) continue;
            frame.mpegVersion = (b & 0x18) >> 3;
            frame.mpegLayer = (b & 6) >> 1;
            boolean bl = frame.isProtected = (b & 1) == 0;
            if (frame.mpegLayer == 1) break;
        }
        if (frame.isProtected) {
            in.read();
            in.read();
        }
        if ((b = in.read()) < 0) {
            return null;
        }
        frame.bit_rate = (b & 0xF0) >> 4;
        frame.bitRate = frame.mpegVersion == 3 ? MPEG1BitRates[frame.bit_rate] : MPEG2BitRates[frame.bit_rate];
        frame.sample_rate = (b & 0xC) >> 2;
        frame.sampleRate = frame.mpegVersion == 3 ? MPEG10SampleRates[frame.sample_rate] : (frame.mpegVersion == 2 ? MPEG20SampleRates[frame.sample_rate] : MPEG25SampleRates[frame.sample_rate]);
        frame.padded = (b & 2) != 0;
        b = in.read();
        if (b < 0) {
            return null;
        }
        frame.channelMode = (b & 0xC0) >> 6;
        frame.modeExtension = (b & 0x30) >> 4;
        frame.copyrighted = (b & 0x80) >> 3 != 0;
        frame.original = (b & 0x40) >> 2 != 0;
        frame.emphasis = b & 2;
        int size = (frame.mpegVersion == 3 ? 144 : 72) * frame.bitRate / frame.sampleRate + (frame.padded ? 1 : 0) - 4;
        byte[] data = new byte[size];
        int read = 0;
        while ((r = in.read(data, read, size - read)) >= 0 && read < size) {
            read += r;
        }
        if (read != size) {
            throw new IOException("Unexpected end of MP3 data");
        }
        frame.data = data;
        return frame;
    }

    public void write(OutputStream out) throws IOException {
        out.write(255);
        int b = 225;
        b |= this.mpegVersion << 3;
        out.write(b |= this.mpegLayer << 1);
        b = this.bit_rate << 4;
        b |= this.sample_rate << 2;
        if (this.padded) {
            b |= 2;
        }
        out.write(b);
        b = this.channelMode << 6;
        b |= this.modeExtension << 4;
        out.write(b |= this.emphasis);
        out.write(this.data);
    }

    public String toString() {
        String version = null;
        if (this.mpegVersion == 3) {
            version = "1";
        } else if (this.mpegVersion == 2) {
            version = "2";
        } else if (this.mpegVersion == 0) {
            version = "2.5";
        }
        return "MP3 Frame:  version=" + version + " bit-rate=" + this.bitRate + " sample-rate=" + this.sampleRate + " stereo=" + (this.channelMode != 3);
    }
}

