/*
 * Decompiled with CFR 0.152.
 */
package pt.tumba.parser.swf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import pt.tumba.parser.swf.InStream;
import pt.tumba.parser.swf.Rect;
import pt.tumba.parser.swf.SWFTags;
import pt.tumba.parser.swf.SWFWriter;

public class SWFReader {
    protected SWFTags consumer;
    protected InStream in;
    protected InputStream inputstream;
    public int size;

    public SWFReader(SWFTags consumer, InputStream inputstream) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.size = 0;
        try {
            int aux;
            while ((aux = inputstream.read()) != -1) {
                ++this.size;
                out.write((char)aux);
            }
        }
        catch (Exception e) {
            int aux = -1;
        }
        this.consumer = consumer;
        this.inputstream = new ByteArrayInputStream(out.toByteArray());
        this.in = new InStream(this.inputstream);
    }

    public SWFReader(SWFTags consumer, InStream instream) {
        this.consumer = consumer;
        this.in = instream;
        this.size = (int)this.in.bytesRead;
    }

    public void readFile() throws IOException {
        this.readHeader();
        this.readTags();
    }

    public void readTags() throws IOException {
        while (this.readOneTag() != 0) {
        }
    }

    public int readOneTag() throws IOException {
        boolean longTag;
        int header = this.in.readUI16();
        int type = header >> 6;
        int length = header & 0x3F;
        boolean bl = longTag = length == 63;
        if (longTag) {
            length = (int)this.in.readUI32();
        }
        byte[] contents = this.in.read(length);
        this.consumer.tag(type, longTag, contents);
        return type;
    }

    public void readHeader() throws IOException {
        int version = this.in.readUI8();
        long length = this.in.readUI32();
        Rect frameSize = new Rect(this.in);
        int frameRate = this.in.readUI16() >> 8;
        int frameCount = this.in.readUI16();
        this.consumer.header(version, length, frameSize.getMaxX(), frameSize.getMaxY(), frameRate, frameCount);
    }

    public static void main(String[] args) throws IOException {
        SWFWriter writer = new SWFWriter(System.out);
        SWFReader reader = new SWFReader((SWFTags)writer, System.in);
        reader.readFile();
        System.out.flush();
    }
}

